/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class RemoveUnnecessaryReturn {
    public static ErrorDescription hint(HintContext ctx) {
        TreePath tp = ctx.getPath();
        block7: while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            List<? extends StatementTree> statements;
            Tree current = tp.getLeaf();
            tp = tp.getParentPath();
            switch (tp.getLeaf().getKind()) {
                case METHOD: {
                    MethodTree mt = (MethodTree)tp.getLeaf();
                    if (mt.getReturnType() == null) {
                        if (mt.getName().contentEquals("<init>")) break block7;
                        return null;
                    }
                    TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, mt.getReturnType()));
                    if (tm != null && tm.getKind() == TypeKind.VOID) break block7;
                    return null;
                }
                case BLOCK: {
                    statements = ((BlockTree)tp.getLeaf()).getStatements();
                    break;
                }
                case CASE: {
                    boolean exits = Utilities.exitsFromAllBranchers(ctx.getInfo(), tp);
                    if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.SWITCH) {
                        List<? extends CaseTree> cases = ((SwitchTree)tp.getParentPath().getLeaf()).getCases();
                        exits |= cases.get(cases.size() - 1) == tp.getLeaf();
                    }
                    if (!exits) {
                        return null;
                    }
                    statements = ((CaseTree)tp.getLeaf()).getStatements();
                    break;
                }
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case WHILE_LOOP: {
                    return null;
                }
                case TRY: {
                    if (((TryTree)tp.getLeaf()).getFinallyBlock() == current) {
                        return null;
                    }
                }
                default: {
                    continue block7;
                }
            }
            assert (!statements.isEmpty());
            if (statements.get(statements.size() - 1) == current) continue;
            return null;
        }
        String displayName = NbBundle.getMessage(RemoveUnnecessaryReturn.class, (String)"ERR_UnnecessaryReturnStatement");
        String fixDisplayName = NbBundle.getMessage(RemoveUnnecessaryReturn.class, (String)"FIX_UnnecessaryReturnStatement");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, JavaFix.removeFromParent(ctx, fixDisplayName, ctx.getPath()));
    }
}

