/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OrganizeImports {
    public static ErrorDescription checkImports(HintContext context) {
        List diffs;
        Source source = context.getInfo().getSnapshot().getSource();
        ModificationResult result = null;
        try {
            result = ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    OrganizeImports.doOrganizeImports(copy);
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List list = diffs = result != null ? result.getDifferences(source.getFileObject()) : null;
        if (diffs != null && !diffs.isEmpty()) {
            Fix fix = JavaFix.toEditorFix(new OrganizeImportsFix(context.getInfo(), context.getPath()));
            return ErrorDescriptionFactory.forTree(context, context.getInfo().getCompilationUnit().getImports().get(0), NbBundle.getMessage(OrganizeImports.class, (String)"MSG_OragnizeImports"), fix);
        }
        return null;
    }

    private static void doOrganizeImports(WorkingCopy copy) throws IllegalStateException {
        HashSet<Element> staticStarImports;
        CodeStyle cs;
        HashSet<Element> starImports;
        Set<Element> toImport;
        CompilationUnitTree cu = copy.getCompilationUnit();
        if (!cu.getImports().isEmpty() && !(toImport = OrganizeImports.getUsedElements((CompilationInfo)copy, cu, starImports = (cs = CodeStyle.getDefault((FileObject)copy.getFileObject())).countForUsingStarImport() == Integer.MAX_VALUE ? new HashSet<Element>() : null, staticStarImports = cs.countForUsingStaticStarImport() == Integer.MAX_VALUE ? new HashSet<Element>() : null)).isEmpty()) {
            List imps;
            TreeMaker maker = copy.getTreeMaker();
            if (starImports != null || staticStarImports != null) {
                imps = new LinkedList();
                Trees trees = copy.getTrees();
                for (ImportTree importTree : cu.getImports()) {
                    Tree qualIdent = importTree.getQualifiedIdentifier();
                    if (qualIdent.getKind() != Tree.Kind.MEMBER_SELECT || !"*".contentEquals(((MemberSelectTree)qualIdent).getIdentifier())) continue;
                    if (importTree.isStatic()) {
                        if (staticStarImports == null || !staticStarImports.contains(trees.getElement(TreePath.getPath(cu, (Tree)((MemberSelectTree)qualIdent).getExpression())))) continue;
                        imps.add(maker.Import(qualIdent, true));
                        continue;
                    }
                    if (starImports == null || !starImports.contains(trees.getElement(TreePath.getPath(cu, (Tree)((MemberSelectTree)qualIdent).getExpression())))) continue;
                    imps.add(maker.Import(qualIdent, false));
                }
                Collections.sort(imps, new Comparator<ImportTree>(){
                    private CodeStyle.ImportGroups groups;
                    {
                        this.groups = cs.getImportGroups();
                    }

                    @Override
                    public int compare(ImportTree o1, ImportTree o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        String s1 = o1.getQualifiedIdentifier().toString();
                        String s2 = o2.getQualifiedIdentifier().toString();
                        int bal = this.groups.getGroupId(s1, o1.isStatic()) - this.groups.getGroupId(s2, o2.isStatic());
                        return bal == 0 ? s1.compareTo(s2) : bal;
                    }
                });
            } else {
                imps = Collections.emptyList();
            }
            CompilationUnitTree cut = maker.CompilationUnit(cu.getPackageAnnotations(), cu.getPackageName(), imps, cu.getTypeDecls(), cu.getSourceFile());
            ((JCTree.JCCompilationUnit)cut).packge = ((JCTree.JCCompilationUnit)cu).packge;
            CompilationUnitTree ncu = GeneratorUtilities.get((WorkingCopy)copy).addImports(cut, toImport);
            copy.rewrite((Tree)cu, (Tree)ncu);
        }
    }

    private static Set<Element> getUsedElements(final CompilationInfo info, final CompilationUnitTree cut, final Set<Element> starImports, final Set<Element> staticStarImports) {
        final HashSet<Element> ret = new HashSet<Element>();
        final Trees trees = info.getTrees();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                this.addElement(trees.getElement(this.getCurrentPath()));
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitClass(node, p);
            }

            @Override
            public Void visitMethod(MethodTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitMethod(node, p);
            }

            @Override
            public Void visitVariable(VariableTree node, Void p) {
                for (TypeElement element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitVariable(node, p);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }

            private void addElement(Element element) {
                if (element != null) {
                    switch (element.getKind()) {
                        case ENUM_CONSTANT: 
                        case FIELD: 
                        case METHOD: {
                            Element glob;
                            if (!element.getModifiers().contains((Object)Modifier.STATIC) || (glob = this.global(element, staticStarImports)) == null) break;
                            ret.add(glob);
                            break;
                        }
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            Element glob = this.global(element, starImports);
                            if (glob == null) break;
                            ret.add(glob);
                        }
                    }
                }
            }

            private Element global(Element element, Set<Element> stars) {
                Scope.Entry e = ((JCTree.JCCompilationUnit)cut).namedImportScope.lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        return e.sym;
                    }
                    e = e.next();
                }
                e = ((JCTree.JCCompilationUnit)cut).packge.members().lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        return e.sym;
                    }
                    e = e.next();
                }
                e = ((JCTree.JCCompilationUnit)cut).starImportScope.lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        if (stars != null) {
                            stars.add(e.sym.owner);
                        }
                        return e.sym;
                    }
                    e = e.next();
                }
                return null;
            }
        }.scan(cut, null);
        return ret;
    }

    private static final class OrganizeImportsFix
    extends JavaFix {
        public OrganizeImportsFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(OrganizeImports.class, (String)"FIX_OrganizeImports");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, boolean canShowUI) {
            OrganizeImports.doOrganizeImports(wc);
        }
    }
}

