/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class EqualsMethodHint {
    public static ErrorDescription run(HintContext ctx) {
        TreePath paramPath = ctx.getVariables().get("$param");
        assert (paramPath != null);
        Element param = ctx.getInfo().getTrees().getElement(paramPath);
        if (param == null || param.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        for (TreePath treePath : ctx.getMultiVariables().get("$statements$")) {
            try {
                new VisitorImpl(ctx.getInfo(), param).scan(treePath, null);
            }
            catch (Found f) {
                return null;
            }
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(EqualsMethodHint.class, (String)"ERR_EQUALS_NOT_CHECKING_TYPE"), new Fix[0]);
    }

    private static final class Found
    extends RuntimeException {
        private Found() {
        }
    }

    private static final class VisitorImpl
    extends TreePathScanner<Void, Void> {
        private CompilationInfo info;
        private Element parameter;

        public VisitorImpl(CompilationInfo info, Element parameter) {
            this.info = info;
            this.parameter = parameter;
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree node, Void p) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (((Object)this.parameter).equals(e)) {
                throw new Found();
            }
            return (Void)super.visitInstanceOf(node, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (node.getArguments().isEmpty() && node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree mst = (MemberSelectTree)node.getMethodSelect();
                Element e = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), mst), mst.getExpression()));
                if (((Object)this.parameter).equals(e) && mst.getIdentifier().contentEquals("getClass")) {
                    throw new Found();
                }
            }
            return (Void)super.visitMethodInvocation(node, p);
        }
    }
}

