/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddOverrideAnnotation
extends AbstractHint {
    public AddOverrideAnnotation() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        TypeElement el = compilationInfo.getElements().getTypeElement("java.lang.Override");
        if (el == null || !GeneratorUtils.supportsOverride((CompilationInfo)compilationInfo)) {
            return null;
        }
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e != null && e.getKind() == ElementKind.METHOD) {
            ExecutableElement ee = (ExecutableElement)e;
            ArrayList result = new ArrayList();
            AnnotationType type = ComputeOverriding.detectOverrides((CompilationInfo)compilationInfo, (TypeElement)((TypeElement)ee.getEnclosingElement()), (ExecutableElement)ee, result);
            boolean hasOverriddenAnnotation = false;
            for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                if (!compilationInfo.getTypes().isSameType(annotationMirror.getAnnotationType(), el.asType())) continue;
                hasOverriddenAnnotation = true;
                break;
            }
            if (hasOverriddenAnnotation) {
                return null;
            }
            boolean addHint = false;
            if (type == AnnotationType.OVERRIDES) {
                addHint = true;
            } else if (type == AnnotationType.IMPLEMENTS) {
                boolean bl = addHint = compilationInfo.getSourceVersion() != SourceVersion.RELEASE_5;
            }
            if (addHint) {
                List<Fix> list = Collections.singletonList(JavaFix.toEditorFix(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject())));
                int[] span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                if (span != null) {
                    String desc = NbBundle.getMessage(AddOverrideAnnotation.class, (String)"HINT_AddOverrideAnnotation");
                    ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)desc, list, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
                    return Collections.singletonList(ed);
                }
            }
        }
        return null;
    }

    @Override
    public String getId() {
        return AddOverrideAnnotation.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"DN_AddOverrideAnnotation");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"DESC_AddOverrideAnnotation");
    }

    @Override
    public void cancel() {
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private FileObject file;
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

        public FixImpl(TreePathHandle handle, FileObject file) {
            super(handle);
            this.file = file;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(AddOverrideAnnotation.class, (String)"FIX_AddOverrideAnnotation");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath path, boolean canShowUI) {
            while (path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind())) {
                path = path.getParentPath();
            }
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return;
            }
            Tree top = path.getLeaf();
            ModifiersTree modifiers = null;
            switch (top.getKind()) {
                case METHOD: {
                    modifiers = ((MethodTree)top).getModifiers();
                    break;
                }
                default: {
                    assert (false) : "Unhandled Tree.Kind";
                    break;
                }
            }
            if (modifiers == null) {
                return;
            }
            TypeElement el = copy.getElements().getTypeElement("java.lang.Override");
            if (el == null) {
                return;
            }
            for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                TreePath tp = new TreePath(new TreePath(path, annotationTree), annotationTree.getAnnotationType());
                Element e = copy.getTrees().getElement(tp);
                if (!el.equals(e)) continue;
                return;
            }
            ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
            annotations.add(copy.getTreeMaker().Annotation((Tree)copy.getTreeMaker().QualIdent((Element)el), Collections.emptyList()));
            ModifiersTree modifiersTree = copy.getTreeMaker().Modifiers(modifiers, annotations);
            copy.rewrite((Tree)modifiers, (Tree)modifiersTree);
        }
    }
}

