/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.indexing.CssIndex;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.refactoring.CssElementContext;
import org.netbeans.modules.css.refactoring.CssRefactoringExtraInfo;
import org.netbeans.modules.css.refactoring.DiffElement;
import org.netbeans.modules.css.refactoring.RetoucheCommit;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.FileReferenceModification;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CssRenameRefactoringPlugin
implements RefactoringPlugin {
    private static final String SELECTOR_RENAME_MSG_KEY = "MSG_Rename_Selector";
    private static final String COLOR_RENAME_MSG_KEY = "MSG_Rename_Color";
    private static final String UNRELATED_PREFIX_MSG_KEY = "MSG_Unrelated_Prefix";
    private static final Logger LOGGER = Logger.getLogger(CssRenameRefactoringPlugin.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private RenameRefactoring refactoring;
    private Lookup lookup;
    private CssElementContext context;

    public CssRenameRefactoringPlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.lookup = refactoring.getRefactoringSource();
        this.context = (CssElementContext)this.lookup.lookup(CssElementContext.class);
        if (this.context == null) {
            FileObject folder = (FileObject)this.lookup.lookup(FileObject.class);
            assert (folder != null);
            assert (folder.isFolder());
            this.context = new CssElementContext.Folder(folder);
        }
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        String newName = this.refactoring.getNewName();
        if (newName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_ElementEmpty"));
        }
        if (this.context instanceof CssElementContext.Editor) {
            CssElementContext.Editor editorContext = (CssElementContext.Editor)this.context;
            char firstChar = this.refactoring.getNewName().charAt(0);
            switch (editorContext.getElement().type()) {
                case cssId: 
                case hexColor: {
                    if (firstChar == '#') break;
                    return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_MissingHash"));
                }
                case cssClass: {
                    if (firstChar == '.') break;
                    return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_MissingDot"));
                }
            }
            if (newName.length() == 1) {
                return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_ElementShortName"));
            }
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        CssProjectSupport sup = CssProjectSupport.findFor(this.context.getFileObject());
        if (sup == null) {
            return null;
        }
        CssIndex index = sup.getIndex();
        ModificationResult modificationResult = new ModificationResult();
        if (this.context instanceof CssElementContext.Editor) {
            Collection<FileObject> files;
            CssElementContext.Editor econtext = (CssElementContext.Editor)this.context;
            NodeType kind = econtext.getElement().type();
            String elementImage = econtext.getElementName();
            if (kind == NodeType.cssClass) {
                int elementPrefixLength = 1;
                elementImage = elementImage.substring(elementPrefixLength);
                files = index.findClasses(elementImage);
                this.refactor(this.lookup, modificationResult, RefactoringElementType.CLASS, files, elementPrefixLength, econtext, index, SELECTOR_RENAME_MSG_KEY);
            } else if (kind == NodeType.cssId) {
                int elementPrefixLength = 1;
                elementImage = elementImage.substring(elementPrefixLength);
                files = index.findIds(elementImage);
                this.refactor(this.lookup, modificationResult, RefactoringElementType.ID, files, elementPrefixLength, econtext, index, SELECTOR_RENAME_MSG_KEY);
            } else if (kind == NodeType.hexColor) {
                Collection<FileObject> files2 = index.findColor(elementImage);
                this.refactor(this.lookup, modificationResult, RefactoringElementType.COLOR, files2, 0, econtext, index, COLOR_RENAME_MSG_KEY);
            } else if (kind == NodeType.elementName) {
                this.refactorElement(modificationResult, econtext, index);
            }
        } else if (this.context instanceof CssElementContext.File) {
            CssElementContext.File fileContext = (CssElementContext.File)this.context;
            this.refactorFile(modificationResult, fileContext, index);
        } else if (this.context instanceof CssElementContext.Folder) {
            CssElementContext.Folder folderContext = (CssElementContext.Folder)this.context;
            this.refactorFolder(modificationResult, folderContext, index);
            refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameFolder(folderContext.getFileObject()));
        }
        refactoringElements.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
        return null;
    }

    private void refactorFile(ModificationResult modificationResult, CssElementContext.File context, CssIndex index) {
        LOGGER.log(Level.FINE, "refactor file {0}", context.getFileObject().getPath());
        String newName = this.refactoring.getNewName();
        DependenciesGraph deps = index.getDependencies(context.getFileObject());
        Collection refering = deps.getSourceNode().getReferingNodes();
        for (DependenciesGraph.Node ref : refering) {
            FileObject file = ref.getFile();
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                CssFileModel model = CssFileModel.create(source);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : model.getImports()) {
                    String imp = entry.getName();
                    FileObject resolvedFileObject = WebUtils.resolve((FileObject)file, (String)imp);
                    if (resolvedFileObject == null || !resolvedFileObject.equals(context.getFileObject()) || !entry.isValidInSourceDocument()) continue;
                    String extension = context.getFileObject().getExt();
                    int slashIndex = imp.lastIndexOf(47);
                    String newImport = slashIndex != -1 ? imp.substring(0, slashIndex) + "/" + newName + "." + extension : newName + "." + extension;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newImport, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Modify_Css_File_Import")));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(file, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void refactorFolder(ModificationResult modificationResult, CssElementContext.Folder context, CssIndex index) {
        LOGGER.log(Level.FINE, "refactor folder {0}", context.getFileObject().getPath());
        String newName = this.refactoring.getNewName();
        try {
            CssIndex.AllDependenciesMaps alldeps = index.getAllDependencies();
            Map<FileObject, Collection<FileReference>> source2dest = alldeps.getSource2dest();
            FileObject renamedFolder = context.getFileObject();
            WeakHashMap<FileObject, CssFileModel> modelsCache = new WeakHashMap<FileObject, CssFileModel>();
            HashSet<Entry> refactoredReferenceEntries = new HashSet<Entry>();
            for (FileObject source : source2dest.keySet()) {
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                Collection<FileReference> destinations = source2dest.get(source);
                for (FileReference dest : destinations) {
                    FileReferenceModification modification = dest.createModification();
                    if (!modification.rename(renamedFolder, newName)) continue;
                    CssFileModel model = (CssFileModel)modelsCache.get(source);
                    if (model == null) {
                        try {
                            model = CssFileModel.create(Source.create((FileObject)source));
                            modelsCache.put(source, model);
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (model == null) continue;
                    Collection<Entry> imports = model.getImports();
                    for (Entry entry : imports) {
                        if (refactoredReferenceEntries.contains(entry) || !entry.isValidInSourceDocument() || !entry.getName().equals(dest.linkPath())) continue;
                        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)source);
                        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), modification.getModifiedReferencePath(), NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Modify_Css_File_Import")));
                        refactoredReferenceEntries.add(entry);
                    }
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(source, diffs);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void refactorElement(ModificationResult modificationResult, CssElementContext.Editor context, CssIndex index) {
        Node element = context.getElement();
        String elementImage = ((Object)element.image()).toString();
        CssFileModel model = CssFileModel.create(context.getParserResult());
        ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)context.getFileObject());
        for (Entry entry : model.getHtmlElements()) {
            if (!entry.isValidInSourceDocument() || !elementImage.equals(entry.getName())) continue;
            diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), this.refactoring.getNewName(), NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)SELECTOR_RENAME_MSG_KEY)));
        }
        if (!diffs.isEmpty()) {
            modificationResult.addDifferences(context.getFileObject(), diffs);
        }
    }

    private void refactor(Lookup lookup, ModificationResult modificationResult, RefactoringElementType type, Collection<FileObject> files, int elementPrefixLenght, CssElementContext.Editor context, CssIndex index, String renameMsgKey) {
        String elementImage = context.getElementName().substring(elementPrefixLenght);
        LinkedList<FileObject> involvedFiles = new LinkedList<FileObject>(files);
        DependenciesGraph deps = index.getDependencies(context.getFileObject());
        Collection relatedFiles = deps.getAllRelatedFiles();
        CssRefactoringExtraInfo extraInfo = (CssRefactoringExtraInfo)lookup.lookup(CssRefactoringExtraInfo.class);
        if (extraInfo == null || !extraInfo.isRefactorAll()) {
            involvedFiles.retainAll(relatedFiles);
        }
        if (LOG) {
            LOGGER.log(Level.FINE, "Refactoring element {0} in file {1}", new Object[]{elementImage, context.getFileObject().getPath()});
            LOGGER.log(Level.FINE, "Involved files declaring the element {0}:", elementImage);
            for (FileObject fo : involvedFiles) {
                LOGGER.log(Level.FINE, "{0}\n", fo.getPath());
            }
        }
        String newName = this.refactoring.getNewName().substring(elementPrefixLenght);
        for (FileObject file : involvedFiles) {
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                CssFileModel model = CssFileModel.create(source);
                Collection<Entry> entries = model.get(type);
                boolean related = relatedFiles.contains(file);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : entries) {
                    if (!entry.isValidInSourceDocument() || !LexerUtils.equals((CharSequence)elementImage, (CharSequence)entry.getName(), (type == RefactoringElementType.COLOR ? 1 : 0) != 0, (boolean)false)) continue;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newName, related ? NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey) : NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)UNRELATED_PREFIX_MSG_KEY) + " " + NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey)));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(file, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class RenameFolder
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private String oldName;

        public RenameFolder(FileObject fo) {
            this.fo = fo;
        }

        public String getText() {
            return NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"TXT_RenameFolder", (Object)this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                this.oldName = this.fo.getName();
                DataObject.find((FileObject)this.fo).rename(CssRenameRefactoringPlugin.this.refactoring.getNewName());
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void undoChange() {
            try {
                DataObject.find((FileObject)this.fo).rename(this.oldName);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

