/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.api.CssCslParserResult;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssIndexer
extends EmbeddingIndexer {
    private static final Logger LOGGER = Logger.getLogger(CssIndexer.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String CSS_CONTENT_KEY = "cssContent";
    public static final String IMPORTS_KEY = "imports";
    public static final String IDS_KEY = "ids";
    public static final String CLASSES_KEY = "classes";
    public static final String HTML_ELEMENTS_KEY = "htmlElements";
    public static final String COLORS_KEY = "colors";
    private static final Map<FileObject, AtomicLong> importsHashCodes = new HashMap<FileObject, AtomicLong>();
    private static Map<FileObject, AtomicLong> computedImportsHashCodes = new HashMap<FileObject, AtomicLong>();

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            if (LOG) {
                FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
                LOGGER.log(Level.FINE, "indexing {0}", fo.getPath());
            }
            CssCslParserResult wrapper = (CssCslParserResult)parserResult;
            CssFileModel model = CssFileModel.create(wrapper.getWrappedCssParserResult());
            IndexingSupport support = IndexingSupport.getInstance((Context)context);
            IndexDocument document = support.createDocument(indexable);
            this.storeEntries(model.getIds(), document, IDS_KEY);
            this.storeEntries(model.getClasses(), document, CLASSES_KEY);
            this.storeEntries(model.getHtmlElements(), document, HTML_ELEMENTS_KEY);
            this.storeEntries(model.getColors(), document, COLORS_KEY);
            int entriesHashCode = this.storeEntries(model.getImports(), document, IMPORTS_KEY);
            FileObject root = context.getRoot();
            AtomicLong aggregatedHash = importsHashCodes.get(root);
            if (aggregatedHash == null) {
                aggregatedHash = new AtomicLong(0L);
                importsHashCodes.put(root, aggregatedHash);
            }
            aggregatedHash.set(aggregatedHash.get() * 79L + (long)entriesHashCode);
            document.addPair(CSS_CONTENT_KEY, Boolean.TRUE.toString(), true, true);
            support.addDocument(document);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static long getImportsHashCodeForRoots(Collection<FileObject> roots) {
        long hash = 5L;
        for (FileObject root : roots) {
            AtomicLong rootHash = computedImportsHashCodes.get(root);
            if (rootHash == null) continue;
            hash = hash * 51L + rootHash.longValue();
        }
        return hash;
    }

    private int storeEntries(Collection<Entry> entries, IndexDocument doc, String key) {
        if (!entries.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Entry> i = entries.iterator();
            while (i.hasNext()) {
                sb.append(i.next().getName());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(';');
            doc.addPair(key, sb.toString(), true, true);
            return sb.toString().hashCode();
        }
        return 0;
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "css";
        static final int VERSION = 1;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new CssIndexer();
            }
            return null;
        }

        public boolean scanStarted(Context context) {
            importsHashCodes.remove(context.getRoot());
            return super.scanStarted(context);
        }

        public void scanFinished(Context context) {
            computedImportsHashCodes = new HashMap(importsHashCodes);
            super.scanFinished(context);
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        private boolean isIndexable(Snapshot snapshot) {
            return "text/x-css".equals(snapshot.getMimeType());
        }
    }
}

