/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;

public abstract class GrammarElement {
    private GroupGrammarElement parent;
    private String path;
    private int minimum_occurances = 1;
    private int maximum_occurances = 1;

    public GrammarElement(GroupGrammarElement parent) {
        this.parent = parent;
    }

    void setMinimumOccurances(int i) {
        this.minimum_occurances = i;
    }

    void setMaximumOccurances(int i) {
        this.maximum_occurances = i;
    }

    public int getMaximumOccurances() {
        return this.maximum_occurances;
    }

    public int getMinimumOccurances() {
        return this.minimum_occurances;
    }

    public GroupGrammarElement parent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GrammarElement)) {
            return false;
        }
        GrammarElement e = (GrammarElement)o;
        return this.path().equalsIgnoreCase(e.path());
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String origin() {
        for (GroupGrammarElement p = this.parent; p != null; p = p.parent()) {
            if (p.referenceName == null) continue;
            return p.referenceName;
        }
        return null;
    }

    public String getResolvedOrigin() {
        String origin = this.origin();
        if (origin == null) {
            return null;
        }
        if (GrammarParser.isArtificialElementName(origin)) {
            GrammarElement parentElement = this;
            while ((parentElement = parentElement.parent()) != null) {
                if (parentElement.origin() == null || GrammarParser.isArtificialElementName(parentElement.origin())) continue;
                origin = parentElement.origin();
                break;
            }
        }
        return origin;
    }

    public synchronized String path() {
        if (this.path == null) {
            StringBuilder sb = new StringBuilder();
            if (this.parent() != null) {
                sb.append(this.parent().path());
                sb.append('/');
            }
            sb.append(this.toString());
            this.path = sb.toString();
        }
        return this.path;
    }

    public String toString() {
        if (this.getMinimumOccurances() != 1 || this.getMaximumOccurances() != 1) {
            return "{" + this.getMinimumOccurances() + "," + (this.getMaximumOccurances() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaximumOccurances())) + "}";
        }
        return "";
    }

    public String toString2(int level) {
        return this.indentString(level) + this.toString();
    }

    protected String indentString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }
}

