/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.java.j2seproject.api.J2SERunConfigProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.ui.customizer.vmo.OptionsDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    public static final Logger log = Logger.getLogger(CustomizerRun.class.getName());
    private J2SEProject project;
    private JTextField[] data;
    private JLabel[] dataLabels;
    private String[] keys;
    private Map<String, Map<String, String>> configs;
    J2SEProjectProperties uiProperties;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private J2SERunConfigProvider compProviderDeprecated;
    private int nextExtensionYPos;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSep;
    private JButton customizeOptionsButton;
    private JPanel extPanel;
    private JButton jButtonMainClass;
    private JButton jButtonWorkingDirectoryBrowse;
    private JLabel jLabelArgs;
    private JLabel jLabelMainClass;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextField jTextVMOptions;
    private JTextField jTextWorkingDirectory;
    private JPanel mainPanel;

    public CustomizerRun(J2SEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getProject();
        this.nextExtensionYPos = 0;
        this.compProviderDeprecated = (J2SERunConfigProvider)Lookup.getDefault().lookup(J2SERunConfigProvider.class);
        this.initExtPanel(this.project);
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.RUN || !this.addExtPanel(this.project, compProvider, this.nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++this.nextExtensionYPos;
        }
        this.addPanelFiller(this.nextExtensionYPos);
        this.configs = uiProperties.RUN_CONFIGS;
        this.data = new JTextField[]{this.jTextFieldMainClass, this.jTextFieldArgs, this.jTextVMOptions, this.jTextWorkingDirectory};
        this.dataLabels = new JLabel[]{this.jLabelMainClass, this.jLabelArgs, this.jLabelVMOptions, this.jLabelWorkingDirectory};
        this.keys = new String[]{"main.class", "application.args", "run.jvmargs", "work.dir"};
        assert (this.data.length == this.keys.length);
        this.configChanged(uiProperties.activeConfig);
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        for (int i = 0; i < this.data.length; ++i) {
            final JTextField field = this.data[i];
            final String prop = this.keys[i];
            final JLabel label = this.dataLabels[i];
            field.getDocument().addDocumentListener(new DocumentListener(){
                Font basefont;
                Font boldfont;
                {
                    this.basefont = label.getFont();
                    this.boldfont = this.basefont.deriveFont(1);
                    this.updateFont();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                void changed() {
                    String v;
                    String config = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (config.length() == 0) {
                        config = null;
                    }
                    if ((v = field.getText()) != null && config != null && v.equals(((Map)CustomizerRun.this.configs.get(null)).get(prop))) {
                        v = null;
                    }
                    ((Map)CustomizerRun.this.configs.get(config)).put(prop, v);
                    this.updateFont();
                }

                void updateFont() {
                    String v = field.getText();
                    String config = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (config.length() == 0) {
                        config = null;
                    }
                    String def = (String)((Map)CustomizerRun.this.configs.get(null)).get(prop);
                    label.setFont(config != null && !Utilities.compareObjects((Object)(v != null ? v : ""), (Object)(def != null ? def : "")) ? this.boldfont : this.basefont);
                }
            });
        }
        this.jButtonMainClass.addActionListener(new MainClassListener(this.project.getSourceRoots(), this.jTextFieldMainClass));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.mainPanel = new JPanel();
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.jLabelVMOptions = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptionsExample = new JLabel();
        this.customizeOptionsButton = new JButton();
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configSep, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.configPanel.add((Component)this.configLabel, gridBagConstraints);
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_Cfg"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_NewCfg"));
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configDelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        this.configDel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_DeleteCfg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configPanel, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextFieldMainClass, gridBagConstraints);
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldMainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonMainClass, gridBagConstraints);
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.mainPanel.add((Component)this.jLabelArgs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jTextFieldArgs, gridBagConstraints);
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        this.jLabelWorkingDirectory.setLabelFor(this.jTextWorkingDirectory);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextWorkingDirectory, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle");
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory "));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonWorkingDirectoryBrowse, gridBagConstraints);
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelVMOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.mainPanel.add((Component)this.jTextVMOptions, gridBagConstraints);
        this.jTextVMOptions.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_VM_Options"));
        this.jLabelVMOptionsExample.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jLabelVMOptionsExample, gridBagConstraints);
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_CustomizeRun_Run_VM_Options_Example"));
        Mnemonics.setLocalizedText((AbstractButton)this.customizeOptionsButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_JButton"));
        this.customizeOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.customizeVMOptionsByDialog(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.mainPanel.add((Component)this.customizeOptionsButton, gridBagConstraints);
        this.customizeOptionsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"AN_CustomizeRun_Run_VM_Options_JButton"));
        this.customizeOptionsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizeRun_Run_VM_Options_Customize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    @Deprecated
    private void initExtPanel(Project p) {
        J2SERunConfigProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (this.compProviderDeprecated != null && (comp = this.compProviderDeprecated.createComponent(p, ccl = new J2SERunConfigProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> updates) {
                Map m = (Map)CustomizerRun.this.configs.get(CustomizerRun.this.uiProperties.activeConfig);
                m.putAll(updates);
            }
        })) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = this.nextExtensionYPos++;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
        }
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        J2SECategoryExtensionProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, ccl = new J2SECategoryExtensionProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> updates) {
                Map m = (Map)CustomizerRun.this.configs.get(CustomizerRun.this.uiProperties.activeConfig);
                m.putAll(updates);
            }
        })) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void configNewActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.prompt"), NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.empty", (Object)config), 2));
            return;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.duplicate", (Object)config), 2));
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.jTextWorkingDirectory.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void customizeVMOptionsByDialog(ActionEvent evt) {
        String origin = this.jTextVMOptions.getText();
        try {
            String result = OptionsDialog.showCustomizer(SwingUtilities.getWindowAncestor(this), origin);
            this.jTextVMOptions.setText(result);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot parse vm options.", e);
        }
    }

    private void configChanged(String activeConfig) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)CustomizerRun.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            model.addElement(c);
        }
        this.configCombo.setModel(model);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        Map<String, String> def = this.configs.get(null);
        if (m != null) {
            if (this.compProviderDeprecated != null) {
                this.compProviderDeprecated.configUpdated(m);
            }
            for (J2SECategoryExtensionProvider compProvider : this.compProviders) {
                compProvider.configUpdated(m);
            }
            for (int i = 0; i < this.data.length; ++i) {
                String v = m.get(this.keys[i]);
                if (v == null) {
                    v = def.get(this.keys[i]);
                }
                this.data[i].setText(v);
            }
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)CustomizerRun.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private SourceRoots sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField mainClassTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = mainClassTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final MainClassChooser panel = new MainClassChooser(this.sourceRoots.getRoots(), null, this.mainClassTextField.getText());
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.mainClassTextField.setText(panel.getSelectedMainClass());
            }
            dlg.dispose();
        }
    }
}

