/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.infrastructure.JsErrorRule;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OldLanguageRule
extends JsErrorRule {
    private static final String NEW_LANGUAGE_DESC = "1.7";
    private static final int NEW_LANGUAGE_VERSION = 170;

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("msg.no.semi.stmt");
    }

    @Override
    public void run(RuleContext ruleContext, Error error, List<Hint> list) {
        int n = error.getStartPosition();
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)ruleContext.parserResult);
        int n2 = LexUtilities.getLexerOffset((JsParseResult)jsParseResult, (int)n);
        if (n2 == -1) {
            return;
        }
        BaseDocument baseDocument = ruleContext.doc;
        if (n2 <= baseDocument.getLength()) {
            try {
                int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
                int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
                String string = baseDocument.getText(n3, n4 - n3);
                boolean bl = string.matches(".*\\byield\\s\\b.*");
                boolean bl2 = string.matches(".*\\blet\\s\\b.*");
                if (bl || bl2) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets((JsParseResult)jsParseResult, (OffsetRange)new OffsetRange(error.getStartPosition(), error.getEndPosition()));
                    if (offsetRange == OffsetRange.NONE) {
                        offsetRange = new OffsetRange(n3, n4);
                    }
                    Hint hint = new Hint((Rule)this, error.getDisplayName(), jsParseResult.getSnapshot().getSource().getFileObject(), offsetRange, Collections.emptyList(), 500);
                    list.add(hint);
                    OffsetRange offsetRange2 = new OffsetRange(n3, n4);
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(new ChangeLanguageFix(ruleContext));
                    arrayList.add(new ChangeTargetFix());
                    String string2 = bl ? "yield" : "let";
                    String string3 = NbBundle.getMessage(OldLanguageRule.class, (String)"OldLanguageRuleMsg", (Object)NEW_LANGUAGE_DESC, (Object)string2);
                    hint = new Hint((Rule)this, string3, jsParseResult.getSnapshot().getSource().getFileObject(), offsetRange2, arrayList, 500);
                    list.add(hint);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return SupportedBrowsers.getInstance().getLanguageVersion() < 170;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(OldLanguageRule.class, (String)"OldLanguageRule");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    public String getId() {
        return "OldLanguageRule";
    }

    public String getDescription() {
        return NbBundle.getMessage(OldLanguageRule.class, (String)"OldLanguageRuleDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class ChangeTargetFix
    implements HintFix {
        ChangeTargetFix() {
        }

        public String getDescription() {
            return NbBundle.getMessage(OldLanguageRule.class, (String)"ChangeJsLanguages");
        }

        public void implement() throws Exception {
            OptionsDisplayer.getDefault().open("Advanced/JsOptions");
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }

    private static class ChangeLanguageFix
    implements HintFix {
        private RuleContext context;

        public ChangeLanguageFix(RuleContext ruleContext) {
            this.context = ruleContext;
        }

        public String getDescription() {
            return NbBundle.getMessage(OldLanguageRule.class, (String)"OldLanguageRuleFix", (Object)OldLanguageRule.NEW_LANGUAGE_DESC);
        }

        public void implement() throws Exception {
            SupportedBrowsers.getInstance().setLanguageVersion(170);
            EditList editList = new EditList(this.context.doc);
            editList.replace(0, 0, " ", false, 0);
            editList.replace(0, 1, null, false, 1);
            editList.apply();
            MutableTextInput mutableTextInput = (MutableTextInput)this.context.doc.getProperty(MutableTextInput.class);
            if (mutableTextInput != null) {
                mutableTextInput.tokenHierarchyControl().rebuild();
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

