/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javafx2.project.JFXProjectGenerator;
import org.netbeans.modules.javafx2.project.PanelConfigureProject;
import org.netbeans.modules.javafx2.project.PanelIncludesExcludes;
import org.netbeans.modules.javafx2.project.PanelSourceFolders;
import org.netbeans.modules.javafx2.project.WizardSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaFXProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    static final String PROP_PRELOADER_NAME = "preloader.name";
    static final String MANIFEST_FILE = "manifest.mf";
    static final String GENERATED_FXML_CLASS_NAME = "Sample";
    private static final long serialVersionUID = 1L;
    private WizardType type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public JavaFXProjectWizardIterator() {
        this(WizardType.APPLICATION);
    }

    public static JavaFXProjectWizardIterator fxml() {
        return new JavaFXProjectWizardIterator(WizardType.FXML);
    }

    public static JavaFXProjectWizardIterator preloader() {
        return new JavaFXProjectWizardIterator(WizardType.PRELOADER);
    }

    public static JavaFXProjectWizardIterator library() {
        return new JavaFXProjectWizardIterator(WizardType.LIBRARY);
    }

    public static JavaFXProjectWizardIterator existing() {
        return new JavaFXProjectWizardIterator(WizardType.EXTISTING);
    }

    private JavaFXProjectWizardIterator(WizardType type) {
        this.type = type;
    }

    private WizardDescriptor.Panel[] createPanels() {
        switch (this.type) {
            case EXTISTING: {
                return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new PanelSourceFolders.Panel(), new PanelIncludesExcludes()};
            }
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        switch (this.type) {
            case EXTISTING: {
                return new String[]{NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LAB_ConfigureProject"), NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots"), NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LAB_PanelIncludesExcludes")};
            }
        }
        return new String[]{NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    public Set<?> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        AntProjectHelper projectHelper;
        handle.start(4);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        FileObject mainClassFo = null;
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF == null) {
            throw new NullPointerException("projdir == null, props:" + this.wiz.getProperties());
        }
        dirF = FileUtil.normalizeFile((File)dirF);
        String name = (String)this.wiz.getProperty("name");
        String mainClass = (String)this.wiz.getProperty("mainClass");
        String librariesDefinition = (String)this.wiz.getProperty("sharedLibraries");
        if (librariesDefinition != null) {
            if (!librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + "nblibraries.properties";
        }
        String platformName = (String)this.wiz.getProperty("java.platform.name");
        String preloader = (String)this.wiz.getProperty(PROP_PRELOADER_NAME);
        handle.progress(NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        switch (this.type) {
            case EXTISTING: {
                File[] sourceFolders = (File[])this.wiz.getProperty("sourceRoot");
                File[] testFolders = (File[])this.wiz.getProperty("testRoot");
                String buildScriptName = (String)this.wiz.getProperty("buildScriptName");
                projectHelper = JFXProjectGenerator.createProject(dirF, name, sourceFolders, testFolders, MANIFEST_FILE, librariesDefinition, buildScriptName, platformName, preloader, WizardType.EXTISTING);
                EditableProperties ep = projectHelper.getProperties("nbproject/project.properties");
                String includes = (String)this.wiz.getProperty("includes");
                if (includes == null) {
                    includes = "**";
                }
                ep.setProperty("includes", includes);
                String excludes = (String)this.wiz.getProperty("excludes");
                if (excludes == null) {
                    excludes = "";
                }
                ep.setProperty("excludes", excludes);
                projectHelper.putProperties("nbproject/project.properties", ep);
                handle.progress(2);
                for (File f : sourceFolders) {
                    FileObject srcFo = FileUtil.toFileObject((File)f);
                    if (srcFo == null) continue;
                    resultSet.add(srcFo);
                }
                break;
            }
            default: {
                FileObject fxml;
                FileObject controller;
                int lastDotIdx;
                String manifest = null;
                if (this.type == WizardType.APPLICATION || this.type == WizardType.FXML) {
                    manifest = MANIFEST_FILE;
                }
                projectHelper = this.type == WizardType.PRELOADER ? JFXProjectGenerator.createPreloaderProject(dirF, name, librariesDefinition, platformName, mainClass) : JFXProjectGenerator.createProject(dirF, name, mainClass, manifest, librariesDefinition, platformName, preloader, this.type);
                handle.progress(2);
                FileObject sourcesRoot = projectHelper.getProjectDirectory().getFileObject("src");
                if (mainClass != null && mainClass.length() > 0) {
                    try {
                        mainClassFo = JavaFXProjectWizardIterator.getClassFO(sourcesRoot, mainClass);
                        assert (mainClassFo != null) : "sourcesRoot: " + sourcesRoot + ", mainClass: " + mainClass;
                    }
                    catch (Exception x) {
                        ErrorManager.getDefault().notify((Throwable)x);
                    }
                }
                if (this.type != WizardType.FXML) break;
                String pName = "";
                if (mainClass != null && mainClass.length() > 0 && (lastDotIdx = mainClass.lastIndexOf(46)) != -1) {
                    pName = mainClass.substring(0, lastDotIdx).trim();
                    pName = pName.replace('.', '/');
                    pName = pName + '/';
                }
                if ((controller = sourcesRoot.getFileObject(pName + GENERATED_FXML_CLASS_NAME + ".java")) != null) {
                    resultSet.add(controller);
                }
                if ((fxml = sourcesRoot.getFileObject(pName + GENERATED_FXML_CLASS_NAME + ".fxml")) == null) break;
                resultSet.add(fxml);
            }
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        switch (this.type) {
            case APPLICATION: 
            case FXML: {
                JavaFXProjectWizardIterator.createManifest(dir, false);
                break;
            }
            case EXTISTING: {
                JavaFXProjectWizardIterator.createManifest(dir, true);
            }
        }
        handle.progress(3);
        resultSet.add(dir);
        handle.progress(NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_Preloader"), 4);
        if (preloader != null && preloader.length() > 0) {
            preloader = preloader.trim();
            File preloaderDir = new File(dirF.getParentFile().getAbsolutePath() + File.separatorChar + preloader);
            FileUtil.normalizeFile((File)preloaderDir);
            String preloaderClassName = JavaFXProjectWizardIterator.generatePreloaderClassName(preloader);
            AntProjectHelper preloaderProjectHelper = JFXProjectGenerator.createPreloaderProject(preloaderDir, preloader, librariesDefinition, platformName, preloaderClassName);
            FileObject sourcesRoot = preloaderProjectHelper.getProjectDirectory().getFileObject("src");
            FileObject preloaderClassFo = JavaFXProjectWizardIterator.getClassFO(sourcesRoot, JavaFXProjectWizardIterator.generatePreloaderClassName(preloader));
            resultSet.add(preloaderClassFo);
            FileObject preloaderDirFO = FileUtil.toFileObject((File)preloaderDir);
            resultSet.add(preloaderDirFO);
            Project[] p = new Project[]{ProjectManager.getDefault().findProject(preloaderDirFO)};
            FileObject ownerSourcesRoot = projectHelper.getProjectDirectory().getFileObject("src");
            ProjectClassPathModifier.addProjects((Project[])p, (FileObject)ownerSourcesRoot, (String)"classpath/compile");
        }
        int ind = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case APPLICATION: 
            case FXML: 
            case PRELOADER: {
                WizardSettings.setNewApplicationCount(ind);
                break;
            }
            case LIBRARY: {
                WizardSettings.setNewLibraryCount(ind);
                break;
            }
            case EXTISTING: {
                WizardSettings.setNewProjectCount(ind);
            }
        }
        handle.progress(NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_PreparingToOpen"), 5);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        SharableLibrariesUtils.setLastProjectSharable((librariesDefinition != null ? 1 : 0) != 0);
        if (mainClassFo != null) {
            resultSet.add(mainClassFo);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            switch (this.type) {
                case EXTISTING: {
                    this.wiz.putProperty("sourceRoot", null);
                    this.wiz.putProperty("testRoot", null);
                }
            }
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"LAB_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static FileObject getClassFO(FileObject sourcesRoot, String className) {
        className = className.replace('.', '/');
        return sourcesRoot.getFileObject(className + ".java");
    }

    static String getPackageName(String displayName) {
        StringBuilder builder = new StringBuilder();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(JavaFXProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createManifest(FileObject dir, boolean skeepIfExists) throws IOException {
        if (skeepIfExists && dir.getFileObject(MANIFEST_FILE) != null) {
            return;
        }
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static boolean isIllegalProjectName(String name) {
        return name.length() == 0 || name.indexOf(47) >= 0 || name.indexOf(92) >= 0 || name.indexOf(58) >= 0 || name.indexOf("\"") >= 0 || name.indexOf(60) >= 0 || name.indexOf(62) >= 0;
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    static String generatePreloaderClassName(String preloaderProjectName) {
        StringBuilder sb = new StringBuilder();
        sb.append(preloaderProjectName.toLowerCase().replace('-', '.'));
        sb.append('.');
        sb.append(preloaderProjectName.replace('-', '_').replace('.', '_'));
        return sb.toString();
    }

    static enum WizardType {
        APPLICATION,
        PRELOADER,
        FXML,
        LIBRARY,
        EXTISTING;

    }
}

