/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.ui.CustomizerJarComponent;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class JFXProjectProperties {
    public static final String JAVAFX_ENABLED = "javafx.enabled";
    public static final String JAVAFX_PRELOADER = "javafx.preloader";
    public static final String FXML_EXTENSION = "fxml";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAFX_BINARY_ENCODE_CSS = "javafx.binarycss";
    public static final String JAVAFX_DEPLOY_INCLUDEDT = "javafx.deploy.includeDT";
    public static final String JAVAFX_DEPLOY_EMBEDJNLP = "javafx.deploy.embedJNLP";
    public static final String MAIN_CLASS = "javafx.main.class";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String APP_PARAM_PREFIX = "javafx.param.";
    public static final String[] APP_PARAM_SUFFIXES = new String[]{"name", "value"};
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String FALLBACK_CLASS = "javafx.fallback.class";
    public static final String SIGNED_JAR = "dist.signed.jar";
    public static final String PRELOADER_ENABLED = "javafx.preloader.enabled";
    public static final String PRELOADER_TYPE = "javafx.preloader.type";
    public static final String PRELOADER_PROJECT = "javafx.preloader.project.path";
    public static final String PRELOADER_CLASS = "javafx.preloader.class";
    public static final String PRELOADER_JAR_FILENAME = "javafx.preloader.jar.filename";
    public static final String PRELOADER_JAR_PATH = "javafx.preloader.jar.path";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String RUN_APP_WIDTH = "javafx.run.width";
    public static final String RUN_APP_HEIGHT = "javafx.run.height";
    public static final String RUN_IN_HTMLTEMPLATE = "javafx.run.htmltemplate";
    public static final String RUN_IN_HTMLTEMPLATE_PROCESSED = "javafx.run.htmltemplate.processed";
    public static final String RUN_IN_BROWSER = "javafx.run.inbrowser";
    public static final String RUN_IN_BROWSER_PATH = "javafx.run.inbrowser.path";
    public static final String RUN_IN_BROWSER_ARGUMENTS = "javafx.run.inbrowser.arguments";
    public static final String RUN_AS = "javafx.run.as";
    public static final String DEFAULT_APP_WIDTH = "800";
    public static final String DEFAULT_APP_HEIGHT = "600";
    public static final String UPDATE_MODE_BACKGROUND = "javafx.deploy.backgroundupdate";
    public static final String ALLOW_OFFLINE = "javafx.deploy.allowoffline";
    public static final String INSTALL_PERMANENTLY = "javafx.deploy.installpermanently";
    public static final String ADD_DESKTOP_SHORTCUT = "javafx.deploy.adddesktopshortcut";
    public static final String ADD_STARTMENU_SHORTCUT = "javafx.deploy.addstartmenushortcut";
    public static final String ICON_FILE = "javafx.deploy.icon";
    public static final String PERMISSIONS_ELEVATED = "javafx.deploy.permissionselevated";
    public static final String JAVAFX_SIGNING_ENABLED = "javafx.signing.enabled";
    public static final String JAVAFX_SIGNING_TYPE = "javafx.signing.type";
    public static final String JAVAFX_SIGNING_KEYSTORE = "javafx.signing.keystore";
    public static final String JAVAFX_SIGNING_KEYSTORE_PASSWORD = "javafx.signing.keystore.password";
    public static final String JAVAFX_SIGNING_KEY = "javafx.signing.keyalias";
    public static final String JAVAFX_SIGNING_KEY_PASSWORD = "javafx.signing.keyalias.password";
    public static final String RUN_CP = "run.classpath";
    public static final String BUILD_CLASSES = "build.classes.dir";
    public static final String DOWNLOAD_MODE_LAZY_JARS = "download.mode.lazy.jars";
    private static final String DOWNLOAD_MODE_LAZY_JAR = "download.mode.lazy.jar.";
    private static final String DOWNLOAD_MODE_LAZY_FORMAT = "download.mode.lazy.jar.%s";
    public static final String JAVASCRIPT_CALLBACK_PREFIX = "javafx.jscallback.";
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private StoreGroup fxPropGroup = new StoreGroup();
    JToggleButton.ToggleButtonModel binaryEncodeCSS;
    private CustomizerJarComponent jarComponent = null;
    private Map<String, Map<String, String>> RUN_CONFIGS;
    private Map<String, List<Map<String, String>>> APP_PARAMS;
    private String activeConfig;
    private Map<String, String> browserPaths = null;
    PreloaderClassComboBoxModel preloaderClassModel;
    JToggleButton.ToggleButtonModel runStandalone;
    JToggleButton.ToggleButtonModel runAsWebStart;
    JToggleButton.ToggleButtonModel runInBrowser;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel backgroundUpdateCheck;
    JToggleButton.ToggleButtonModel installPermanently;
    JToggleButton.ToggleButtonModel addDesktopShortcut;
    JToggleButton.ToggleButtonModel addStartMenuShortcut;
    Document iconDocument;
    boolean signingEnabled;
    SigningType signingType;
    String signingKeyStore;
    String signingKeyAlias;
    boolean permissionsElevated;
    char[] signingKeyStorePassword;
    char[] signingKeyPassword;
    List<? extends File> runtimeCP;
    List<? extends File> lazyJars;
    boolean lazyJarsChanged;
    Map<String, String> jsCallbacks;
    boolean jsCallbacksChanged;
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    private static Map<String, JFXProjectProperties> propInstance = new TreeMap<String, JFXProjectProperties>();
    private static Map<String, Set<PreloaderArtifact>> prelArtifacts = new TreeMap<String, Set<PreloaderArtifact>>();

    public JToggleButton.ToggleButtonModel getBinaryEncodeCSSModel() {
        return this.binaryEncodeCSS;
    }

    public CustomizerJarComponent getCustomizerJarComponent() {
        if (this.jarComponent == null) {
            this.jarComponent = new CustomizerJarComponent(this);
        }
        return this.jarComponent;
    }

    public Map<String, Map<String, String>> getRunConfigs() {
        return this.RUN_CONFIGS;
    }

    public Map<String, List<Map<String, String>>> getAppParameters() {
        return this.APP_PARAMS;
    }

    public List<Map<String, String>> getActiveAppParameters(String config) {
        return this.APP_PARAMS.get(config);
    }

    public List<Map<String, String>> getActiveAppParameters() {
        return this.APP_PARAMS.get(this.activeConfig);
    }

    public void setActiveAppParameters(List<Map<String, String>> params) {
        this.APP_PARAMS.put(this.activeConfig, params);
    }

    public String getActiveConfig() {
        return this.activeConfig;
    }

    public void setActiveConfig(String config) {
        this.activeConfig = config;
    }

    public Map<String, String> getBrowserPaths() {
        return this.browserPaths;
    }

    public void resetBrowserPaths() {
        this.browserPaths = new HashMap<String, String>();
    }

    public void setBrowserPaths(Map<String, String> browserPaths) {
        this.browserPaths = browserPaths;
    }

    public PreloaderClassComboBoxModel getPreloaderClassModel() {
        return this.preloaderClassModel;
    }

    public RunAsType getActiveRunAs() {
        String runAs = this.RUN_CONFIGS.get(this.activeConfig).get(RUN_AS);
        if (JFXProjectProperties.isEqualIgnoreCase(runAs, RunAsType.ASWEBSTART.getString())) {
            return RunAsType.ASWEBSTART;
        }
        if (JFXProjectProperties.isEqualIgnoreCase(runAs, RunAsType.INBROWSER.getString())) {
            return RunAsType.INBROWSER;
        }
        return RunAsType.STANDALONE;
    }

    public JToggleButton.ToggleButtonModel getAllowOfflineModel() {
        return this.allowOfflineModel;
    }

    public JToggleButton.ToggleButtonModel getBackgroundUpdateCheckModel() {
        return this.backgroundUpdateCheck;
    }

    public JToggleButton.ToggleButtonModel getInstallPermanentlyModel() {
        return this.installPermanently;
    }

    public JToggleButton.ToggleButtonModel getAddDesktopShortcutModel() {
        return this.addDesktopShortcut;
    }

    public JToggleButton.ToggleButtonModel getAddStartMenuShortcutModel() {
        return this.addStartMenuShortcut;
    }

    public Document getIconDocumentModel() {
        return this.iconDocument;
    }

    public boolean getSigningEnabled() {
        return this.signingEnabled;
    }

    public void setSigningEnabled(boolean enabled) {
        this.signingEnabled = enabled;
    }

    public boolean getPermissionsElevated() {
        return this.permissionsElevated;
    }

    public void setPermissionsElevated(boolean enabled) {
        this.permissionsElevated = enabled;
    }

    public SigningType getSigningType() {
        return this.signingType;
    }

    public void setSigningType(SigningType type) {
        this.signingType = type;
    }

    public String getSigningKeyStore() {
        return this.signingKeyStore;
    }

    public String getSigningKeyAlias() {
        return this.signingKeyAlias;
    }

    public char[] getSigningKeyStorePassword() {
        return this.signingKeyStorePassword;
    }

    public char[] getSigningKeyPassword() {
        return this.signingKeyPassword;
    }

    public void setSigningKeyAlias(String signingKeyAlias) {
        this.signingKeyAlias = signingKeyAlias;
    }

    public void setSigningKeyPassword(char[] signingKeyPassword) {
        this.signingKeyPassword = signingKeyPassword;
    }

    public void setSigningKeyStore(String signingKeyStore) {
        this.signingKeyStore = signingKeyStore;
    }

    public void setSigningKeyStorePassword(char[] signingKeyStorePassword) {
        this.signingKeyStorePassword = signingKeyStorePassword;
    }

    public List<? extends File> getRuntimeCP() {
        return this.runtimeCP;
    }

    public List<? extends File> getLazyJars() {
        return this.lazyJars;
    }

    public void setLazyJars(List<? extends File> newLazyJars) {
        this.lazyJars = newLazyJars;
    }

    public boolean getLazyJarsChanged() {
        return this.lazyJarsChanged;
    }

    public void setLazyJarsChanged(boolean changed) {
        this.lazyJarsChanged = changed;
    }

    public Map<String, String> getJSCallbacks() {
        return this.jsCallbacks;
    }

    public void setJSCallbacks(Map<String, String> newCallbacks) {
        this.jsCallbacks = newCallbacks;
    }

    public boolean getJSCallbacksChanged() {
        return this.jsCallbacksChanged;
    }

    public void setJSCallbacksChanged(boolean changed) {
        this.jsCallbacksChanged = changed;
    }

    public Project getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public static JFXProjectProperties getInstance(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
        }
        return prop;
    }

    public static JFXProjectProperties getInstanceIfExists(Project proj) {
        assert (proj != null);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            return prop;
        }
        return null;
    }

    public static JFXProjectProperties getInstanceIfExists(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        return JFXProjectProperties.getInstanceIfExists(proj);
    }

    public static void cleanup(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        propInstance.remove(projDir);
    }

    private static Set<PreloaderArtifact> getPreloaderArtifacts(@NonNull Project proj) {
        String projDir = proj.getProjectDirectory().getPath();
        Set<PreloaderArtifact> prels = prelArtifacts.get(projDir);
        if (prels == null) {
            prels = new HashSet<PreloaderArtifact>();
            prelArtifacts.put(projDir, prels);
        }
        return prels;
    }

    private JFXProjectProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.binaryEncodeCSS = this.fxPropGroup.createToggleButtonModel(this.evaluator, JAVAFX_BINARY_ENCODE_CSS);
            this.allowOfflineModel = this.fxPropGroup.createToggleButtonModel(this.evaluator, ALLOW_OFFLINE);
            this.backgroundUpdateCheck = this.fxPropGroup.createToggleButtonModel(this.evaluator, UPDATE_MODE_BACKGROUND);
            this.installPermanently = this.fxPropGroup.createToggleButtonModel(this.evaluator, INSTALL_PERMANENTLY);
            this.addDesktopShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_DESKTOP_SHORTCUT);
            this.addStartMenuShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_STARTMENU_SHORTCUT);
            this.iconDocument = this.fxPropGroup.createStringDocument(this.evaluator, ICON_FILE);
            this.RUN_CONFIGS = this.readRunConfigs();
            this.APP_PARAMS = this.readAppParams();
            this.activeConfig = this.evaluator.getProperty("config");
            this.preloaderClassModel = new PreloaderClassComboBoxModel();
            this.initSigning(this.evaluator);
            this.initResources(this.evaluator, this.project, Collections.unmodifiableMap(this.RUN_CONFIGS));
            this.initJSCallbacks(this.evaluator);
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> m = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        TreeMap<String, String> def = new TreeMap<String, String>();
        EditableProperties ep = null;
        try {
            ep = this.readFromFile("nbproject/private/private.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        EditableProperties pep = null;
        try {
            pep = this.readFromFile("nbproject/project.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (String prop : new String[]{MAIN_CLASS, RUN_JVM_ARGS, PRELOADER_ENABLED, PRELOADER_TYPE, PRELOADER_PROJECT, PRELOADER_JAR_PATH, PRELOADER_JAR_FILENAME, PRELOADER_CLASS, RUN_WORK_DIR, RUN_APP_WIDTH, RUN_APP_HEIGHT, RUN_IN_HTMLTEMPLATE, RUN_IN_BROWSER, RUN_AS}) {
            String v = ep.getProperty(prop);
            if (v == null) {
                v = pep.getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        if (def.get(RUN_APP_WIDTH) == null) {
            def.put(RUN_APP_WIDTH, DEFAULT_APP_WIDTH);
        }
        if (def.get(RUN_APP_HEIGHT) == null) {
            def.put(RUN_APP_HEIGHT, DEFAULT_APP_HEIGHT);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                EditableProperties cep = null;
                try {
                    cep = this.readFromFile(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                m.put(kid.getName(), new TreeMap(cep));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                Map c;
                if (!kid.hasExt("properties") || (c = (Map)m.get(kid.getName())) == null) continue;
                EditableProperties cep = null;
                try {
                    cep = this.readFromFile(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                c.putAll(new HashMap(cep));
            }
        }
        Set<PreloaderArtifact> prels = JFXProjectProperties.getPreloaderArtifacts(this.project);
        prels.clear();
        try {
            prels.addAll(this.getPreloaderArtifactsFromConfigs(m));
        }
        catch (IOException ex) {
            // empty catch block
        }
        return m;
    }

    Map<String, List<Map<String, String>>> readAppParams() {
        String propValue;
        int numProps;
        HashMap<String, String> map;
        TreeMap<String, List<Map<String, String>>> p = new TreeMap<String, List<Map<String, String>>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        ArrayList def = new ArrayList();
        EditableProperties ep = null;
        try {
            ep = this.readFromFile("nbproject/private/private.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        EditableProperties pep = null;
        try {
            pep = this.readFromFile("nbproject/project.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        int index = 0;
        while (true) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            int numProps2 = 0;
            for (String propSuffix : APP_PARAM_SUFFIXES) {
                String propValue2 = ep.getProperty(APP_PARAM_PREFIX + index + "." + propSuffix);
                if (propValue2 == null) {
                    propValue2 = pep.getProperty(APP_PARAM_PREFIX + index + "." + propSuffix);
                }
                if (propValue2 == null) continue;
                map2.put(propSuffix, propValue2);
                ++numProps2;
            }
            if (numProps2 == 0) break;
            def.add(map2);
            ++index;
        }
        p.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            FileObject[] arr$ = configs.getChildren();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                FileObject kid = arr$[i$];
                if (!kid.hasExt("properties")) continue;
                EditableProperties cep = null;
                try {
                    cep = this.readFromFile(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                ArrayList params = new ArrayList();
                if (cep != null) {
                    index = 0;
                    while (true) {
                        map = new HashMap<String, String>();
                        numProps = 0;
                        for (String propSuffix : APP_PARAM_SUFFIXES) {
                            propValue = cep.getProperty(APP_PARAM_PREFIX + index + "." + propSuffix);
                            if (propValue == null) continue;
                            map.put(propSuffix, propValue);
                            ++numProps;
                        }
                        if (numProps == 0) break;
                        params.add(map);
                        ++index;
                    }
                }
                p.put(kid.getName(), params);
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            block13: for (FileObject kid : configs.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                ArrayList<HashMap<String, String>> params = (ArrayList<HashMap<String, String>>)p.get(kid.getName());
                if (params == null) {
                    params = new ArrayList<HashMap<String, String>>();
                    p.put(kid.getName(), params);
                }
                EditableProperties cep = null;
                try {
                    cep = this.readFromFile(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (cep == null) continue;
                index = 0;
                while (true) {
                    map = new HashMap();
                    numProps = 0;
                    for (String propSuffix : APP_PARAM_SUFFIXES) {
                        propValue = cep.getProperty(APP_PARAM_PREFIX + index + "." + propSuffix);
                        if (propValue == null) continue;
                        map.put(propSuffix, propValue);
                        ++numProps;
                    }
                    if (numProps == 0) continue block13;
                    params.add(map);
                    ++index;
                }
            }
        }
        return p;
    }

    void storeSingleParamsProperty(List<Map<String, String>> params, EditableProperties projectProperties) {
        String sbs;
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            int index = 0;
            for (Map<String, String> m : params) {
                String name = null;
                String value = null;
                for (Map.Entry<String, String> propSuffix : m.entrySet()) {
                    if (propSuffix.getKey().equalsIgnoreCase(APP_PARAM_SUFFIXES[0])) {
                        name = propSuffix.getValue();
                    }
                    if (!propSuffix.getKey().equalsIgnoreCase(APP_PARAM_SUFFIXES[1])) continue;
                    value = propSuffix.getValue();
                }
                if (name != null && name.length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    if (value != null && value.length() > 0) {
                        sb.append("--");
                        sb.append(name);
                        sb.append("=");
                        sb.append(value);
                    } else {
                        sb.append(name);
                    }
                }
                ++index;
            }
        }
        if (!Utilities.compareObjects((Object)(sbs = sb.toString()), (Object)projectProperties.getProperty(APPLICATION_ARGS))) {
            if (sbs != null && sbs.length() > 0) {
                projectProperties.setProperty(APPLICATION_ARGS, sbs);
                projectProperties.setComment(APPLICATION_ARGS, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_app_args")}, false);
            } else {
                projectProperties.remove((Object)APPLICATION_ARGS);
            }
        }
    }

    void storeRunConfigs(Map<String, Map<String, String>> configs, Map<String, List<Map<String, String>>> params, EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        Map<String, String> def = configs.get(null);
        for (String prop : new String[]{MAIN_CLASS, RUN_JVM_ARGS, PRELOADER_ENABLED, PRELOADER_TYPE, PRELOADER_PROJECT, PRELOADER_JAR_PATH, PRELOADER_JAR_FILENAME, PRELOADER_CLASS, RUN_WORK_DIR, RUN_APP_WIDTH, RUN_APP_HEIGHT, RUN_IN_HTMLTEMPLATE, RUN_IN_BROWSER, RUN_AS}) {
            EditableProperties ep;
            String v = def.get(prop);
            EditableProperties editableProperties = ep = prop.equals(RUN_WORK_DIR) || prop.equals(RUN_IN_HTMLTEMPLATE) || prop.equals(RUN_IN_BROWSER) || prop.equals(RUN_AS) || privateProperties.containsKey((Object)prop) ? privateProperties : projectProperties;
            if (Utilities.compareObjects((Object)v, (Object)ep.getProperty(prop))) continue;
            if (v != null && v.length() > 0) {
                ep.setProperty(prop, v);
                continue;
            }
            ep.remove((Object)prop);
        }
        int index = 0;
        List<Map<String, String>> paramsDefault = params.get(null);
        if (paramsDefault != null) {
            for (Map<String, String> m : paramsDefault) {
                for (Map.Entry<String, String> propSuffix : m.entrySet()) {
                    String prop = APP_PARAM_PREFIX + index + "." + propSuffix.getKey();
                    String v = propSuffix.getValue();
                    if (Utilities.compareObjects((Object)v, (Object)projectProperties.getProperty(prop))) continue;
                    if (v != null && v.length() > 0) {
                        projectProperties.setProperty(prop, v);
                        continue;
                    }
                    projectProperties.remove((Object)prop);
                }
                ++index;
            }
        }
        this.storeSingleParamsProperty(paramsDefault, privateProperties);
        for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
            String config = entry.getKey();
            if (config == null) continue;
            String sharedPath = "nbproject/configs/" + config + ".properties";
            String privatePath = "nbproject/private/configs/" + config + ".properties";
            Map<String, String> c = entry.getValue();
            if (c == null) {
                try {
                    this.deleteFile(sharedPath);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    this.deleteFile(privatePath);
                }
                catch (IOException ex) {}
                continue;
            }
            EditableProperties sharedCfgProps = this.readFromFile(sharedPath);
            EditableProperties privateCfgProps = this.readFromFile(privatePath);
            boolean privatePropsChanged = false;
            for (Map.Entry<String, String> entry2 : c.entrySet()) {
                EditableProperties ep;
                String prop = entry2.getKey();
                String v = entry2.getValue();
                if (Utilities.compareObjects((Object)v, (Object)(ep = prop.equals(RUN_WORK_DIR) || prop.equals(RUN_IN_HTMLTEMPLATE) || prop.equals(RUN_IN_BROWSER) || prop.equals(RUN_AS) || privateCfgProps.containsKey((Object)prop) ? privateCfgProps : sharedCfgProps).getProperty(prop))) continue;
                if (v != null && (v.length() > 0 || def.get(prop) != null && def.get(prop).length() > 0)) {
                    ep.setProperty(prop, v);
                } else {
                    ep.remove((Object)prop);
                }
                privatePropsChanged |= ep == privateCfgProps;
            }
            index = 0;
            List<Map<String, String>> paramsConfig = params.get(config);
            if (paramsConfig != null) {
                for (Map<String, String> m : params.get(config)) {
                    for (Map.Entry<String, String> propSuffix : m.entrySet()) {
                        String prop = APP_PARAM_PREFIX + index + "." + propSuffix.getKey();
                        String v = propSuffix.getValue();
                        if (Utilities.compareObjects((Object)v, (Object)sharedCfgProps.getProperty(prop))) continue;
                        if (v != null && v.length() > 0) {
                            sharedCfgProps.setProperty(prop, v);
                            continue;
                        }
                        sharedCfgProps.remove((Object)prop);
                    }
                    ++index;
                }
            }
            this.storeSingleParamsProperty(paramsConfig, privateCfgProps);
            this.saveToFile(sharedPath, sharedCfgProps);
            if (!privatePropsChanged) continue;
            this.saveToFile(privatePath, privateCfgProps);
        }
    }

    private FileObject getSrcRoot(Project project) {
        FileObject srcRoot = null;
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (JFXProjectProperties.isTest(sg.getRootFolder(), project)) continue;
            srcRoot = sg.getRootFolder();
            break;
        }
        return srcRoot;
    }

    private Set<PreloaderArtifact> getPreloaderArtifactsFromConfigs(Map<String, Map<String, String>> configs) throws IOException {
        HashSet<PreloaderArtifact> preloaderArtifacts = new HashSet<PreloaderArtifact>();
        Map<String, Map<String, String>> configsCopy = Collections.unmodifiableMap(configs);
        for (Map.Entry<String, Map<String, String>> config : configsCopy.entrySet()) {
            String prelJar;
            PreloaderArtifact preloader = null;
            Map<String, String> configCopy = Collections.unmodifiableMap(config.getValue());
            if (!JFXProjectProperties.isTrue(configCopy.get(PRELOADER_ENABLED))) continue;
            String prelTypeString = configCopy.get(PRELOADER_TYPE);
            String prelProjDir = configCopy.get(PRELOADER_PROJECT);
            if (prelProjDir != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.PROJECT.getString())) {
                FileObject srcRoot;
                File prelProjDirF;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelProjDir);
                File file = prelProjDirF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (JFXProjectProperties.isTrue(configCopy.get(PRELOADER_ENABLED)) && prelProjDirF != null && prelProjDirF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    prelProjDirF = FileUtil.normalizeFile((File)prelProjDirF);
                    FileObject prelProjFO = FileUtil.toFileObject((File)prelProjDirF);
                    Project proj = ProjectManager.getDefault().findProject(prelProjFO);
                    AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)proj, (String)"jar");
                    ArrayList<URI> allURI = new ArrayList<URI>();
                    for (AntArtifact artifact : artifacts) {
                        allURI.addAll(Arrays.asList(artifact.getArtifactLocations()));
                    }
                    if (!allURI.isEmpty()) {
                        URI[] arrayURI = allURI.toArray(new URI[0]);
                        preloader = new PreloaderProjectArtifact(artifacts, arrayURI, srcRoot, "classpath/compile", prelProjDirF.getAbsolutePath());
                    }
                }
            }
            if (preloader == null && (prelJar = configCopy.get(PRELOADER_JAR_PATH)) != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.JAR.getString())) {
                FileObject srcRoot;
                File prelJarF;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelJar);
                File file = prelJarF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (prelJarF != null && prelJarF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    URL[] urls = new URL[]{FileUtil.urlForArchiveOrDir((File)prelJarF)};
                    FileObject[] fos = new FileObject[]{FileUtil.toFileObject((File)prelJarF)};
                    preloader = new PreloaderJarArtifact(urls, fos, srcRoot, "classpath/compile", urls[0].toString());
                }
            }
            if (preloader == null) continue;
            preloaderArtifacts.add(preloader);
        }
        return preloaderArtifacts;
    }

    private void updatePreloaderDependencies(Map<String, Map<String, String>> configs) throws IOException {
        Set<PreloaderArtifact> preloaderArtifacts = JFXProjectProperties.getPreloaderArtifacts(this.getProject());
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            artifact.setValid(false);
        }
        Set<PreloaderArtifact> currentArtifacts = this.getPreloaderArtifactsFromConfigs(configs);
        for (PreloaderArtifact preloader : currentArtifacts) {
            if (preloader == null) continue;
            preloader.addDependency();
            boolean updated = false;
            for (PreloaderArtifact a : preloaderArtifacts) {
                if (!a.equals(preloader)) continue;
                a.setValid(true);
                updated = true;
            }
            if (updated) continue;
            preloader.setValid(true);
            preloaderArtifacts.add(preloader);
        }
        HashSet<PreloaderArtifact> toRemove = new HashSet<PreloaderArtifact>();
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            if (artifact.isValid()) continue;
            artifact.removeDependency();
            toRemove.add(artifact);
        }
        for (PreloaderArtifact artifact : toRemove) {
            preloaderArtifacts.remove(artifact);
        }
    }

    private static boolean isTest(FileObject root, Project project) {
        assert (root != null);
        assert (project != null);
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] srcRoots;
            for (FileObject srcRoot : srcRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                if (!project.equals(FileOwnerQuery.getOwner((FileObject)srcRoot))) continue;
                return true;
            }
        }
        return false;
    }

    private void storeActiveConfig() throws IOException {
        String configPath = "nbproject/private/config.properties";
        if (this.activeConfig == null) {
            try {
                this.deleteFile(configPath);
            }
            catch (IOException ex) {}
        } else {
            EditableProperties configProps = this.readFromFile(configPath);
            configProps.setProperty("config", this.activeConfig);
            this.saveToFile(configPath, configProps);
        }
    }

    private void storeRest(EditableProperties editableProps, EditableProperties privProps) {
        editableProps.setProperty(JAVAFX_SIGNING_ENABLED, this.signingEnabled ? "true" : "false");
        editableProps.setProperty(JAVAFX_SIGNING_TYPE, this.signingType.getString());
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEY, this.signingKeyAlias);
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEYSTORE, this.signingKeyStore);
        editableProps.setProperty(PERMISSIONS_ELEVATED, this.permissionsElevated ? "true" : "false");
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEYSTORE_PASSWORD, this.signingKeyStorePassword);
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEY_PASSWORD, this.signingKeyPassword);
        this.storeResources(editableProps);
        this.storeJSCallbacks(editableProps);
        this.storePlatform(editableProps);
    }

    private void setOrRemove(EditableProperties props, String name, char[] value) {
        this.setOrRemove(props, name, value != null ? new String(value) : null);
    }

    private void setOrRemove(EditableProperties props, String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public EditableProperties readFromFile(String relativePath) throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        FileObject propsFO = this.project.getProjectDirectory().getFileObject(relativePath);
        if (propsFO != null) {
            try {
                final InputStream is = propsFO.getInputStream();
                ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        try {
                            ep.load(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
        return ep;
    }

    public void deleteFile(String relativePath) throws IOException {
        final FileObject propsFO = this.project.getProjectDirectory().getFileObject(relativePath);
        if (propsFO != null) {
            try {
                Mutex.ExceptionAction<Void> action = new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        FileLock lock = null;
                        try {
                            lock = propsFO.lock();
                            propsFO.delete(lock);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                        return null;
                    }
                };
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>((Mutex.ExceptionAction)action){
                    final /* synthetic */ Mutex.ExceptionAction val$action;
                    {
                        this.val$action = exceptionAction;
                    }

                    public Void run() throws Exception {
                        ProjectManager.mutex().readAccess(this.val$action);
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
    }

    public void saveToFile(String relativePath, final EditableProperties ep) throws IOException {
        FileObject propsFO;
        FileObject f = this.project.getProjectDirectory().getFileObject(relativePath);
        if (f == null) {
            propsFO = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)relativePath);
            assert (propsFO != null) : "FU.cD must not return null; called on " + this.project.getProjectDirectory() + " + " + relativePath;
        } else {
            propsFO = f;
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = propsFO.lock();
                        os = propsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    public void store() throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final EditableProperties pep = new EditableProperties(true);
        final FileObject privPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final String selectedBrowserPath = this.getSelectedBrowserPath();
        try {
            final InputStream is = projPropsFO.getInputStream();
            final InputStream pis = privPropsFO.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        ep.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    try {
                        pep.load(pis);
                    }
                    finally {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    JFXProjectProperties.this.fxPropGroup.store(ep);
                    JFXProjectProperties.this.storeRest(ep, pep);
                    if (selectedBrowserPath != null) {
                        pep.setProperty(JFXProjectProperties.RUN_IN_BROWSER_PATH, selectedBrowserPath);
                    }
                    JFXProjectProperties.this.storeRunConfigs(JFXProjectProperties.this.RUN_CONFIGS, JFXProjectProperties.this.APP_PARAMS, ep, pep);
                    JFXProjectProperties.this.storeActiveConfig();
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    try {
                        lock = privPropsFO.lock();
                        os = privPropsFO.getOutputStream(lock);
                        pep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    JFXProjectProperties.this.updatePreloaderDependencies(Collections.unmodifiableMap(JFXProjectProperties.this.RUN_CONFIGS));
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private void initSigning(PropertyEvaluator eval) {
        String enabled = eval.getProperty(JAVAFX_SIGNING_ENABLED);
        String signedProp = eval.getProperty(JAVAFX_SIGNING_TYPE);
        this.signingEnabled = JFXProjectProperties.isTrue(enabled);
        this.signingType = signedProp == null ? SigningType.NOSIGN : (signedProp.equalsIgnoreCase(SigningType.SELF.getString()) ? SigningType.SELF : (signedProp.equalsIgnoreCase(SigningType.KEY.getString()) ? SigningType.KEY : SigningType.NOSIGN));
        this.signingKeyStore = eval.getProperty(JAVAFX_SIGNING_KEYSTORE);
        this.signingKeyAlias = eval.getProperty(JAVAFX_SIGNING_KEY);
        if (eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD) != null) {
            this.signingKeyStorePassword = eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD).toCharArray();
        }
        if (eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD) != null) {
            this.signingKeyPassword = eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD).toCharArray();
        }
        this.permissionsElevated = JFXProjectProperties.isTrue(eval.getProperty(PERMISSIONS_ELEVATED));
    }

    private void initResources(PropertyEvaluator eval, Project prj, Map<String, Map<String, String>> configs) {
        String[] paths;
        String lz = eval.getProperty(DOWNLOAD_MODE_LAZY_JARS);
        String rcp = eval.getProperty(RUN_CP);
        String bc = eval.getProperty(BUILD_CLASSES);
        File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File bcDir = bc == null ? null : PropertyUtils.resolveFile((File)prjDir, (String)bc);
        ArrayList<? extends File> lazyFileList = new ArrayList<File>();
        if (lz != null) {
            for (String p : paths = PropertyUtils.tokenizePath((String)lz)) {
                lazyFileList.add(PropertyUtils.resolveFile((File)prjDir, (String)p));
            }
        }
        paths = PropertyUtils.tokenizePath((String)rcp);
        String mainJar = eval.getProperty(DIST_JAR);
        File mainFile = PropertyUtils.resolveFile((File)prjDir, (String)mainJar);
        ArrayList<FileObject> preloaders = new ArrayList<FileObject>();
        try {
            for (PreloaderArtifact pa : this.getPreloaderArtifactsFromConfigs(configs)) {
                preloaders.addAll(Arrays.asList(pa.getFileObjects()));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        ArrayList<? extends File> resFileList = new ArrayList<File>(paths.length);
        for (String p : paths) {
            File f;
            if (p.startsWith("${") && p.endsWith("}") || (f = PropertyUtils.resolveFile((File)prjDir, (String)p)).equals(mainFile)) continue;
            boolean isPrel = false;
            for (FileObject prelfo : preloaders) {
                File prelf = FileUtil.toFile((FileObject)prelfo);
                if (prelf == null || !prelf.equals(f)) continue;
                isPrel = true;
            }
            if (isPrel || bc != null && bcDir.equals(f)) continue;
            resFileList.add(f);
            if (!JFXProjectProperties.isTrue(eval.getProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, f.getName())))) continue;
            lazyFileList.add(f);
        }
        this.lazyJars = lazyFileList;
        this.runtimeCP = resFileList;
        this.lazyJarsChanged = false;
    }

    private void storeResources(EditableProperties props) {
        if (this.lazyJarsChanged) {
            props.remove((Object)DOWNLOAD_MODE_LAZY_JARS);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(DOWNLOAD_MODE_LAZY_JAR)) continue;
                it.remove();
            }
            for (File file : this.lazyJars) {
                props.setProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, file.getName()), "true");
            }
        }
    }

    private void initJSCallbacks(PropertyEvaluator eval) {
        String platformName = eval.getProperty("platform.active");
        Map<String, List<String>> callbacks = JFXProjectUtils.getJSCallbacks(platformName);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : callbacks.entrySet()) {
            String v = eval.getProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey());
            if (v == null || v.isEmpty()) continue;
            result.put(entry.getKey(), v);
        }
        this.jsCallbacks = result;
        this.jsCallbacksChanged = false;
    }

    private void storeJSCallbacks(EditableProperties props) {
        if (this.jsCallbacksChanged && this.jsCallbacks != null) {
            for (Map.Entry<String, String> entry : this.jsCallbacks.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    props.setProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey(), entry.getValue());
                    continue;
                }
                props.remove((Object)(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey()));
            }
        }
    }

    private void storePlatform(EditableProperties editableProps) {
        JavaPlatform[] installedPlatforms;
        String activePlatform = editableProps.getProperty("platform.active");
        for (JavaPlatform javaPlatform : installedPlatforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String platformName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!platformName.equals(activePlatform) || !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)javaPlatform)) continue;
            editableProps.setProperty("javafx.sdk", JavaFXPlatformUtils.getJavaFXSDKPathReference((String)activePlatform));
            editableProps.setProperty("javafx.runtime", JavaFXPlatformUtils.getJavaFXRuntimePathReference((String)activePlatform));
        }
    }

    private String getSelectedBrowserPath() {
        if (this.browserPaths == null) {
            return null;
        }
        String selectedName = this.RUN_CONFIGS.get(this.activeConfig).get(RUN_IN_BROWSER);
        return this.browserPaths.get(selectedName);
    }

    class PreloaderJarArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final URL[] classPathRoots;
        private final FileObject[] fileObjects;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderJarArtifact(@NonNull URL[] classPathRoots, @NonNull FileObject[] fileObjects, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.classPathRoots = classPathRoots;
            this.fileObjects = fileObjects;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderJarArtifact)) {
                return false;
            }
            PreloaderJarArtifact concrete = (PreloaderJarArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            return this.fileObjects;
        }
    }

    class PreloaderProjectArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final AntArtifact[] artifacts;
        private final URI[] artifactElements;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderProjectArtifact(@NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.artifacts = artifacts;
            this.artifactElements = artifactElements;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderProjectArtifact)) {
                return false;
            }
            PreloaderProjectArtifact concrete = (PreloaderProjectArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            ArrayList<FileObject> l = new ArrayList<FileObject>();
            for (AntArtifact a : this.artifacts) {
                l.addAll(Arrays.asList(a.getArtifactFiles()));
            }
            return l.toArray(new FileObject[l.size()]);
        }
    }

    abstract class PreloaderArtifact {
        private boolean valid;

        PreloaderArtifact() {
        }

        abstract boolean addDependency() throws IOException, UnsupportedOperationException;

        abstract boolean removeDependency() throws IOException, UnsupportedOperationException;

        abstract FileObject[] getFileObjects();

        void setValid(boolean valid) {
            this.valid = valid;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    public class PreloaderClassComboBoxModel
    extends DefaultComboBoxModel {
        private boolean filling = false;
        private ChangeListener changeListener = null;

        public PreloaderClassComboBoxModel() {
            this.fillNoPreloaderAvailable();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeListener = l;
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeListener = null;
        }

        public final void fillNoPreloaderAvailable() {
            this.removeAllElements();
            this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
        }

        public void fillFromProject(final Project project, final String select, final Map<String, String> config) {
            final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(project);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (project == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Preloader");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            String verify;
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            if (config != null && !JFXProjectProperties.isEqual(select, verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem())) {
                                config.put(JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        public void fillFromJAR(final FileObject jarFile, final String select, final Map<String, String> config) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (jarFile == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNamesInJar(jarFile, "javafx.application.Preloader");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            String verify;
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            if (config != null && !JFXProjectProperties.isEqual(select, verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem())) {
                                config.put(JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        private void addElements(Set<String> elems) {
            for (String elem : elems) {
                this.addElement(elem);
            }
        }
    }

    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> props, String[] sfxs, String[] clmns) {
            if (sfxs.length != clmns.length) {
                throw new IllegalArgumentException();
            }
            this.properties = props;
            this.propSuffixes = sfxs;
            this.columnNames = clmns;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.properties.get(rowIndex).put(this.propSuffixes[columnIndex], (String)aValue);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.properties.get(rowIndex).get(this.propSuffixes[columnIndex]);
        }

        public void addRow() {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            for (String suffix : this.propSuffixes) {
                emptyMap.put(suffix, "");
            }
            this.properties.add(emptyMap);
        }

        public void removeRow(int index) {
            this.properties.remove(index);
        }
    }

    public static enum SigningType {
        NOSIGN("notsigned"),
        SELF("self"),
        KEY("key");

        private final String propertyValue;

        private SigningType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static enum RunAsType {
        STANDALONE("standalone"),
        ASWEBSTART("webstart"),
        INBROWSER("embedded");

        private final String propertyValue;

        private RunAsType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static enum PreloaderSourceType {
        NONE("none"),
        PROJECT("project"),
        JAR("jar");

        private final String propertyValue;

        private PreloaderSourceType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }
}

