/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Cursor;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.windows.WindowManager;

public final class JFXProjectOpenedHook
extends ProjectOpenedHook {
    private static final Logger LOGGER = Logger.getLogger("javafx");

    protected synchronized void projectOpened() {
        JFXProjectOpenedHook.logUsage("USG_PROJECT_OPEN_JFX");
        this.checkPlatforms();
    }

    protected void projectClosed() {
        JFXProjectOpenedHook.logUsage("USG_PROJECT_CLOSE_JFX");
    }

    private static void logUsage(@NonNull String msg) {
        LogRecord logRecord = new LogRecord(Level.INFO, msg);
        logRecord.setLoggerName("org.netbeans.ui.metrics.jfx");
        Logger.getLogger("org.netbeans.ui.metrics.jfx").log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPlatforms() {
        if (!JavaFXPlatformUtils.isThereAnyJavaFXPlatform()) {
            this.switchBusy();
            try {
                JavaFXPlatformUtils.createDefaultJavaFXPlatform();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
            }
            finally {
                this.switchDefault();
            }
        }
    }

    private void switchBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void switchDefault() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }
}

