/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Image;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.openide.util.ImageUtilities;

public class JFXProjectIconAnnotator
implements ProjectIconAnnotator {
    private static final String JFX_BADGE_PATH = "org/netbeans/modules/javafx2/project/ui/resources/jfx_overlay.png";
    private final AtomicReference<Image> badgeCache = new AtomicReference();

    @NonNull
    public Image annotateIcon(@NonNull Project p, @NonNull Image original, boolean openedNode) {
        Image badge;
        if (JFXProjectIconAnnotator.isFXProject(p) && (badge = this.getJFXBadge()) != null) {
            original = ImageUtilities.mergeImages((Image)original, (Image)badge, (int)8, (int)8);
        }
        return original;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    @NullUnknown
    private Image getJFXBadge() {
        Image img = this.badgeCache.get();
        if (img == null) {
            img = ImageUtilities.loadImage((String)JFX_BADGE_PATH);
            this.badgeCache.set(img);
        }
        return img;
    }

    private static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator eval = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (eval == null) {
            return false;
        }
        return JFXProjectIconAnnotator.isTrue(eval.evaluator().getProperty("javafx.enabled"));
    }

    private static boolean isTrue(@NullAllowed String value) {
        return value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }
}

