/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class FXMLTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private static final Logger LOG = Logger.getLogger(FXMLTemplateAttributesProvider.class.getName());

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        FileObject templateFO = template.getPrimaryFile();
        if (!"fxml".equals(templateFO.getExt()) || templateFO.isFolder()) {
            return null;
        }
        FileObject targetFO = target.getPrimaryFile();
        HashMap<String, String> result = new HashMap<String, String>();
        ClassPath cp = ClassPath.getClassPath((FileObject)targetFO, (String)"classpath/source");
        if (cp == null) {
            LOG.log(Level.WARNING, "No classpath was found for folder: {0}", FileUtil.getFileDisplayName((FileObject)targetFO));
        } else if (cp.findOwnerRoot(targetFO) == null) {
            LOG.log(Level.WARNING, "Folder {0} is not on its classpath: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)targetFO), cp.toString(ClassPath.PathConversionMode.PRINT)});
        } else {
            result.put("package", cp.getResourceName(targetFO, '.', false));
        }
        return result;
    }
}

