/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class EditorContextDispatcher {
    private static final Logger logger = Logger.getLogger(EditorContextDispatcher.class.getName());
    public static final String PROP_FILE = "file";
    public static final String PROP_EDITOR = "editor";
    private static EditorContextDispatcher context;
    private final EditorLookupListener editorLookupListener;
    private final RequestProcessor refreshProcessor;
    private final Lookup.Result<FileObject> resFileObject;
    private final Lookup.Result<EditorCookie> resEditorCookie;
    private final PropertyChangeListener tcListener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, PropertyChangeSupport> pcsByMIMEType = new HashMap<String, PropertyChangeSupport>();
    private String lastFiredMIMEType = null;
    private Map<String, Object> lastMIMETypeEvents = new HashMap<String, Object>();
    private static final Reference<FileObject> NO_FILE;
    private static final Reference<EditorCookie> NO_COOKIE;
    private static final Reference<JEditorPane> NO_EDITOR;
    private static final Reference<FileChangeListener> NO_FILE_CHANGE;
    private String currentURL;
    private Reference<FileObject> currentFile = NO_FILE;
    private Reference<EditorCookie> currentEditorCookie = NO_COOKIE;
    private Reference<JEditorPane> currentOpenedPane = NO_EDITOR;
    private FileChangeListener currentFileChangeListener = null;
    private Reference<FileChangeListener> currentFileChangeListenerWeak = NO_FILE_CHANGE;
    private Reference<FileObject> mostRecentFileRef = NO_FILE;
    private Reference<EditorCookie> mostRecentEditorCookieRef = NO_COOKIE;
    private Reference<JEditorPane> mostRecentOpenedPaneRef = NO_EDITOR;
    private FileChangeListener mostRecentFileChangeListener = null;
    private Reference<FileChangeListener> mostRecentFileChangeListenerWeak = NO_FILE_CHANGE;

    public static synchronized EditorContextDispatcher getDefault() {
        if (context == null) {
            context = new EditorContextDispatcher();
        }
        return context;
    }

    private EditorContextDispatcher() {
        this.refreshProcessor = new RequestProcessor("Refresh Editor Context", 1);
        this.resFileObject = Utilities.actionsGlobalContext().lookupResult(FileObject.class);
        EditorLookupListener ell = new EditorLookupListener(FileObject.class);
        this.resFileObject.addLookupListener((LookupListener)ell);
        ell.lookupChanged(false);
        this.resEditorCookie = Utilities.actionsGlobalContext().lookupResult(EditorCookie.class);
        this.editorLookupListener = new EditorLookupListener(EditorCookie.class);
        this.resEditorCookie.addLookupListener((LookupListener)this.editorLookupListener);
        this.editorLookupListener.lookupChanged(false);
        this.tcListener = new EditorLookupListener(TopComponent.class);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PropertyChangeListener propertyChangeListener = EditorContextDispatcher.this.tcListener;
                synchronized (propertyChangeListener) {
                    ((EditorLookupListener)EditorContextDispatcher.this.tcListener).updateCurrentOpenedPane(TopComponent.getRegistry().getActivated(), EditorContextDispatcher.this.currentEditorCookie.get(), false);
                }
            }
        });
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tcListener, (Object)TopComponent.getRegistry()));
    }

    public synchronized FileObject getCurrentFile() {
        return this.currentFile.get();
    }

    public synchronized String getCurrentURLAsString() {
        if (this.currentURL == null) {
            FileObject fo = this.getCurrentFile();
            if (fo != null) {
                try {
                    this.currentURL = fo.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.currentURL == null) {
                this.currentURL = "";
            }
        }
        return this.currentURL;
    }

    private synchronized EditorCookie getCurrentEditorCookie() {
        if (this.getCurrentEditor() != null) {
            return this.currentEditorCookie.get();
        }
        return null;
    }

    public synchronized JEditorPane getCurrentEditor() {
        return this.currentOpenedPane.get();
    }

    public int getCurrentLineNumber() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    public Line getCurrentLine() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return null;
        }
        int lineNumber = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        Line.Set lineSet = e.getLineSet();
        try {
            assert (lineSet != null) : e;
            return lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public synchronized FileObject getMostRecentFile() {
        return this.mostRecentFileRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMostRecentFile(FileObject file) {
        FileObject oldFile;
        String MIMEType = null;
        EditorContextDispatcher editorContextDispatcher = this;
        synchronized (editorContextDispatcher) {
            oldFile = this.mostRecentFileRef.get();
            this.mostRecentFileRef = new WeakReference<FileObject>(file);
            if (file != null) {
                MIMEType = file.getMIMEType();
            }
        }
        this.refreshProcessor.post((Runnable)new EventFirer(PROP_EDITOR, oldFile, file, MIMEType));
    }

    public synchronized String getMostRecentURLAsString() {
        FileObject fo = this.getMostRecentFile();
        if (fo != null) {
            try {
                return fo.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return "";
    }

    private synchronized EditorCookie getMostRecentEditorCookie() {
        if (this.getMostRecentEditor() != null) {
            return this.mostRecentEditorCookieRef.get();
        }
        return null;
    }

    public synchronized JEditorPane getMostRecentEditor() {
        return this.mostRecentOpenedPaneRef.get();
    }

    public int getMostRecentLineNumber() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getMostRecentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    public Line getMostRecentLine() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = this.getMostRecentEditor();
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return null;
        }
        int lineNumber = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        Line.Set lineSet = e.getLineSet();
        try {
            return lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            HashSet<String> MIMETypes = new HashSet<String>(this.pcsByMIMEType.keySet());
            for (String MIMEType : MIMETypes) {
                PropertyChangeSupport _pcs = this.pcsByMIMEType.get(MIMEType);
                _pcs.removePropertyChangeListener(l);
                if (_pcs.getPropertyChangeListeners().length != 0) continue;
                this.pcsByMIMEType.remove(MIMEType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String MIMEType, PropertyChangeListener l) {
        PropertyChangeSupport _pcs;
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            _pcs = this.pcsByMIMEType.get(MIMEType);
            if (_pcs == null) {
                _pcs = new PropertyChangeSupport(this);
                this.pcsByMIMEType.put(MIMEType, _pcs);
            }
        }
        _pcs.addPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent evt, String preferredMIMEType) {
        block27: {
            Object object;
            block26: {
                HashMap<String, Object> lastEvents;
                this.pcs.firePropertyChange(evt);
                if (!PROP_FILE.equals(evt.getPropertyName())) break block26;
                FileObject oldFile = (FileObject)evt.getOldValue();
                FileObject newFile = (FileObject)evt.getNewValue();
                String oldMIMEType = oldFile != null ? oldFile.getMIMEType() : null;
                String newMIMEType = newFile != null ? newFile.getMIMEType() : null;
                PropertyChangeSupport pcsMIMEOld = null;
                PropertyChangeSupport pcsMIMENew = null;
                PropertyChangeEvent evtOld = null;
                PropertyChangeEvent evtNew = null;
                Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
                synchronized (map) {
                    if (oldMIMEType != null && oldMIMEType.equals(newMIMEType)) {
                        pcsMIMEOld = this.pcsByMIMEType.get(oldMIMEType);
                        evtOld = evt;
                    } else {
                        if (oldMIMEType != null && (pcsMIMEOld = this.pcsByMIMEType.get(oldMIMEType)) != null) {
                            evtOld = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), null);
                        }
                        if (newMIMEType != null && (pcsMIMENew = this.pcsByMIMEType.get(newMIMEType)) != null) {
                            evtNew = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), null, evt.getNewValue());
                        }
                    }
                }
                if (pcsMIMEOld != null) {
                    pcsMIMEOld.firePropertyChange(evtOld);
                }
                if (pcsMIMENew != null) {
                    pcsMIMENew.firePropertyChange(evtNew);
                }
                if (oldMIMEType == null || oldMIMEType.equals(newMIMEType) || pcsMIMEOld == null) break block27;
                EditorContextDispatcher editorContextDispatcher = this;
                synchronized (editorContextDispatcher) {
                    String lastMIMEType = this.lastFiredMIMEType;
                    lastEvents = new HashMap<String, Object>(this.lastMIMETypeEvents);
                    if (lastMIMEType != null && lastMIMEType.equals(oldMIMEType)) {
                        this.lastFiredMIMEType = null;
                        this.lastMIMETypeEvents.clear();
                    } else {
                        lastEvents = null;
                    }
                }
                if (lastEvents != null) {
                    for (String property : lastEvents.keySet()) {
                        pcsMIMEOld.firePropertyChange(property, lastEvents.get(property), null);
                    }
                }
                break block27;
            }
            PropertyChangeSupport pcsMIME = null;
            if (preferredMIMEType != null) {
                object = this.pcsByMIMEType;
                synchronized (object) {
                    pcsMIME = this.pcsByMIMEType.get(preferredMIMEType);
                }
                if (pcsMIME != null) {
                    pcsMIME.firePropertyChange(evt);
                }
            }
            object = this;
            synchronized (object) {
                if (pcsMIME != null) {
                    this.lastFiredMIMEType = preferredMIMEType;
                    this.lastMIMETypeEvents.put(evt.getPropertyName(), evt.getNewValue());
                } else {
                    this.lastFiredMIMEType = null;
                    this.lastMIMETypeEvents.clear();
                }
            }
        }
    }

    static {
        NO_FILE = new WeakReference<Object>(null);
        NO_COOKIE = new WeakReference<Object>(null);
        NO_EDITOR = new WeakReference<Object>(null);
        NO_FILE_CHANGE = new WeakReference<Object>(null);
    }

    private final class FileRenameListener
    extends FileChangeAdapter {
        private FileRenameListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileRenamed(FileRenameEvent fe) {
            boolean doFire;
            FileObject fo = (FileObject)fe.getSource();
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                FileObject currentFO = (FileObject)EditorContextDispatcher.this.currentFile.get();
                FileObject lastFO = (FileObject)EditorContextDispatcher.this.mostRecentFileRef.get();
                boolean bl = doFire = fo.equals(currentFO) || fo.equals(lastFO);
                if (doFire) {
                    EditorContextDispatcher.this.currentURL = null;
                }
            }
            if (doFire) {
                EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_FILE, null, fo, fo.getMIMEType()));
            }
        }
    }

    private final class EventFirer
    implements Runnable {
        private final PropertyChangeEvent evt;
        private final String MIMEType;

        public EventFirer(String propertyName, Object oldValue, Object newValue) {
            this(propertyName, oldValue, newValue, null);
        }

        public EventFirer(String propertyName, Object oldValue, Object newValue, String MIMEType) {
            this.evt = new PropertyChangeEvent(EditorContextDispatcher.this, propertyName, oldValue, newValue);
            this.MIMEType = MIMEType;
        }

        @Override
        public void run() {
            EditorContextDispatcher.this.firePropertyChange(this.evt, this.MIMEType);
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class type) {
            this.type = type;
        }

        public void resultChanged(LookupEvent ev) {
            this.lookupChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookupChanged(final boolean doFire) {
            if (this.type == FileObject.class) {
                FileObject newFile;
                FileObject oldFile;
                Collection fos = EditorContextDispatcher.this.resFileObject.allInstances();
                EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
                synchronized (editorContextDispatcher) {
                    oldFile = (FileObject)EditorContextDispatcher.this.currentFile.get();
                    newFile = fos.size() == 0 ? null : (fos.size() == 1 ? (FileObject)fos.iterator().next() : this.findPrimary(fos));
                    EditorContextDispatcher.this.currentFile = newFile == null ? NO_FILE : new WeakReference<FileObject>(newFile);
                    EditorContextDispatcher.this.currentURL = null;
                    if (newFile != null) {
                        EditorContextDispatcher.this.mostRecentFileRef = EditorContextDispatcher.this.currentFile;
                    }
                    this.reAttachFileChangeListener(oldFile, newFile, true);
                }
                if (doFire && oldFile != newFile) {
                    EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_FILE, oldFile, newFile));
                }
            } else if (this.type == EditorCookie.class) {
                EditorCookie newEditor;
                EditorCookie oldEditor;
                Collection ecs = EditorContextDispatcher.this.resEditorCookie.allInstances();
                EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
                synchronized (editorContextDispatcher) {
                    oldEditor = (EditorCookie)EditorContextDispatcher.this.currentEditorCookie.get();
                    if (oldEditor instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)oldEditor).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    if ((newEditor = ecs.size() == 0 ? null : (EditorCookie)ecs.iterator().next()) instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)newEditor).addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    EditorContextDispatcher.this.currentEditorCookie = newEditor == null ? NO_COOKIE : new WeakReference<EditorCookie>(newEditor);
                    if (EditorContextDispatcher.this.currentFile.get() != null && newEditor != null) {
                        EditorContextDispatcher.this.mostRecentEditorCookieRef = new WeakReference<EditorCookie>(newEditor);
                    }
                    if (newEditor == null) {
                        EditorContextDispatcher.this.currentOpenedPane = NO_EDITOR;
                    }
                }
                if (newEditor != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorLookupListener.this.updateCurrentOpenedPane(TopComponent.getRegistry().getActivated(), newEditor, doFire);
                        }
                    });
                } else if (doFire && oldEditor != newEditor) {
                    EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_EDITOR, oldEditor, newEditor, null));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (this.type == TopComponent.class && propertyName.equals("activated")) {
                TopComponent newComponnet = (TopComponent)evt.getNewValue();
                this.updateCurrentOpenedPane(newComponnet, null, true);
            }
            if (evt.getSource() instanceof EditorCookie.Observable) {
                final Object source = evt.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorLookupListener.this.updateCurrentOpenedPane(TopComponent.getRegistry().getActivated(), source, true);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCurrentOpenedPane(TopComponent activeComponent, Object source, boolean doFire) {
            EditorCookie ec;
            Object MIMEType = null;
            JEditorPane oldEditor = null;
            JEditorPane newEditor = null;
            boolean isSetPane = false;
            boolean loadOpenPane = false;
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                ec = (EditorCookie)EditorContextDispatcher.this.currentEditorCookie.get();
                if (source == null || source == ec) {
                    oldEditor = (JEditorPane)EditorContextDispatcher.this.currentOpenedPane.get();
                    if (ec != null && activeComponent != null) {
                        if (ec.getDocument() == null && ec instanceof EditorCookie.Observable) {
                            logger.fine("Document " + ec + " NOT yet loaded...");
                            return;
                        }
                        loadOpenPane = true;
                    }
                }
            }
            if (loadOpenPane) {
                long t1 = 0L;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Document " + ec + " loaded, updating...");
                    t1 = System.nanoTime();
                }
                JEditorPane openedPane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                if (logger.isLoggable(Level.FINE)) {
                    long t2 = System.nanoTime();
                    logger.fine("Time to find opened panes = " + (t2 - t1) + " ns = " + (t2 - t1) / 1000000L + " ms.");
                }
                if (openedPane != null && activeComponent.isAncestorOf((Component)openedPane)) {
                    newEditor = openedPane;
                    isSetPane = true;
                }
            }
            EditorContextDispatcher editorContextDispatcher2 = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher2) {
                EditorCookie ec2 = (EditorCookie)EditorContextDispatcher.this.currentEditorCookie.get();
                if (ec2 != ec) {
                } else {
                    if (!isSetPane && source == null) {
                        newEditor = null;
                    }
                    EditorContextDispatcher.this.currentOpenedPane = newEditor == null ? NO_EDITOR : new WeakReference<JEditorPane>(newEditor);
                    FileObject f = (FileObject)EditorContextDispatcher.this.currentFile.get();
                    if (f != null) {
                        if (newEditor != null) {
                            EditorContextDispatcher.this.mostRecentOpenedPaneRef = new WeakReference<JEditorPane>(newEditor);
                            this.reAttachFileChangeListener((FileObject)EditorContextDispatcher.this.mostRecentFileRef.get(), f, false);
                            EditorContextDispatcher.this.mostRecentFileRef = new WeakReference<FileObject>(f);
                            if (ec != null) {
                                EditorContextDispatcher.this.mostRecentEditorCookieRef = new WeakReference<EditorCookie>(ec);
                            }
                        }
                        if (doFire && oldEditor != newEditor) {
                            this.lazyRetrieveMIMETypeAndFire(oldEditor, newEditor, f);
                            doFire = false;
                        }
                    } else {
                        MIMEType = null;
                    }
                }
            }
            if (doFire && oldEditor != newEditor) {
                EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_EDITOR, oldEditor, newEditor, MIMEType));
            }
        }

        private void lazyRetrieveMIMETypeAndFire(final JEditorPane oldEditor, final JEditorPane newEditor, final FileObject f) {
            EditorContextDispatcher.this.refreshProcessor.post(new Runnable(){

                @Override
                public void run() {
                    String MIMEType = f.getMIMEType();
                    new EventFirer(EditorContextDispatcher.PROP_EDITOR, oldEditor, newEditor, MIMEType).run();
                }
            });
        }

        private void reAttachFileChangeListener(FileObject oldFile, FileObject newFile, boolean current) {
            assert (Thread.holdsLock(EditorContextDispatcher.this));
            if (current) {
                FileChangeListener chw;
                if (oldFile != null && (chw = (FileChangeListener)EditorContextDispatcher.this.currentFileChangeListenerWeak.get()) != null) {
                    oldFile.removeFileChangeListener(chw);
                    EditorContextDispatcher.this.currentFileChangeListenerWeak = NO_FILE_CHANGE;
                    EditorContextDispatcher.this.currentFileChangeListener = null;
                }
                if (newFile != null) {
                    EditorContextDispatcher.this.currentFileChangeListener = (FileChangeListener)new FileRenameListener();
                    chw = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)EditorContextDispatcher.this.currentFileChangeListener, (Object)newFile);
                    newFile.addFileChangeListener(chw);
                    EditorContextDispatcher.this.currentFileChangeListenerWeak = new WeakReference<FileChangeListener>(chw);
                }
            } else {
                FileChangeListener chw;
                if (oldFile != null && (chw = (FileChangeListener)EditorContextDispatcher.this.mostRecentFileChangeListenerWeak.get()) != null) {
                    oldFile.removeFileChangeListener(chw);
                    EditorContextDispatcher.this.mostRecentFileChangeListenerWeak = NO_FILE_CHANGE;
                    EditorContextDispatcher.this.mostRecentFileChangeListener = null;
                }
                if (newFile != null) {
                    EditorContextDispatcher.this.mostRecentFileChangeListener = (FileChangeListener)new FileRenameListener();
                    chw = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)EditorContextDispatcher.this.mostRecentFileChangeListener, (Object)newFile);
                    newFile.addFileChangeListener(chw);
                    EditorContextDispatcher.this.mostRecentFileChangeListenerWeak = new WeakReference<FileChangeListener>(chw);
                }
            }
        }

        private FileObject findPrimary(Collection<? extends FileObject> fos) {
            for (FileObject fileObject : fos) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fileObject);
                    if (!fileObject.equals(dobj.getPrimaryFile())) continue;
                    return fileObject;
                }
                catch (DataObjectNotFoundException ex) {
                }
            }
            return fos.iterator().next();
        }
    }
}

