/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class WebAppFilterNode
extends FilterNode {
    private boolean isTopLevelNode = false;
    private FileObject file;

    WebAppFilterNode(Project proj, Node orig, File root) {
        this(proj, orig, root, true);
    }

    private WebAppFilterNode(Project proj, Node orig, File root, boolean isTopLevel) {
        super(orig, (Children)(orig.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new WebAppFilterChildren(proj, orig, root)));
        this.isTopLevelNode = isTopLevel;
        if (isTopLevel) {
            this.file = FileUtil.toFileObject((File)root);
        }
    }

    public String getDisplayName() {
        if (this.isTopLevelNode) {
            String s = NbBundle.getMessage(WebAppFilterNode.class, (String)"LBL_Web_Pages");
            try {
                s = this.file.getFileSystem().getStatus().annotateName(s, Collections.singleton(this.file));
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return s;
        }
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.isTopLevelNode) {
            return this.getOriginal().getHtmlDisplayName();
        }
        try {
            FileSystem.Status stat = this.file.getFileSystem().getStatus();
            if (stat instanceof FileSystem.HtmlStatus) {
                String result;
                FileSystem.HtmlStatus hstat = (FileSystem.HtmlStatus)stat;
                String s = NbBundle.getMessage(WebAppFilterNode.class, (String)"LBL_Web_Pages");
                if (!s.equals(result = hstat.annotateNameHtml(s, Collections.singleton(this.file)))) {
                    return result;
                }
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean param) {
        return super.getActions(param);
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/web/webPagesBadge.png"), (int)8, (int)8);
        }
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = super.getOpenedIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/web/webPagesBadge.png"), (int)8, (int)8);
        }
        return retValue;
    }

    static class WebAppFilterChildren
    extends FilterNode.Children {
        private File root;
        private Project project;

        WebAppFilterChildren(Project proj, Node original, File rootpath) {
            super(original);
            this.root = rootpath;
            this.project = proj;
        }

        protected Node[] createNodes(Node obj) {
            FileObject fobj = (FileObject)obj.getLookup().lookup(FileObject.class);
            if (fobj != null) {
                if (!VisibilityQuery.getDefault().isVisible(fobj)) {
                    return new Node[0];
                }
                WebAppFilterNode n = new WebAppFilterNode(this.project, obj, this.root, false);
                return new Node[]{n};
            }
            Node origos = obj;
            return new Node[]{origos.cloneNode()};
        }
    }
}

