/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject.archetype;

import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.maven.api.archetype.Archetype;

abstract class BaseJ2eeArchetypeProvider {
    protected Map<Profile, Archetype> map = new TreeMap<Profile, Archetype>(Profile.UI_COMPARATOR);

    protected BaseJ2eeArchetypeProvider() {
        this.setUpProjectArchetypes();
    }

    protected abstract void setUpProjectArchetypes();

    protected void addMojoArchetype(Profile j2eeProfile, String version, String artifactId) {
        this.map.put(j2eeProfile, this.createMojoArchetype(version, artifactId));
    }

    protected void addSameMojoArchetypeForAllProfiles(String version, String artifactId) {
        Archetype archetype = this.createMojoArchetype(version, artifactId);
        this.map.put(Profile.J2EE_13, archetype);
        this.map.put(Profile.J2EE_14, archetype);
        this.map.put(Profile.JAVA_EE_5, archetype);
        this.map.put(Profile.JAVA_EE_6_FULL, archetype);
        this.map.put(Profile.JAVA_EE_6_WEB, archetype);
    }

    private Archetype createMojoArchetype(String version, String artifactId) {
        Archetype archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion(version);
        archetype.setArtifactId(artifactId);
        return archetype;
    }

    @NonNull
    public Archetype getArchetypeFor(Profile profile) {
        Archetype archetype = this.map.get(profile);
        if (archetype != null) {
            return archetype;
        }
        throw new IllegalStateException("No archetype defined for profile " + profile + " in " + this.getClass() + "; check whether all possible <Profile, Archetype> pairs have been added");
    }

    public Map<Profile, Archetype> getArchetypeMap() {
        return this.map;
    }

    @CheckForNull
    public Archetype getAnyArchetype() {
        if (this.map.isEmpty()) {
            return null;
        }
        return this.map.values().iterator().next();
    }
}

