/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.openide.WizardDescriptor;

public class ServerSelectionHelper {
    private final Deployment deployment = Deployment.getDefault();
    private final JComboBox serverModel;
    private final JComboBox j2eeVersion;
    private final J2eeModule.Type projectType;

    public ServerSelectionHelper(JComboBox serverModel, JComboBox j2eeVersion, J2eeModule.Type projectType) {
        this.serverModel = serverModel;
        this.projectType = projectType;
        this.j2eeVersion = j2eeVersion;
        this.j2eeVersion.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((Profile)value).getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        this.initServerModel(null);
        this.updatePlatformVersionModel();
    }

    private void initServerModel(String serverToSelectInstanceID) {
        Wrapper serverToSelect = null;
        ArrayList<Wrapper> servers = new ArrayList<Wrapper>();
        for (String instanceID : this.deployment.getServerInstanceIDs()) {
            if (!this.isServerInstanceValid(instanceID)) continue;
            Wrapper server = new Wrapper(instanceID);
            servers.add(server);
            if (serverToSelectInstanceID == null || !instanceID.equals(serverToSelectInstanceID)) continue;
            serverToSelect = server;
        }
        servers.add(new Wrapper("DEV-NULL"));
        this.serverModel.setModel(new DefaultComboBoxModel<Object>(servers.toArray()));
        if (serverToSelect != null) {
            this.serverModel.setSelectedItem(serverToSelect);
        }
        this.serverModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSelectionHelper.this.updatePlatformVersionModel();
            }
        });
    }

    private void updatePlatformVersionModel() {
        Profile lastSelectedProfile = this.getSelectedProfile();
        String serverInstance = this.getSelectedServer().getServerInstanceID();
        TreeSet<Profile> profiles = new TreeSet<Profile>(Profile.UI_COMPARATOR);
        if ("DEV-NULL".equals(serverInstance)) {
            if (J2eeModule.Type.WAR.equals(this.projectType)) {
                profiles.add(Profile.JAVA_EE_6_WEB);
            } else {
                profiles.add(Profile.JAVA_EE_6_FULL);
            }
            profiles.add(Profile.JAVA_EE_5);
            profiles.add(Profile.J2EE_14);
        } else {
            try {
                profiles.addAll(this.deployment.getServerInstance(serverInstance).getJ2eePlatform().getSupportedProfiles(this.projectType));
            }
            catch (InstanceRemovedException ex) {
                this.initServerModel(null);
            }
            if (profiles.contains(Profile.J2EE_13)) {
                profiles.remove(Profile.J2EE_13);
            }
            if (J2eeModule.Type.WAR.equals(this.projectType)) {
                profiles.remove(Profile.JAVA_EE_6_FULL);
            } else {
                profiles.remove(Profile.JAVA_EE_6_WEB);
            }
        }
        this.j2eeVersion.setModel(new DefaultComboBoxModel<Object>(profiles.toArray()));
        if (lastSelectedProfile != null && profiles.contains(lastSelectedProfile)) {
            this.j2eeVersion.setSelectedItem(lastSelectedProfile);
        }
    }

    public void addServerButtonPressed() {
        String addedServerInstanceID = ServerManager.showAddServerInstanceWizard();
        if (addedServerInstanceID != null) {
            this.initServerModel(addedServerInstanceID);
            this.updatePlatformVersionModel();
        }
    }

    public Profile getSelectedProfile() {
        return (Profile)this.j2eeVersion.getSelectedItem();
    }

    public void storeServerSettings(WizardDescriptor d) {
        Wrapper wrapper = this.getSelectedServer();
        String instanceID = wrapper.getServerInstanceID();
        String serverID = wrapper.getServerID();
        String version = this.getSelectedProfile().toPropertiesString();
        if ("DEV-NULL".equals(instanceID)) {
            instanceID = null;
            serverID = null;
        }
        d.putProperty("netbeans.deployment.server.id", (Object)instanceID);
        d.putProperty("netbeans.hint.deploy.server", (Object)serverID);
        d.putProperty("netbeans.hint.j2eeVersion", (Object)version);
    }

    private Wrapper getSelectedServer() {
        return (Wrapper)this.serverModel.getSelectedItem();
    }

    private boolean isServerInstanceValid(String instanceID) {
        ServerInstance instance = this.deployment.getServerInstance(instanceID);
        try {
            if (instance != null && instance.getDisplayName() != null && instance.getJ2eePlatform().getSupportedTypes().contains(this.projectType)) {
                return true;
            }
        }
        catch (InstanceRemovedException ex) {
            return false;
        }
        return false;
    }
}

