/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.newproject.BaseWizardIterator;
import org.netbeans.modules.maven.j2ee.newproject.EELevelPanel;
import org.netbeans.modules.maven.j2ee.newproject.archetype.J2eeArchetypeFactory;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EEWizardIterator
extends BaseWizardIterator {
    public static final String PROP_EE_LEVEL = "eeLevel";
    private J2eeModule.Type projectType;

    private EEWizardIterator(J2eeModule.Type projectType) {
        this.projectType = projectType;
    }

    public static EEWizardIterator createWebAppIterator() {
        return new EEWizardIterator(J2eeModule.Type.WAR);
    }

    public static EEWizardIterator createEJBIterator() {
        return new EEWizardIterator(J2eeModule.Type.EJB);
    }

    public static EEWizardIterator createAppClientIterator() {
        return new EEWizardIterator(J2eeModule.Type.CAR);
    }

    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        Profile profile = (Profile)this.wiz.getProperty(PROP_EE_LEVEL);
        Archetype archetype = J2eeArchetypeFactory.getInstance().findArchetypeFor(this.projectType, profile);
        ArchetypeWizards.logUsage((String)archetype.getGroupId(), (String)archetype.getArtifactId(), (String)archetype.getVersion());
        File rootFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        ArchetypeWizards.createFromArchetype((File)rootFile, (ProjectInfo)vi, (Archetype)archetype, null, (boolean)true);
        Set projects = ArchetypeWizards.openProjects((File)rootFile, (File)rootFile);
        for (FileObject projectFile : projects) {
            this.saveSettingsToNbConfiguration(projectFile);
            POHImpl.setNewlyCreated(true);
        }
        return projects;
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new EELevelPanel(this.projectType)};
    }
}

