/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.newproject.BaseWizardIterator;
import org.netbeans.modules.maven.j2ee.newproject.EAWizardPanel;
import org.netbeans.modules.maven.j2ee.newproject.archetype.J2eeArchetypeFactory;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EAWizardIterator
extends BaseWizardIterator {
    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo ear_vi = (ProjectInfo)this.wiz.getProperty("ear_versionInfo");
        assert (ear_vi != null);
        ProjectInfo web_vi = (ProjectInfo)this.wiz.getProperty("web_versionInfo");
        ProjectInfo ejb_vi = (ProjectInfo)this.wiz.getProperty("ejb_versionInfo");
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        File rootFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        File earFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("ear_projdir")));
        ArchetypeWizards.createFromArchetype((File)rootFile, (ProjectInfo)vi, (Archetype)J2eeArchetypeFactory.getInstance().getAnyArchetypeFor(J2eeModule.Type.RAR), null, (boolean)true);
        ArchetypeWizards.createFromArchetype((File)earFile, (ProjectInfo)ear_vi, (Archetype)((Archetype)this.wiz.getProperty("ear_archetype")), null, (boolean)false);
        if (web_vi != null) {
            ArchetypeWizards.createFromArchetype((File)FileUtil.normalizeFile((File)((File)this.wiz.getProperty("web_projdir"))), (ProjectInfo)web_vi, (Archetype)((Archetype)this.wiz.getProperty("web_archetype")), null, (boolean)false);
        }
        if (ejb_vi != null) {
            ArchetypeWizards.createFromArchetype((File)FileUtil.normalizeFile((File)((File)this.wiz.getProperty("ejb_projdir"))), (ProjectInfo)ejb_vi, (Archetype)((Archetype)this.wiz.getProperty("ejb_archetype")), null, (boolean)false);
        }
        this.addEARDependencies((File)this.wiz.getProperty("ear_projdir"), ejb_vi, web_vi);
        Set projects = ArchetypeWizards.openProjects((File)rootFile, (File)earFile);
        for (FileObject projectFile : projects) {
            this.saveSettingsToNbConfiguration(projectFile);
            String projectDirName = projectFile.getName();
            if (!projectDirName.endsWith("-ejb") && !projectDirName.endsWith("-ear") && !projectDirName.endsWith("-web")) continue;
            this.saveServerToPom(ProjectManager.getDefault().findProject(projectFile));
        }
        return projects;
    }

    private void addEARDependencies(File earDir, ProjectInfo ejbInfo, ProjectInfo webInfo) {
        FileObject earDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)earDir));
        if (earDirFO == null) {
            return;
        }
        ArrayList<ModelOperation> operations = new ArrayList<ModelOperation>();
        if (ejbInfo != null) {
            operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)ejbInfo, (String)"ejb"));
        }
        if (webInfo != null) {
            operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)webInfo, (String)"war"));
        }
        Utilities.performPOMModelOperations((FileObject)earDirFO.getFileObject("pom.xml"), operations);
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new EAWizardPanel(vg)};
    }
}

