/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.customizer.BaseRunCustomizer;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CustomizerRunWeb
extends BaseRunCustomizer {
    public static final String PROP_SHOW_IN_BROWSER = "netbeans.deploy.showBrowser";
    private WebModule module;
    private WebModuleProviderImpl moduleProvider;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private boolean isRunCompatible;
    private boolean isDebugCompatible;
    private boolean isProfileCompatible;
    private String oldUrl;
    private String oldContextPath;
    private JCheckBox cbBrowser;
    private JComboBox comProfile;
    private JComboBox comServer;
    private JLabel dosDescription;
    private JCheckBox jCheckBoxDeployOnSave;
    private JLabel lblContextPath;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJ2EEVersion;
    private JLabel lblProfile;
    private JLabel lblRelativeUrl;
    private JLabel lblServer;
    private JTextField txtContextPath;
    private JTextField txtJ2EEVersion;
    private JTextField txtRelativeUrl;

    public CustomizerRunWeb(final ModelHandle handle, Project project) {
        super(handle, project);
        this.initComponents();
        this.module = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        this.moduleProvider = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        assert (this.moduleProvider != null);
        assert (this.module != null);
        this.loadServerModel(this.comServer, J2eeModule.Type.WAR, this.module.getJ2eeProfile());
        this.comProfile.setRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Profile prf = (Profile)value;
                String val = "Web";
                if (Profile.JAVA_EE_6_FULL.equals(prf)) {
                    val = "Full";
                }
                return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
            }
        });
        Profile p = this.module.getJ2eeProfile();
        String version = p.equals(Profile.JAVA_EE_6_WEB) ? Profile.JAVA_EE_6_FULL.getDisplayName() : p.getDisplayName();
        this.txtJ2EEVersion.setText(version);
        WebModuleImpl impl = this.moduleProvider.getWebModuleImplementation();
        if (Profile.JAVA_EE_6_WEB.equals(impl.getDescriptorJ2eeProfile())) {
            this.lblProfile.setVisible(true);
            this.comProfile.setVisible(true);
            this.comProfile.setEnabled(true);
            this.comProfile.setModel(new DefaultComboBoxModel<Object>(new Object[]{Profile.JAVA_EE_6_WEB, Profile.JAVA_EE_6_FULL}));
            Profile prop = impl.getPropertyJ2eeProfile();
            if (prop != null) {
                this.comProfile.setSelectedItem(prop);
            } else {
                this.comProfile.setSelectedItem(Profile.JAVA_EE_6_WEB);
            }
            this.comProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Profile p = (Profile)CustomizerRunWeb.this.comProfile.getSelectedItem();
                    org.netbeans.modules.maven.model.pom.Project root = handle.getPOMModel().getProject();
                    if (p.equals(Profile.JAVA_EE_6_FULL)) {
                        Properties props = root.getProperties();
                        if (props == null) {
                            props = handle.getPOMModel().getFactory().createProperties();
                            root.setProperties(props);
                        }
                        CustomizerRunWeb.this.replaceDependency("javaee-web-api", "javaee-api");
                        props.setProperty("netbeans.hint.j2eeVersion", p.toPropertiesString());
                        handle.markAsModified((Object)handle.getPOMModel());
                    } else {
                        Properties props = root.getProperties();
                        if (props != null && props.getProperty("netbeans.hint.j2eeVersion") != null) {
                            props.setProperty("netbeans.hint.j2eeVersion", null);
                            if (props.getProperties().size() == 0) {
                                ((AbstractDocumentComponent)root).removeChild("properties", (Component)props);
                            }
                            CustomizerRunWeb.this.replaceDependency("javaee-api", "javaee-web-api");
                            handle.markAsModified((Object)handle.getPOMModel());
                        }
                    }
                }
            });
        } else {
            this.lblProfile.setVisible(false);
            this.comProfile.setVisible(false);
            this.comProfile.setEnabled(false);
        }
        this.txtContextPath.setText(impl.getContextPath());
        this.initValues();
        this.initDeployOnSaveComponent(this.jCheckBoxDeployOnSave, this.dosDescription);
        this.initServerComponent(this.comServer, this.lblServer);
    }

    private void initValues() {
        List actionMappings = this.handle.getActionMappings(this.handle.getActiveConfiguration()).getActions();
        for (NetbeansActionMapping actionMapping : actionMappings) {
            String actionName = actionMapping.getActionName();
            if ("run".equals(actionName)) {
                this.run = actionMapping;
            }
            if ("debug".equals(actionName)) {
                this.debug = actionMapping;
            }
            if (!"profile".equals(actionName)) continue;
            this.profile = actionMapping;
        }
        if (actionMappings == null || actionMappings.isEmpty()) {
            this.run = ModelHandle.getDefaultMapping((String)"run", (Project)this.project);
            this.debug = ModelHandle.getDefaultMapping((String)"debug", (Project)this.project);
            this.profile = ModelHandle.getDefaultMapping((String)"profile", (Project)this.project);
        }
        this.isRunCompatible = this.checkMapping(this.run);
        this.isDebugCompatible = this.checkMapping(this.debug);
        this.isProfileCompatible = this.checkMapping(this.profile);
        String string = this.oldUrl = this.isRunCompatible ? (String)this.run.getProperties().get("netbeans.deploy.clientUrlPart") : (String)this.debug.getProperties().get("netbeans.deploy.clientUrlPart");
        if (this.oldUrl != null) {
            this.txtRelativeUrl.setText(this.oldUrl);
        } else {
            this.oldUrl = "";
        }
        this.txtRelativeUrl.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                CustomizerRunWeb.this.applyRelUrl();
            }
        });
        String browser = (String)this.project.getProjectDirectory().getAttribute(PROP_SHOW_IN_BROWSER);
        boolean bool = browser != null ? Boolean.parseBoolean(browser) : true;
        this.cbBrowser.setSelected(bool);
        this.updateContextPathEnablement();
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.lblContextPath = new JLabel();
        this.txtContextPath = new JTextField();
        this.cbBrowser = new JCheckBox();
        this.lblHint1 = new JLabel();
        this.lblRelativeUrl = new JLabel();
        this.txtRelativeUrl = new JTextField();
        this.lblHint2 = new JLabel();
        this.lblProfile = new JLabel();
        this.comProfile = new JComboBox();
        this.jCheckBoxDeployOnSave = new JCheckBox();
        this.dosDescription = new JLabel();
        this.lblServer.setLabelFor(this.comServer);
        Mnemonics.setLocalizedText((JLabel)this.lblServer, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Server"));
        this.comServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRunWeb.this.comServerActionPerformed(evt);
            }
        });
        this.lblJ2EEVersion.setLabelFor(this.txtJ2EEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblJ2EEVersion, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        this.lblContextPath.setLabelFor(this.txtContextPath);
        Mnemonics.setLocalizedText((JLabel)this.lblContextPath, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Context_Path"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBrowser, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Display_on_Run"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Hint1"));
        this.lblRelativeUrl.setLabelFor(this.txtRelativeUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRelativeUrl, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Relative_URL"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"LBL_Hint2"));
        Mnemonics.setLocalizedText((JLabel)this.lblProfile, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.lblProfile.text"));
        this.comProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDeployOnSave, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.jCheckBoxDeployOnSave.text"));
        Mnemonics.setLocalizedText((JLabel)this.dosDescription, (String)NbBundle.getMessage(CustomizerRunWeb.class, (String)"CustomizerRunWeb.dosDescription.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxDeployOnSave).addContainerGap(404, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbBrowser, GroupLayout.Alignment.LEADING).addComponent(this.lblHint1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblRelativeUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lblHint2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 324, Short.MAX_VALUE)).addComponent(this.txtRelativeUrl, -1, 431, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblContextPath).addComponent(this.lblJ2EEVersion).addComponent(this.lblServer)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comServer, GroupLayout.Alignment.TRAILING, 0, 430, Short.MAX_VALUE).addComponent(this.txtContextPath, -1, 430, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.txtJ2EEVersion, -1, 189, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comProfile, 0, 199, Short.MAX_VALUE))))).addGap(0, 0, 0)))).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.dosDescription, -1, 491, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServer).addComponent(this.comServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJ2EEVersion).addComponent(this.txtJ2EEVersion, -2, -1, -2).addComponent(this.lblProfile).addComponent(this.comProfile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblContextPath).addComponent(this.txtContextPath, -2, -1, -2)).addGap(20, 20, 20).addComponent(this.cbBrowser).addGap(16, 16, 16).addComponent(this.lblHint1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRelativeUrl).addComponent(this.txtRelativeUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDeployOnSave).addGap(5, 5, 5).addComponent(this.dosDescription, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.txtJ2EEVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.txtJ2EEVersion.AccessibleContext.accessibleDescription"));
        this.txtContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.txtContextPath.AccessibleContext.accessibleDescription"));
        this.cbBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
        this.txtRelativeUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.txtRelativeUrl.AccessibleContext.accessibleDescription"));
    }

    private void comServerActionPerformed(ActionEvent evt) {
        this.updateContextPathEnablement();
    }

    private void updateContextPathEnablement() {
        Wrapper wp = (Wrapper)this.comServer.getSelectedItem();
        if (wp == null || "DEV-NULL".equals(wp.getServerID()) && wp.getSessionServerInstanceId() == null) {
            if (this.txtContextPath.isEnabled()) {
                this.txtContextPath.setEnabled(false);
                this.oldContextPath = this.txtContextPath.getText();
                this.txtContextPath.setText(NbBundle.getMessage(CustomizerRunWeb.class, (String)"WebRunCustomizerPanel.contextPathDisabled"));
            }
        } else if (!this.txtContextPath.isEnabled()) {
            this.txtContextPath.setEnabled(true);
            WebModuleImpl impl = this.moduleProvider.getWebModuleImplementation();
            if (this.oldContextPath != null) {
                this.txtContextPath.setText(this.oldContextPath);
            } else {
                this.txtContextPath.setText(impl.getContextPath());
            }
        }
    }

    private boolean checkMapping(NetbeansActionMapping map) {
        if (map == null) {
            return false;
        }
        for (String goal : map.getGoals()) {
            if (goal.indexOf("netbeans-deploy-plugin") <= -1) continue;
            return true;
        }
        return map.getProperties().containsKey("netbeans.deploy");
    }

    private void applyRelUrl() {
        String newUrl = this.txtRelativeUrl.getText().trim();
        if (!newUrl.equals(this.oldUrl)) {
            if (this.isRunCompatible) {
                this.run.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.run, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isDebugCompatible) {
                this.debug.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.debug, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isProfileCompatible) {
                this.profile.addProperty("netbeans.deploy.clientUrlPart", newUrl);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.profile, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
        }
    }

    @Override
    public void applyChangesInAWT() {
        assert (SwingUtilities.isEventDispatchThread());
        boolean bool = this.cbBrowser.isSelected();
        try {
            this.project.getProjectDirectory().setAttribute(PROP_SHOW_IN_BROWSER, (Object)(bool ? null : Boolean.FALSE.toString()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Object obj = this.comServer.getSelectedItem();
        if (obj != null) {
            LoggingUtils.logUsage(CustomizerRunWeb.class, "USG_PROJECT_CONFIG_MAVEN_SERVER", new Object[]{obj.toString()}, "maven");
        }
    }

    @Override
    public void applyChanges() {
        assert (!SwingUtilities.isEventDispatchThread());
        SessionContent sc = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (this.listener.getValue() != null) {
            sc.setServerInstanceId(null);
        }
        ProjectManager.mutex().postReadRequest(new Runnable(){

            @Override
            public void run() {
                POHImpl poh = (POHImpl)CustomizerRunWeb.this.project.getLookup().lookup(POHImpl.class);
                poh.hackModuleServerChange(false);
                CustomizerRunWeb.this.moduleProvider = (WebModuleProviderImpl)((Object)CustomizerRunWeb.this.project.getLookup().lookup(WebModuleProviderImpl.class));
                if (CustomizerRunWeb.this.txtContextPath.isEnabled()) {
                    String contextPath = CustomizerRunWeb.this.txtContextPath.getText().trim();
                    WebModuleImpl impl = CustomizerRunWeb.this.moduleProvider.getWebModuleImplementation();
                    impl.setContextPath(contextPath);
                }
            }
        });
    }

    private void replaceDependency(String oldArt, String newArt) {
        Dependency d = ModelUtils.checkModelDependency((POMModel)this.handle.getPOMModel(), (String)"javax", (String)oldArt, (boolean)false);
        if (d != null) {
            d.setArtifactId(newArt);
        }
    }

    public static boolean isDeployOnSave(Project project) {
        AuxiliaryProperties prop = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        String deployOnSave = prop.get("netbeans.deploy.on.save", true);
        if (deployOnSave != null) {
            return Boolean.parseBoolean(deployOnSave);
        }
        return true;
    }
}

