/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.nbdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.dialog.FullImageGridPreview;
import org.netbeans.modules.vmd.game.dialog.PartialImageGridPreview;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TiledLayerDialog
extends JPanel
implements ActionListener {
    private GlobalRepository gameDesign;
    private static final Icon ICON_ERROR = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/error.gif", (boolean)false);
    private static final int DEFAULT_COLS = 20;
    private static final int DEFAULT_ROWS = 20;
    private static final int DEFAULT_TILE_WIDTH = 18;
    private static final int DEFAULT_TILE_HEIGHT = 18;
    private ButtonGroup buttonGroupLayers;
    private JButton buttonImportImages;
    private JCheckBox checkBoxZoom;
    private JTextField fieldLayerName;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelError;
    private JLabel labelImageFile;
    private JLabel labelImagePreview;
    private JLabel labelTileHeight;
    private JLabel labelTileWidth;
    private JList listImageFileName;
    private JPanel panelCustomizer;
    private JPanel panelError;
    private JPanel panelImage;
    private JPanel panelLayerInfo;
    private JPanel panelPreview;
    private JSlider sliderHeight;
    private JSlider sliderWidth;
    private DialogDescriptor dd;
    public static final boolean DEBUG = false;
    private SliderListener sliderListener = new SliderListener();
    private AbstractImagePreviewComponent imagePreview;
    private PartialImageGridPreview partialImagePreview = new PartialImageGridPreview();
    private FullImageGridPreview fullImagePreview = new FullImageGridPreview();
    private Scene scene;
    private List<Integer> tileWidths;
    private List<Integer> tileHeigths;

    public TiledLayerDialog(GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
        this.initComponents();
        this.manualInit();
    }

    public TiledLayerDialog(Scene parent) {
        this(parent.getGameDesign());
        this.scene = parent;
    }

    private void initComponents() {
        this.buttonGroupLayers = new ButtonGroup();
        this.panelCustomizer = new JPanel();
        this.labelImageFile = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listImageFileName = new JList();
        this.buttonImportImages = new JButton();
        this.panelPreview = new JPanel();
        this.labelImagePreview = new JLabel();
        this.panelImage = new JPanel();
        this.sliderWidth = new JSlider();
        this.sliderHeight = new JSlider();
        this.labelTileWidth = new JLabel();
        this.labelTileHeight = new JLabel();
        this.checkBoxZoom = new JCheckBox();
        this.panelError = new JPanel();
        this.labelError = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.panelLayerInfo = new JPanel();
        this.fieldLayerName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.labelImageFile.setLabelFor(this.listImageFileName);
        Mnemonics.setLocalizedText((JLabel)this.labelImageFile, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.txt"));
        this.listImageFileName.setModel(this.getImageListModel());
        this.listImageFileName.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.listImageFileName);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonImportImages, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.txt"));
        this.buttonImportImages.setActionCommand(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.txt"));
        GroupLayout panelCustomizerLayout = new GroupLayout(this.panelCustomizer);
        this.panelCustomizer.setLayout(panelCustomizerLayout);
        panelCustomizerLayout.setHorizontalGroup(panelCustomizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCustomizerLayout.createSequentialGroup().addGroup(panelCustomizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelImageFile).addComponent(this.buttonImportImages).addComponent(this.jScrollPane1, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        panelCustomizerLayout.setVerticalGroup(panelCustomizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCustomizerLayout.createSequentialGroup().addComponent(this.labelImageFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.buttonImportImages)));
        this.labelImageFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.accessible.name"));
        this.labelImageFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.accessible.description"));
        this.buttonImportImages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.accessible.name"));
        this.buttonImportImages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.accessible.description"));
        this.labelImagePreview.setLabelFor(this.panelImage);
        this.labelImagePreview.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.txt"));
        this.panelImage.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panelImage.setLayout(new BorderLayout());
        this.sliderHeight.setOrientation(1);
        this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object[])new Object[]{0}));
        this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object[])new Object[]{0}));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxZoom, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.txt"));
        this.checkBoxZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkBoxZoom.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout panelPreviewLayout = new GroupLayout(this.panelPreview);
        this.panelPreview.setLayout(panelPreviewLayout);
        panelPreviewLayout.setHorizontalGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPreviewLayout.createSequentialGroup().addContainerGap().addGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPreviewLayout.createSequentialGroup().addComponent(this.labelTileWidth).addGap(51, 51, 51).addComponent(this.labelTileHeight).addContainerGap()).addGroup(panelPreviewLayout.createSequentialGroup().addComponent(this.sliderWidth, -1, 454, Short.MAX_VALUE).addGap(22, 22, 22)).addGroup(GroupLayout.Alignment.TRAILING, panelPreviewLayout.createSequentialGroup().addGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, panelPreviewLayout.createSequentialGroup().addComponent(this.labelImagePreview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 224, Short.MAX_VALUE).addComponent(this.checkBoxZoom)).addComponent(this.panelImage, -1, 454, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderHeight, -2, -1, -2)))));
        panelPreviewLayout.setVerticalGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelPreviewLayout.createSequentialGroup().addGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelImagePreview).addComponent(this.checkBoxZoom)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sliderHeight, GroupLayout.Alignment.LEADING, -1, 249, Short.MAX_VALUE).addComponent(this.panelImage, GroupLayout.Alignment.LEADING, -1, 249, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderWidth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelPreviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTileWidth, -2, 16, -2).addComponent(this.labelTileHeight))));
        this.labelImagePreview.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.accessible.name"));
        this.labelImagePreview.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.accessible.description"));
        this.sliderWidth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderWidth.accessible.name"));
        this.sliderWidth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderWidth.accessible.description"));
        this.sliderHeight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderHeight.accessible.name"));
        this.sliderHeight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderHeight.accessible.description"));
        this.checkBoxZoom.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.accessible.name"));
        this.checkBoxZoom.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.accessible.description"));
        this.labelError.setForeground(new Color(255, 0, 0));
        GroupLayout panelErrorLayout = new GroupLayout(this.panelError);
        this.panelError.setLayout(panelErrorLayout);
        panelErrorLayout.setHorizontalGroup(panelErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelError, GroupLayout.Alignment.TRAILING, -1, 757, Short.MAX_VALUE));
        panelErrorLayout.setVerticalGroup(panelErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelErrorLayout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).addComponent(this.labelError, -2, 27, -2)));
        this.jLabel3.setLabelFor(this.fieldLayerName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.txt"));
        GroupLayout panelLayerInfoLayout = new GroupLayout(this.panelLayerInfo);
        this.panelLayerInfo.setLayout(panelLayerInfoLayout);
        panelLayerInfoLayout.setHorizontalGroup(panelLayerInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayerInfoLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fieldLayerName, -1, 611, Short.MAX_VALUE)));
        panelLayerInfoLayout.setVerticalGroup(panelLayerInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayerInfoLayout.createSequentialGroup().addContainerGap().addGroup(panelLayerInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fieldLayerName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.accessible.name"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.accessible.description"));
        this.jSeparator2.setOrientation(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelLayerInfo, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.panelCustomizer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 8, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelPreview, -1, -1, Short.MAX_VALUE)).addComponent(this.jSeparator1, -1, 757, Short.MAX_VALUE).addComponent(this.panelError, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelLayerInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCustomizer, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 325, Short.MAX_VALUE).addComponent(this.panelPreview, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelError, -2, -1, -2).addContainerGap()));
    }

    public void setDialogDescriptor(DialogDescriptor dd) {
        this.dd = dd;
    }

    private void manualInit() {
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.accessible.description"));
        this.labelError.setIcon(ICON_ERROR);
        this.labelError.setText(null);
        this.fieldLayerName.getDocument().addDocumentListener(new LayerFieldListener());
        this.fieldLayerName.addFocusListener(new LayerFieldListener());
        this.listImageFileName.addListSelectionListener(new ImageListListener());
        this.listImageFileName.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList src, Object value, int index, boolean isSelected, boolean hasfocus) {
                Map.Entry entry = (Map.Entry)value;
                return super.getListCellRendererComponent((JList<?>)src, entry.getValue(), index, isSelected, hasfocus);
            }
        });
        this.sliderWidth.setModel(new DefaultBoundedRangeModel());
        this.sliderHeight.setModel(new DefaultBoundedRangeModel());
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
        this.sliderWidth.setValue(0);
        this.sliderHeight.setValue(0);
        this.sliderWidth.setPaintLabels(true);
        this.sliderHeight.setPaintLabels(true);
        this.sliderWidth.setSnapToTicks(true);
        this.sliderHeight.setSnapToTicks(true);
        this.sliderWidth.setEnabled(false);
        this.sliderHeight.setEnabled(false);
        this.checkBoxZoom.setEnabled(false);
        this.buttonImportImages.addActionListener(this);
        this.setPreviewFull();
        this.checkBoxZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TiledLayerDialog.this.checkBoxZoom.isSelected()) {
                    TiledLayerDialog.this.setPreviewPartial();
                } else {
                    TiledLayerDialog.this.setPreviewFull();
                }
            }
        });
    }

    private void setPreviewPartial() {
        if (this.imagePreview != null) {
            try {
                this.partialImagePreview.setImageURL(this.imagePreview.getImageURL());
            }
            catch (MalformedURLException e) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt"));
                e.printStackTrace();
                return;
            }
            catch (IllegalArgumentException iae) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt"));
                return;
            }
            this.partialImagePreview.setTileWidth(this.imagePreview.getTileWidth());
            this.partialImagePreview.setTileHeight(this.imagePreview.getTileHeight());
        }
        this.panelImage.removeAll();
        this.panelImage.add((Component)this.partialImagePreview, "Center");
        this.imagePreview = this.partialImagePreview;
        this.repaint();
        this.validate();
    }

    private void setPreviewFull() {
        if (this.imagePreview != null) {
            try {
                this.fullImagePreview.setImageURL(this.imagePreview.getImageURL());
            }
            catch (MalformedURLException e) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt"));
                e.printStackTrace();
                return;
            }
            catch (IllegalArgumentException iae) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt"));
                iae.printStackTrace();
                return;
            }
            this.fullImagePreview.setTileWidth(this.imagePreview.getTileWidth());
            this.fullImagePreview.setTileHeight(this.imagePreview.getTileHeight());
        }
        this.panelImage.removeAll();
        JScrollPane scroll = new JScrollPane(this.fullImagePreview);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.panelImage.add((Component)scroll, "Center");
        this.imagePreview = this.fullImagePreview;
        this.repaint();
        this.validate();
    }

    private List<Map.Entry<FileObject, String>> getImageList() {
        Map imgMap = MidpProjectSupport.getImagesForProject((DesignDocument)this.gameDesign.getDesignDocument(), (boolean)true);
        ArrayList<Map.Entry<FileObject, String>> list = new ArrayList<Map.Entry<FileObject, String>>();
        list.addAll(imgMap.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object a, Object b) {
                Map.Entry ea = (Map.Entry)a;
                Map.Entry eb = (Map.Entry)b;
                return ((String)ea.getValue()).compareTo((String)eb.getValue());
            }
        });
        return list;
    }

    private DefaultListModel getImageListModel() {
        DefaultListModel<Map.Entry<FileObject, String>> dlm = new DefaultListModel<Map.Entry<FileObject, String>>();
        List<Map.Entry<FileObject, String>> images = this.getImageList();
        for (Map.Entry<FileObject, String> imageEntry : images) {
            dlm.addElement(imageEntry);
        }
        return dlm;
    }

    private String getFieldLayerNameError() {
        String illegalIdentifierName = NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelInvalidName.txt");
        String errMsg = null;
        String layerName = this.fieldLayerName.getText();
        if (layerName.equals("")) {
            errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelEnterName.txt");
        } else if (!this.gameDesign.isComponentNameAvailable(layerName)) {
            errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelNameExists.txt");
        } else if (!TiledLayerDialog.isValidJavaIdentifier(layerName)) {
            errMsg = illegalIdentifierName;
        }
        return errMsg;
    }

    private static boolean isValidJavaIdentifier(String str) {
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setOKButtonEnabled(boolean enable) {
        if (!enable) {
            this.labelError.setIcon(ICON_ERROR);
        } else {
            this.labelError.setIcon(null);
        }
        this.dd.setValid(enable);
    }

    private String getFieldImageFileNameError() {
        String errMsg = null;
        if (this.listImageFileName.getModel().getSize() == 0) {
            errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelNoImages.txt");
        } else if (this.listImageFileName.getSelectedValue() == null) {
            errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImgFile.txt");
        } else {
            Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
            URL imageURL = null;
            try {
                imageURL = ((FileObject)entry.getKey()).getURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String relativeResourcePath = (String)entry.getValue();
            assert (imageURL != null);
            assert (relativeResourcePath != null);
            String imgName = CodeUtils.getIdealImageName(relativeResourcePath);
            List<String> derivedImageNames = GlobalRepository.deriveUsedNames(imgName);
            for (String derivedName : derivedImageNames) {
                if (!derivedName.equals(this.fieldLayerName.getText())) continue;
                errMsg = NbBundle.getMessage(SpriteDialog.class, (String)"SpriteDialog.imgFileSameAsLayerName.txt");
            }
        }
        return errMsg;
    }

    private void handleImageStateChange() {
        String errMsg = null;
        boolean imgSelected = !this.listImageFileName.isSelectionEmpty();
        this.sliderWidth.setEnabled(imgSelected);
        this.sliderHeight.setEnabled(imgSelected);
        this.checkBoxZoom.setEnabled(imgSelected);
        errMsg = this.getFieldLayerNameError();
        if (!imgSelected) {
            this.clearImagePreview();
        } else {
            try {
                this.loadImagePreview();
            }
            catch (MalformedURLException e) {
                errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt");
                e.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                errMsg = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt");
                iae.printStackTrace();
            }
        }
        if (errMsg == null) {
            errMsg = this.getFieldImageFileNameError();
        }
        if (errMsg != null) {
            this.labelError.setText(errMsg);
            this.setOKButtonEnabled(false);
        } else {
            this.labelError.setText("");
            this.setOKButtonEnabled(true);
        }
    }

    private void clearImagePreview() {
        this.sliderWidth.removeChangeListener(this.sliderListener);
        this.sliderHeight.removeChangeListener(this.sliderListener);
        this.sliderWidth.setModel(new DefaultBoundedRangeModel());
        this.sliderHeight.setModel(new DefaultBoundedRangeModel());
        this.sliderWidth.setValue(0);
        this.sliderHeight.setValue(0);
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
    }

    private void loadImagePreview() throws MalformedURLException, IllegalArgumentException {
        Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
        URL imageURL = null;
        try {
            if (entry == null || entry.getKey() == null || ((FileObject)entry.getKey()).getURL() == null) {
                Debug.warning((Object[])new Object[]{"imageURL is null"});
            } else {
                imageURL = ((FileObject)entry.getKey()).getURL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imageURL == null) {
            return;
        }
        this.sliderWidth.removeChangeListener(this.sliderListener);
        this.sliderHeight.removeChangeListener(this.sliderListener);
        this.imagePreview.setImageURL(imageURL);
        this.tileWidths = this.imagePreview.getValidTileWidths();
        this.tileHeigths = this.imagePreview.getValidTileHeights();
        DefaultBoundedRangeModel modelWidth = new DefaultBoundedRangeModel(this.tileWidths.size() - 1, 0, 0, this.tileWidths.size() - 1);
        DefaultBoundedRangeModel modelHeight = new DefaultBoundedRangeModel(this.tileHeigths.size() - 1, 0, 0, this.tileHeigths.size() - 1);
        this.sliderWidth.setModel(modelWidth);
        this.sliderHeight.setModel(modelHeight);
        this.sliderWidth.setValue(this.tileWidths.indexOf(TiledLayerDialog.getNearestValue(18, this.tileWidths)));
        this.sliderHeight.setValue(this.tileHeigths.indexOf(TiledLayerDialog.getNearestValue(18, this.tileHeigths)));
        int tileWidth = this.tileWidths.get(this.sliderWidth.getValue());
        int tileHeight = this.tileHeigths.get(this.sliderHeight.getValue());
        this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object)tileHeight));
        this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object)tileWidth));
        this.imagePreview.setTileWidth(tileWidth);
        this.imagePreview.setTileHeight(tileHeight);
        this.repaint();
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
    }

    private static int getNearestValue(int mark, List<Integer> values) {
        int nearest = Integer.MAX_VALUE;
        for (Integer value : values) {
            int nearestDiff = Math.abs(mark - nearest);
            int valueDiff = Math.abs(mark - value);
            if (valueDiff >= nearestDiff && (valueDiff != nearestDiff || value <= nearest)) continue;
            nearest = value;
        }
        return nearest;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == NotifyDescriptor.OK_OPTION) {
            this.handleOKButton();
        }
        if (e.getSource() == this.buttonImportImages) {
            try {
                this.handleImportImagesButton();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImportImagesButton() throws IOException {
        InputStream inImgPlatformTiles = TiledLayerDialog.class.getResourceAsStream("res/platform_tiles.png");
        assert (inImgPlatformTiles != null);
        InputStream inImgTopViewTiles = TiledLayerDialog.class.getResourceAsStream("res/topview_tiles.png");
        assert (inImgTopViewTiles != null);
        Project p = MidpProjectSupport.getProjectForDocument((DesignDocument)this.gameDesign.getDesignDocument());
        SourceGroup sg = MidpProjectSupport.getSourceGroup((Project)p);
        FileObject foSrc = sg.getRootFolder();
        OutputStream topViewOut = null;
        OutputStream platformOut = null;
        try {
            FileObject foPlatform = FileUtil.createData((FileObject)foSrc, (String)"platform_tiles.png");
            FileObject foTop = FileUtil.createData((FileObject)foSrc, (String)"topview_tiles.png");
            platformOut = foPlatform.getOutputStream();
            FileUtil.copy((InputStream)inImgPlatformTiles, (OutputStream)platformOut);
            topViewOut = foTop.getOutputStream();
            FileUtil.copy((InputStream)inImgTopViewTiles, (OutputStream)topViewOut);
        }
        finally {
            try {
                if (platformOut != null) {
                    platformOut.close();
                }
                if (topViewOut != null) {
                    topViewOut.close();
                }
            }
            catch (Exception ex) {}
        }
        this.listImageFileName.setModel(this.getImageListModel());
        this.handleImageStateChange();
    }

    private void handleOKButton() {
        String name = this.fieldLayerName.getText();
        int tileWidth = this.tileWidths.get(this.sliderWidth.getValue());
        int tileHeight = this.tileHeigths.get(this.sliderHeight.getValue());
        Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
        URL imageURL = null;
        String relativeResourcePath = null;
        try {
            if (entry == null || entry.getKey() == null || ((FileObject)entry.getKey()).getURL() == null) {
                Debug.warning((Object[])new Object[]{"imageURL is null"});
            } else {
                imageURL = ((FileObject)entry.getKey()).getURL();
                relativeResourcePath = (String)entry.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imageURL == null || relativeResourcePath == null) {
            return;
        }
        ImageResource imgRes = this.gameDesign.getImageResource(imageURL, relativeResourcePath);
        if (this.scene != null) {
            this.scene.createTiledLayer(name, imgRes, 20, 20, tileWidth, tileHeight);
        } else {
            this.gameDesign.createTiledLayer(name, imgRes, 20, 20, tileWidth, tileHeight);
        }
    }

    private class ImageListListener
    implements ListSelectionListener {
        private ImageListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TiledLayerDialog.this.handleImageStateChange();
        }
    }

    private class LayerFieldListener
    implements DocumentListener,
    FocusListener {
        private LayerFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleContentChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleContentChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleContentChange();
        }

        private void handleContentChange() {
            String err = TiledLayerDialog.this.getFieldLayerNameError();
            if (err == null) {
                err = TiledLayerDialog.this.getFieldImageFileNameError();
            }
            TiledLayerDialog.this.labelError.setText(err);
            if (err == null) {
                TiledLayerDialog.this.setOKButtonEnabled(true);
            } else {
                TiledLayerDialog.this.setOKButtonEnabled(false);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.handleContentChange();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int tileWidth = (Integer)TiledLayerDialog.this.tileWidths.get(TiledLayerDialog.this.sliderWidth.getValue());
            int tileHeight = (Integer)TiledLayerDialog.this.tileHeigths.get(TiledLayerDialog.this.sliderHeight.getValue());
            if (e.getSource() == TiledLayerDialog.this.sliderHeight) {
                TiledLayerDialog.this.imagePreview.setTileHeight(tileHeight);
                TiledLayerDialog.this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object)tileHeight));
            } else if (e.getSource() == TiledLayerDialog.this.sliderWidth) {
                TiledLayerDialog.this.imagePreview.setTileWidth(tileWidth);
                TiledLayerDialog.this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object)tileWidth));
            }
        }
    }
}

