/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.grid;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.game.editor.common.TileCellRenderer;
import org.netbeans.modules.vmd.game.editor.grid.ResourceImageListModel;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileTransferable;

class ResourceImageList
extends JList {
    public static final boolean DEBUG = false;
    private int padX = 4;
    private int padY = 4;

    public ResourceImageList() {
        this.setModel(new ResourceImageListModel());
        this.setCellRenderer(new TileCellRenderer(this.padX, this.padY));
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.addListSelectionListener(new ResourceImageListSelectionListener());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                int index = ResourceImageList.this.getSelectedIndex();
                if (index != -1) {
                    StaticTile tile = (StaticTile)ResourceImageList.this.getModel().getElementAt(index);
                    tile.getImageResource().getGameDesign().getMainView().requestPreview(tile);
                    tile.getImageResource().getGameDesign().getMainView().paintTileChanged(tile);
                }
            }
        });
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dgr = dragSource.createDefaultDragGestureRecognizer(this, 1, new DGL());
    }

    public void setImageResource(ImageResource imageResource, int tileWidth, int tileHeight, boolean zeroBasedIndex) {
        ((ResourceImageListModel)this.getModel()).update(imageResource, tileWidth, tileHeight, zeroBasedIndex);
    }

    private void hiliteTileAtPoint(Point point) {
        int hilite = this.locationToIndex(point);
        this.setSelectedIndex(hilite);
    }

    public Tile getSelectedTile() {
        int selection = this.getSelectedIndex();
        return (Tile)this.getModel().getElementAt(selection);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    private class ResourceImageListSelectionListener
    implements ListSelectionListener {
        private ResourceImageListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = ResourceImageList.this.getSelectedIndex();
            this.handleTileSelection(index);
        }

        private void handleTileSelection(int index) {
            StaticTile tile = (StaticTile)ResourceImageList.this.getModel().getElementAt(index);
            if (tile != null) {
                tile.getImageResource().getGameDesign().getMainView().requestPreview(tile);
                tile.getImageResource().getGameDesign().getMainView().paintTileChanged(tile);
            } else {
                System.out.println("WARNING: selected tile " + index + " is NULL");
            }
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point dragOrigin = dge.getDragOrigin();
            TileTransferable payload = new TileTransferable();
            if (ResourceImageList.this.getSelectedValues().length == 0) {
                int index = ResourceImageList.this.locationToIndex(dragOrigin);
                Tile tile = (Tile)ResourceImageList.this.getModel().getElementAt(index);
                payload.getTiles().add(tile);
                ResourceImageList.this.hiliteTileAtPoint(dragOrigin);
            } else {
                Object[] values = ResourceImageList.this.getSelectedValues();
                for (int i = 0; i < values.length; ++i) {
                    payload.getTiles().add((Tile)values[i]);
                }
            }
            dge.startDrag(null, payload, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            super.dragDropEnd(dsde);
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

