/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.grid;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.vmd.game.editor.grid.ResourceImageList;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.openide.util.NbBundle;

public class ResourceImageEditor
extends JPanel {
    private ResourceImageList resourceComponent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel panelResourceList;
    private JTextField textFieldImage;
    private JTextField textFieldNumTiles;
    private JTextField textFieldSize;

    public ResourceImageEditor() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.accessible.description"));
        this.textFieldImage.setBackground(this.textFieldImage.getParent().getBackground());
        this.textFieldNumTiles.setBackground(this.textFieldNumTiles.getParent().getBackground());
        this.textFieldSize.setBackground(this.textFieldSize.getParent().getBackground());
        this.resourceComponent = new ResourceImageList();
        this.panelResourceList.add(new JScrollPane(this.resourceComponent));
    }

    public void setImageResourceInfo(Editable.ImageResourceInfo imageResourceInfo) {
        ImageResource imageResource = imageResourceInfo.getImageResource();
        int tileWidth = imageResourceInfo.getTileWidth();
        int tileHeight = imageResourceInfo.getTileHeight();
        boolean zeroBasedIndex = imageResourceInfo.isZeroBasedIndex();
        this.textFieldImage.setText(imageResource.getRelativeResourcePath());
        this.textFieldNumTiles.setText(Integer.toString(imageResource.getStaticTileCount(tileWidth, tileHeight)));
        this.textFieldSize.setText(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.tileSize.txt", (Object)tileWidth, (Object)tileHeight));
        this.resourceComponent.setImageResource(imageResource, tileWidth, tileHeight, zeroBasedIndex);
        this.resourceComponent.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textFieldImage = new JTextField();
        this.jLabel2 = new JLabel();
        this.textFieldNumTiles = new JTextField();
        this.jLabel3 = new JLabel();
        this.textFieldSize = new JTextField();
        this.panelResourceList = new JPanel();
        this.jLabel1.setLabelFor(this.textFieldImage);
        this.jLabel1.setText(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.labelImage.txt"));
        this.textFieldImage.setEditable(false);
        this.textFieldImage.setBorder(null);
        this.jLabel2.setLabelFor(this.textFieldNumTiles);
        this.jLabel2.setText(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.labelCount.txt"));
        this.textFieldNumTiles.setEditable(false);
        this.textFieldNumTiles.setBorder(null);
        this.jLabel3.setLabelFor(this.textFieldSize);
        this.jLabel3.setText(NbBundle.getMessage(ResourceImageEditor.class, (String)"ResourceImageEditor.tileSizeLbl.txt"));
        this.textFieldSize.setEditable(false);
        this.textFieldSize.setBorder(null);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldImage, -1, 254, Short.MAX_VALUE).addGap(24, 24, 24).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldNumTiles, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldSize, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldSize, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.textFieldImage, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.textFieldNumTiles, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING));
        this.panelResourceList.setBackground(new Color(255, 255, 255));
        this.panelResourceList.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.panelResourceList, -1, 538, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelResourceList, -1, 142, Short.MAX_VALUE)));
    }
}

