/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.touch.component.application;

import java.io.IOException;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.touch.component.application.Application;

public class ApplicationRenderer
extends CoreRenderer {
    public void encodeBegin(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Application application = (Application)component;
        String themePath = "touch/themes/" + application.getTheme() + "/theme.min.css";
        writer.startElement("html", null);
        writer.startElement("head", null);
        this.renderTheme(fc, themePath);
        ListIterator iter = fc.getViewRoot().getComponentResources(fc, "head").listIterator();
        while (iter.hasNext()) {
            UIComponent resource = (UIComponent)iter.next();
            resource.encodeAll(fc);
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("TouchFaces = new PrimeFaces.touch.Application({");
        if (application.getIcon() != null) {
            writer.write("icon:'" + this.getResourceURL(fc, application.getIcon()) + "'");
        }
        writer.write("});");
        writer.endElement("script");
        UIComponent meta = application.getFacet("meta");
        if (meta != null) {
            this.renderChild(fc, meta);
        }
        writer.endElement("head");
        writer.startElement("body", null);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        writer.endElement("body");
        writer.endElement("html");
    }

    protected void renderTheme(FacesContext fc, String cssPath) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("href", (Object)this.getResourceRequestPath(fc, cssPath), null);
        writer.endElement("link");
    }
}

