/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;
import org.primefaces.model.map.Overlay;
import org.primefaces.model.map.Polygon;
import org.primefaces.model.map.Polyline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapModel
implements MapModel,
Serializable {
    private List<Marker> markers = new ArrayList<Marker>();
    private List<Polyline> polylines = new ArrayList<Polyline>();
    private List<Polygon> polygons = new ArrayList<Polygon>();
    private static final String MARKER_ID_PREFIX = "marker";
    private static final String POLYLINE_ID_PREFIX = "polyline_";
    private static final String POLYGON_ID_PREFIX = "polygon_";

    @Override
    public List<Marker> getMarkers() {
        return this.markers;
    }

    @Override
    public List<Polyline> getPolylines() {
        return this.polylines;
    }

    @Override
    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (overlay instanceof Marker) {
            overlay.setId(MARKER_ID_PREFIX + UUID.randomUUID().toString());
            this.markers.add((Marker)overlay);
        } else if (overlay instanceof Polyline) {
            overlay.setId(POLYLINE_ID_PREFIX + UUID.randomUUID().toString());
            this.polylines.add((Polyline)overlay);
        } else if (overlay instanceof Polygon) {
            overlay.setId(POLYGON_ID_PREFIX + UUID.randomUUID().toString());
            this.polygons.add((Polygon)overlay);
        }
    }

    @Override
    public Overlay findOverlay(String id) {
        List<Overlay> list = null;
        if (id.startsWith(MARKER_ID_PREFIX)) {
            list = this.markers;
        } else if (id.startsWith(POLYLINE_ID_PREFIX)) {
            list = this.polylines;
        } else if (id.startsWith(POLYGON_ID_PREFIX)) {
            list = this.polygons;
        }
        for (Overlay overlay : list) {
            if (!overlay.getId().equals(id)) continue;
            return overlay;
        }
        return null;
    }
}

