/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputmask;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputmask.InputMask;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputMaskRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputMask inputMask = (InputMask)component;
        if (inputMask.isDisabled() || inputMask.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputMask);
        String clientId = inputMask.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            inputMask.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputMask inputMask = (InputMask)component;
        this.encodeMarkup(context, inputMask);
        this.encodeScript(context, inputMask);
    }

    protected void encodeScript(FacesContext context, InputMask inputMask) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputMask.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(inputMask.resolveWidgetVar() + " = new PrimeFaces.widget.InputMask('" + clientId + "', {");
        writer.write("mask:'" + inputMask.getMask() + "'");
        if (inputMask.getPlaceHolder() != null) {
            writer.write(",placeholder:'" + inputMask.getPlaceHolder() + "'");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputMask);
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, InputMask inputMask) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputMask.getClientId(context);
        String styleClass = inputMask.getStyleClass();
        styleClass = styleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + styleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)inputMask);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)inputMask, HTML.INPUT_TEXT_ATTRS);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        InputMask inputMask = (InputMask)component;
        String value = (String)submittedValue;
        Converter converter = inputMask.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputMask, value);
        }
        Class valueType = inputMask.getValueExpression("value").getType(context.getELContext());
        Converter converterForType = context.getApplication().createConverter(valueType);
        if (converterForType != null) {
            return converterForType.getAsObject(context, (UIComponent)inputMask, value);
        }
        return value;
    }
}

