/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
extends Exporter {
    @Override
    public void export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        ServletOutputStream os = response.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, encodingType);
        PrintWriter writer = new PrintWriter(osw);
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        this.addColumnHeaders(writer, columns);
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : table.getRowCount();
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            this.addColumnValues(writer, columns);
            writer.write("\n");
        }
        table.setRowIndex(-1);
        response.setContentType("text/csv");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".csv");
        writer.flush();
        writer.close();
        response.getOutputStream().flush();
    }

    private void addColumnValues(PrintWriter writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn column = iterator.next();
            if (!column.isRendered()) continue;
            this.addColumnValue(writer, column.getChildren());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
    }

    private void addColumnHeaders(PrintWriter writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn column = iterator.next();
            if (!column.isRendered()) continue;
            this.addColumnValue(writer, column.getHeader());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n");
    }

    private void addColumnValue(PrintWriter writer, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        writer.write("\"" + value + "\"");
    }

    private void addColumnValue(PrintWriter writer, List<UIComponent> components) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            builder.append(value);
        }
        writer.write("\"" + builder.toString() + "\"");
    }
}

