/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.Cell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataHelper {
    DataHelper() {
    }

    void decodePageRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String firstParam = (String)params.get(clientId + "_first");
        String rowsParam = (String)params.get(clientId + "_rows");
        String pageParam = (String)params.get(clientId + "_page");
        table.setFirst(Integer.valueOf(firstParam));
        table.setRows(Integer.valueOf(rowsParam));
        table.setPage(Integer.valueOf(pageParam));
    }

    void decodeSortRequest(FacesContext context, DataTable table) {
        Column sortColumn;
        boolean asc;
        block8: {
            String clientId = table.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String sortKey = (String)params.get(clientId + "_sortKey");
            asc = Boolean.valueOf((String)params.get(clientId + "_sortDir"));
            sortColumn = null;
            ColumnGroup group = table.getColumnGroup("header");
            if (group != null) {
                for (UIComponent child : group.getChildren()) {
                    Row headerRow = (Row)child;
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        Column column = (Column)headerRowChild;
                        if (!column.getClientId(context).equals(sortKey)) continue;
                        sortColumn = column;
                        break block8;
                    }
                }
            } else {
                for (Column column : table.getColumns()) {
                    if (!column.getClientId(context).equals(sortKey)) continue;
                    sortColumn = column;
                    break;
                }
            }
        }
        table.setFirst(0);
        table.setPage(1);
        if (table.isLazy()) {
            table.setSortField(this.resolveField(sortColumn.getValueExpression("sortBy")));
            table.setSortOrder(asc);
        } else {
            List list = (List)table.getValue();
            Collections.sort(list, new BeanPropertyComparator(sortColumn, table.getVar(), asc));
            if (table.isFiltered()) {
                table.setValue(list);
            }
        }
    }

    void decodeFilterRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        table.setFirst(0);
        table.setPage(1);
        if (table.isLazy()) {
            HashMap<String, String> filters = new HashMap<String, String>();
            Map<String, Column> filterMap = table.getFilterMap();
            for (String filterName : filterMap.keySet()) {
                Column column = filterMap.get(filterName);
                String filterValue = ((String)params.get(filterName)).toLowerCase();
                if (this.isValueBlank(filterValue)) continue;
                String filterField = this.resolveField(column.getValueExpression("filterBy"));
                filters.put(filterField, filterValue);
            }
            table.setFilters(filters);
            if (table.isPaginator()) {
                RequestContext.getCurrentInstance().addCallbackParam("totalRecords", table.getRowCount());
            }
        } else {
            boolean hasGlobalFilter;
            Map<String, Column> filterMap = table.getFilterMap();
            ArrayList<Object> filteredData = new ArrayList<Object>();
            table.setValue(null);
            String globalFilter = (String)params.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter");
            boolean bl = hasGlobalFilter = !this.isValueBlank(globalFilter);
            if (hasGlobalFilter) {
                globalFilter = globalFilter.toLowerCase();
            }
            for (int i = 0; i < table.getRowCount(); ++i) {
                table.setRowIndex(i);
                boolean localMatch = true;
                boolean globalMatch = false;
                for (String filterName : filterMap.keySet()) {
                    Column column = filterMap.get(filterName);
                    String columnFilter = ((String)params.get(filterName)).toLowerCase();
                    String columnValue = String.valueOf(column.getValueExpression("filterBy").getValue(context.getELContext()));
                    if (hasGlobalFilter && !globalMatch && columnValue != null && columnValue.toLowerCase().contains(globalFilter)) {
                        globalMatch = true;
                    }
                    if (this.isValueBlank(columnFilter)) {
                        localMatch = true;
                        continue;
                    }
                    if (columnValue != null && column.getFilterConstraint().applies(columnValue.toLowerCase(), columnFilter)) continue;
                    localMatch = false;
                    break;
                }
                boolean matches = localMatch;
                if (hasGlobalFilter) {
                    boolean bl2 = matches = localMatch && globalMatch;
                }
                if (!matches) continue;
                filteredData.add(table.getRowData());
            }
            table.setRowIndex(-1);
            table.setValue(filteredData);
            table.setFiltered(true);
            if (table.isPaginator()) {
                RequestContext.getCurrentInstance().addCallbackParam("totalRecords", filteredData.size());
            }
        }
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    void decodeSelection(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(table, selection);
        } else {
            this.decodeMultipleSelection(table, selection);
        }
        table.setRowIndex(-1);
        this.queueInstantSelectionEvent(context, table, clientId, params);
        table.setRowIndex(-1);
    }

    void queueInstantSelectionEvent(FacesContext context, DataTable table, String clientId, Map<String, String> params) {
        if (table.isInstantSelectionRequest(context)) {
            int selectedRowIndex = Integer.parseInt(params.get(clientId + "_instantSelectedRowIndex"));
            table.setRowIndex(selectedRowIndex);
            SelectEvent selectEvent = new SelectEvent((UIComponent)table, table.getRowData());
            selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(selectEvent);
        } else if (table.isInstantUnselectionRequest(context)) {
            int unselectedRowIndex = Integer.parseInt(params.get(clientId + "_instantUnselectedRowIndex"));
            table.setRowIndex(unselectedRowIndex);
            UnselectEvent unselectEvent = new UnselectEvent((UIComponent)table, table.getRowData());
            unselectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(unselectEvent);
        }
    }

    void decodeSingleSelection(DataTable table, String selection) {
        if (this.isValueBlank(selection)) {
            table.setSelection(null);
            table.setEmptySelected(true);
        } else if (table.isCellSelection()) {
            table.setSelection(this.buildCell(table, selection));
        } else {
            int last;
            int selectedRowIndex = Integer.parseInt(selection);
            int first = table.getFirst();
            int rows = table.getRows();
            int n = last = rows == 0 ? table.getRowCount() : rows;
            if (first <= selectedRowIndex && first + last > selectedRowIndex) {
                table.setRowIndex(selectedRowIndex);
                table.setSelection(table.getRowData());
            }
        }
    }

    void decodeMultipleSelection(DataTable table, String selection) {
        Class clazz = table.getValueExpression("selection").getType(FacesContext.getCurrentInstance().getELContext());
        if (this.isValueBlank(selection)) {
            Object data = Array.newInstance(clazz.getComponentType(), 0);
            table.setSelection(data);
        } else if (table.isCellSelection()) {
            String[] cellInfos = selection.split(",");
            Cell[] cells = new Cell[cellInfos.length];
            for (int i = 0; i < cellInfos.length; ++i) {
                cells[i] = this.buildCell(table, cellInfos[i]);
                table.setRowIndex(-1);
            }
            table.setSelection(cells);
        } else {
            String[] rowSelectValues = selection.split(",");
            Object data = Array.newInstance(clazz.getComponentType(), rowSelectValues.length);
            for (int i = 0; i < rowSelectValues.length; ++i) {
                table.setRowIndex(Integer.parseInt(rowSelectValues[i]));
                Array.set(data, i, table.getRowData());
            }
            table.setSelection(data);
        }
    }

    String resolveField(ValueExpression expression) {
        String expressionString = expression.getExpressionString();
        expressionString = expressionString.substring(2, expressionString.length() - 1);
        return expressionString.substring(expressionString.indexOf(".") + 1);
    }

    Cell buildCell(DataTable dataTable, String value) {
        String[] cellInfo = value.split("#");
        int rowIndex = Integer.parseInt(cellInfo[0]);
        UIColumn column = dataTable.getColumns().get(Integer.parseInt(cellInfo[1]));
        dataTable.setRowIndex(rowIndex);
        Object rowData = dataTable.getRowData();
        Object cellValue = null;
        UIComponent columnChild = (UIComponent)column.getChildren().get(0);
        if (columnChild instanceof ValueHolder) {
            cellValue = ((ValueHolder)columnChild).getValue();
        }
        return new Cell(rowData, column.getId(), cellValue);
    }
}

