/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.component.captcha.Verification;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={})
public class Captcha
extends UIInput {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Captcha";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.CaptchaRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String PUBLIC_KEY = "primefaces.PUBLIC_CAPTCHA_KEY";
    public static final String PRIVATE_KEY = "primefaces.PRIVATE_CAPTCHA_KEY";
    public static final String INVALID_MESSAGE_ID = "primefaces.captcha.INVALID";
    public static final String OLD_PRIVATE_KEY = "org.primefaces.component.captcha.PRIVATE_KEY";
    private static final Logger logger = Logger.getLogger(Captcha.class.getName());

    public Captcha() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPublicKey() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.publicKey), null);
    }

    public void setPublicKey(String _publicKey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.publicKey), (Object)_publicKey);
        this.handleAttribute("publicKey", _publicKey);
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), (Object)"red");
    }

    public void setTheme(String _theme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.theme), (Object)_theme);
        this.handleAttribute("theme", _theme);
    }

    public String getLanguage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.language), (Object)"en");
    }

    public void setLanguage(String _language) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.language), (Object)_language);
        this.handleAttribute("language", _language);
    }

    public int getTabindex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), (Object)0);
    }

    public void setTabindex(int _tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)_tabindex);
        this.handleAttribute("tabindex", _tabindex);
    }

    public String getLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.label), null);
    }

    public void setLabel(String _label) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.label), (Object)_label);
        this.handleAttribute("label", _label);
    }

    public boolean isSecure() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.secure), (Object)false);
    }

    public void setSecure(boolean _secure) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.secure), (Object)_secure);
        this.handleAttribute("secure", _secure);
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid()) {
            String result = null;
            Verification verification = (Verification)value;
            try {
                URL url = new URL("http://api-verify.recaptcha.net/verify");
                URLConnection conn = url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String postBody = this.createPostParameters(context, verification);
                OutputStream out = conn.getOutputStream();
                out.write(postBody.getBytes());
                out.flush();
                out.close();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                result = rd.readLine();
                rd.close();
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            boolean isValid = Boolean.valueOf(result);
            if (!isValid) {
                this.setValid(false);
                Object[] params = new Object[]{MessageFactory.getLabel(context, (UIComponent)this), verification.getAnswer()};
                context.addMessage(this.getClientId(context), MessageFactory.getMessage(INVALID_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params));
            }
        }
    }

    private String createPostParameters(FacesContext facesContext, Verification verification) throws UnsupportedEncodingException {
        String challenge = verification.getChallenge();
        String answer = verification.getAnswer();
        String remoteAddress = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getRemoteAddr();
        String privateKey = null;
        String oldPrivateKey = facesContext.getExternalContext().getInitParameter(OLD_PRIVATE_KEY);
        String newPrivateKey = facesContext.getExternalContext().getInitParameter(PRIVATE_KEY);
        if (oldPrivateKey != null) {
            logger.warning("PrivateKey definition on captcha is deprecated, use primefaces.PRIVATE_CAPTCHA_KEY context-param instead");
            privateKey = oldPrivateKey;
        } else {
            privateKey = newPrivateKey;
        }
        if (privateKey == null) {
            throw new FacesException("Cannot find private key for catpcha, use primefaces.PRIVATE_CAPTCHA_KEY context-param to define one");
        }
        StringBuilder postParams = new StringBuilder();
        postParams.append("privatekey=").append(URLEncoder.encode(privateKey, "UTF-8"));
        postParams.append("&remoteip=").append(URLEncoder.encode(remoteAddress, "UTF-8"));
        postParams.append("&challenge=").append(URLEncoder.encode(challenge, "UTF-8"));
        postParams.append("&response=").append(URLEncoder.encode(answer, "UTF-8"));
        return postParams.toString();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = ((Object)((Object)this)).getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        publicKey,
        theme,
        language,
        tabindex,
        label,
        secure;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

