/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.button;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.button.Button;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Button button = (Button)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    public void encodeMarkup(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("type", (Object)"button", null);
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        writer.writeAttribute("onclick", (Object)this.buildOnclick(context, button), null);
        if (button.getValue() != null) {
            writer.write(button.getValue().toString());
        } else if (button.getImage() != null) {
            writer.write("ui-button");
        }
        writer.endElement("button");
    }

    public void encodeScript(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        boolean hasValue = button.getValue() != null;
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(button.resolveWidgetVar() + " = new PrimeFaces.widget.Button('" + clientId + "', {");
        if (button.getImage() != null) {
            writer.write("text:" + hasValue);
            writer.write(",icons:{");
            writer.write("primary:'" + button.getImage() + "'");
            writer.write("}");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected String buildOnclick(FacesContext context, Button button) {
        NavigationCase navCase = this.findNavigationCase(context, button);
        String toViewId = navCase.getToViewId(context);
        boolean isIncludeViewParams = this.isIncludeViewParams(button, navCase);
        Map<String, List<String>> params = this.getParams(navCase, button);
        String bookmarkableURL = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, params, isIncludeViewParams);
        if (button.getFragment() != null) {
            bookmarkableURL = bookmarkableURL + "#" + button.getFragment();
        }
        StringBuilder onclick = new StringBuilder();
        String userOnclick = button.getOnclick();
        if (userOnclick != null) {
            onclick.append(userOnclick).append(";");
        }
        onclick.append("window.location.href='").append(bookmarkableURL).append("';");
        return onclick.toString();
    }

    protected NavigationCase findNavigationCase(FacesContext context, Button button) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcome = button.getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        return navHandler.getNavigationCase(context, null, outcome);
    }

    protected Map<String, List<String>> getParams(NavigationCase navCase, Button button) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (UIComponent child : button.getChildren()) {
            UIParameter uiParam;
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            ArrayList<String> paramValues = (ArrayList<String>)params.get(uiParam.getName());
            if (paramValues == null) {
                paramValues = new ArrayList<String>();
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        Map navCaseParams = navCase.getParameters();
        if (navCaseParams != null && !navCaseParams.isEmpty()) {
            for (Map.Entry entry : navCaseParams.entrySet()) {
                String key = (String)entry.getKey();
                if (params.containsKey(key)) continue;
                params.put(key, (List<String>)entry.getValue());
            }
        }
        return params;
    }

    protected boolean isIncludeViewParams(Button button, NavigationCase navCase) {
        return button.isIncludeViewParams() || navCase.isIncludeViewParams();
    }
}

