/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.behavior.ajax;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.BehaviorEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core/core.js")})
@FacesBehavior(value="org.primefaces.component.AjaxBehavior")
public class AjaxBehavior
extends ClientBehaviorBase {
    private String update;
    private String process;
    private boolean global = true;
    private boolean async = false;
    private String oncomplete;
    private String onerror;
    private String onsuccess;
    private String onstart;
    private MethodExpression listener;
    private boolean immediate = false;
    private boolean disabled = false;
    private boolean immediateSet = false;
    private static final Set<ClientBehaviorHint> HINTS = Collections.unmodifiableSet(EnumSet.of(ClientBehaviorHint.SUBMITTING));
    private Map<String, ValueExpression> bindings;
    @Deprecated
    private MethodExpression action;
    @Deprecated
    private MethodExpression actionListener;

    public String getRendererType() {
        return "org.primefaces.component.AjaxBehaviorRenderer";
    }

    public Set<ClientBehaviorHint> getHints() {
        return HINTS;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public String getOncomplete() {
        return this.oncomplete;
    }

    public void setOncomplete(String oncomplete) {
        this.oncomplete = oncomplete;
    }

    public String getOnstart() {
        return this.onstart;
    }

    public void setOnstart(String onstart) {
        this.onstart = onstart;
    }

    public String getOnsuccess() {
        return this.onsuccess;
    }

    public void setOnsuccess(String onsuccess) {
        this.onsuccess = onsuccess;
    }

    public String getOnerror() {
        return this.onerror;
    }

    public void setOnerror(String onerror) {
        this.onerror = onerror;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public MethodExpression getListener() {
        return this.listener;
    }

    public void setListener(MethodExpression listener) {
        this.listener = listener;
    }

    public MethodExpression getAction() {
        return this.action;
    }

    public void setAction(MethodExpression action) {
        this.action = action;
    }

    public MethodExpression getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(MethodExpression actionListener) {
        this.actionListener = actionListener;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
        this.immediateSet = true;
    }

    public boolean isImmediateSet() {
        return this.immediateSet;
    }

    public void broadcast(BehaviorEvent event) throws AbortProcessingException {
        ELContext eLContext = FacesContext.getCurrentInstance().getELContext();
        if (this.listener != null) {
            try {
                this.listener.invoke(eLContext, new Object[0]);
            }
            catch (MethodNotFoundException mnfe) {
                this.listener.invoke(eLContext, new Object[]{event});
            }
        } else if (this.action != null) {
            this.action.invoke(eLContext, new Object[0]);
        } else if (this.actionListener != null) {
            try {
                this.actionListener.invoke(eLContext, new Object[]{new ActionEvent(event.getComponent())});
            }
            catch (IllegalArgumentException iae) {
                this.actionListener.invoke(eLContext, new Object[0]);
            }
        }
    }
}

