/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.wizards;

import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.ui.options.SymfonyOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NewProjectConfigurationPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -1785087654312318594L;
    private static final String APP_FRONTEND = "frontend";
    private static final String APP_BACKEND = "backend";
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("\\S+");
    private static final Pattern SECRET_PATTERN = Pattern.compile("\\bUniqueSecret\\b");
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JCheckBox backendCheckBox;
    private JLabel backendParamsLabel;
    private JTextField backendParamsTextField;
    private JCheckBox frontendCheckBox;
    private JLabel frontendParamsLabel;
    private JTextField frontendParamsTextField;
    private JLabel generateAppsLabel;
    private JLabel generateProjectLabel;
    private JLabel infoLabel;
    private JLabel optionsLabel;
    private JCheckBox otherCheckBox;
    private JTextField otherNameTextField;
    private JLabel otherParamsLabel;
    private JTextField otherParamsTextField;
    private JLabel projectParamsLabel;
    private JTextField projectParamsTextField;

    public NewProjectConfigurationPanel() {
        this.initComponents();
        this.optionsLabel.setMaximumSize(this.optionsLabel.getPreferredSize());
        this.projectParamsTextField.setText(this.getOptions().getDefaultParamsForProject());
        String defaultParamsForApps = this.getOptions().getDefaultParamsForApps();
        this.frontendParamsTextField.setText(defaultParamsForApps);
        this.backendParamsTextField.setText(defaultParamsForApps);
        this.otherParamsTextField.setText(defaultParamsForApps);
        this.initApp(this.frontendCheckBox, this.frontendParamsLabel, this.frontendParamsTextField, null);
        this.initApp(this.backendCheckBox, this.backendParamsLabel, this.backendParamsTextField, null);
        this.initApp(this.otherCheckBox, this.otherParamsLabel, this.otherParamsTextField, this.otherNameTextField);
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.frontendCheckBox.addItemListener(defaultItemListener);
        this.backendCheckBox.addItemListener(defaultItemListener);
        this.otherCheckBox.addItemListener(defaultItemListener);
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.frontendParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.backendParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.otherNameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.otherParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.generateProjectLabel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewProjectConfigurationPanel.this.enableOptionsLabel();
            }
        });
        this.enableOptionsLabel();
    }

    @Override
    public void addNotify() {
        SymfonyOptions.getInstance().addChangeListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        SymfonyOptions.getInstance().removeChangeListener(this);
        super.removeNotify();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String[] getProjectParams() {
        return Utilities.parseParameters((String)this.projectParamsTextField.getText().trim());
    }

    public List<Pair<String, String[]>> getApps() {
        LinkedList<Pair<String, String[]>> apps = new LinkedList<Pair<String, String[]>>();
        if (this.frontendCheckBox.isSelected()) {
            apps.add(Pair.of((Object)APP_FRONTEND, (Object)Utilities.parseParameters((String)this.frontendParamsTextField.getText().trim())));
        }
        if (this.backendCheckBox.isSelected()) {
            apps.add((Pair<String, String[]>)Pair.of((Object)APP_BACKEND, (Object)Utilities.parseParameters((String)this.backendParamsTextField.getText().trim())));
        }
        if (this.otherCheckBox.isSelected()) {
            apps.add((Pair<String, String[]>)Pair.of((Object)this.getOtherAppName(), (Object)Utilities.parseParameters((String)this.otherParamsTextField.getText().trim())));
        }
        return apps;
    }

    public String getErrorMessage() {
        if (this.otherCheckBox.isSelected()) {
            String otherAppName = this.getOtherAppName();
            if (!StringUtils.hasText((String)otherAppName)) {
                return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_NoAppName");
            }
            if (!APP_NAME_PATTERN.matcher(otherAppName).matches()) {
                return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_InvalidAppName", (Object)otherAppName);
            }
        }
        return null;
    }

    public String getWarningMessage() {
        String otherAppName;
        String warn = null;
        if (this.frontendCheckBox.isSelected() && (warn = this.validateAppParams(APP_FRONTEND, this.frontendParamsTextField)) != null) {
            return warn;
        }
        if (this.backendCheckBox.isSelected() && (warn = this.validateAppParams(APP_BACKEND, this.backendParamsTextField)) != null) {
            return warn;
        }
        if (this.otherCheckBox.isSelected() && (warn = this.validateAppParams(otherAppName = this.getOtherAppName(), this.otherParamsTextField)) != null) {
            return warn;
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void visibleApp(boolean visible, JLabel paramsLabel, JTextField paramsTextField, JTextField nameTextField) {
        paramsLabel.setVisible(visible);
        paramsTextField.setVisible(visible);
        if (nameTextField != null) {
            nameTextField.setVisible(visible);
        }
    }

    void enableOptionsLabel() {
        this.optionsLabel.setVisible(this.generateProjectLabel.isEnabled());
    }

    private String getOtherAppName() {
        return this.otherNameTextField.getText().trim();
    }

    private String validateAppParams(String appName, JTextField paramsTextField) {
        if (SECRET_PATTERN.matcher(paramsTextField.getText()).find()) {
            return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_DefaultParamUsed", (Object)"UniqueSecret", (Object)appName);
        }
        return null;
    }

    private void initApp(JCheckBox nameCheckBox, final JLabel paramsLabel, final JTextField paramsTextField, final JTextField nameTextField) {
        nameCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewProjectConfigurationPanel.this.visibleApp(e.getStateChange() == 1, paramsLabel, paramsTextField, nameTextField);
            }
        });
        this.visibleApp(nameCheckBox.isSelected(), paramsLabel, paramsTextField, nameTextField);
    }

    private SymfonyOptions getOptions() {
        return SymfonyOptions.getInstance();
    }

    private void initComponents() {
        this.generateProjectLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.projectParamsLabel = new JLabel();
        this.projectParamsTextField = new JTextField();
        this.generateAppsLabel = new JLabel();
        this.frontendCheckBox = new JCheckBox();
        this.frontendParamsLabel = new JLabel();
        this.frontendParamsTextField = new JTextField();
        this.backendCheckBox = new JCheckBox();
        this.backendParamsLabel = new JLabel();
        this.backendParamsTextField = new JTextField();
        this.otherCheckBox = new JCheckBox();
        this.otherNameTextField = new JTextField();
        this.otherParamsLabel = new JLabel();
        this.otherParamsTextField = new JTextField();
        this.infoLabel = new JLabel();
        this.setFocusTraversalPolicy(null);
        this.generateProjectLabel.setLabelFor(this.frontendCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.generateProjectLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.text"));
        this.optionsLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.text"));
        this.optionsLabel.setToolTipText(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.toolTipText"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewProjectConfigurationPanel.this.optionsLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NewProjectConfigurationPanel.this.optionsLabelMousePressed(evt);
            }
        });
        this.projectParamsLabel.setLabelFor(this.projectParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.text"));
        this.generateAppsLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.generateAppsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.text"));
        this.frontendCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.frontendCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.text"));
        this.frontendParamsLabel.setLabelFor(this.frontendParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.frontendParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.backendCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.text"));
        this.backendParamsLabel.setLabelFor(this.backendParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.backendParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.otherCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.text"));
        this.otherParamsLabel.setLabelFor(this.otherParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.otherParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.text"));
        this.infoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.backendParamsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backendParamsTextField, -1, 359, Short.MAX_VALUE)).addComponent(this.backendCheckBox)).addGap(0, 0, 0)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.otherParamsLabel)).addComponent(this.otherCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.otherParamsTextField, -1, 359, Short.MAX_VALUE).addComponent(this.otherNameTextField, -1, 359, Short.MAX_VALUE)).addGap(0, 0, 0)).addGroup(layout.createSequentialGroup().addComponent(this.generateProjectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 291, Short.MAX_VALUE).addComponent(this.optionsLabel, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.frontendParamsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frontendParamsTextField, -1, 359, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.frontendCheckBox).addContainerGap(393, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.projectParamsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectParamsTextField, -1, 376, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.generateAppsLabel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateProjectLabel).addComponent(this.optionsLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectParamsTextField, -2, -1, -2).addComponent(this.projectParamsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generateAppsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frontendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.frontendParamsLabel).addComponent(this.frontendParamsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backendParamsLabel).addComponent(this.backendParamsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.otherCheckBox).addComponent(this.otherNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.otherParamsLabel).addComponent(this.otherParamsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.infoLabel, -2, -1, -2)));
        this.generateProjectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.AccessibleContext.accessibleName"));
        this.generateProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.AccessibleContext.accessibleDescription"));
        this.optionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.AccessibleContext.accessibleName"));
        this.optionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.AccessibleContext.accessibleDescription"));
        this.projectParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.AccessibleContext.accessibleName"));
        this.projectParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.AccessibleContext.accessibleDescription"));
        this.projectParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsTextField.AccessibleContext.accessibleName"));
        this.projectParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsTextField.AccessibleContext.accessibleDescription"));
        this.generateAppsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.AccessibleContext.accessibleName"));
        this.generateAppsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.AccessibleContext.accessibleDescription"));
        this.frontendCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.AccessibleContext.accessibleName"));
        this.frontendCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.AccessibleContext.accessibleDescription"));
        this.frontendParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.AccessibleContext.accessibleName"));
        this.frontendParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.AccessibleContext.accessibleDescription"));
        this.frontendParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsTextField.AccessibleContext.accessibleName"));
        this.frontendParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsTextField.AccessibleContext.accessibleDescription"));
        this.backendCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.AccessibleContext.accessibleName"));
        this.backendCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.AccessibleContext.accessibleDescription"));
        this.backendParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.AccessibleContext.accessibleName"));
        this.backendParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.AccessibleContext.accessibleDescription"));
        this.backendParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsTextField.AccessibleContext.accessibleName"));
        this.backendParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsTextField.AccessibleContext.accessibleDescription"));
        this.otherCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.AccessibleContext.accessibleName"));
        this.otherCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.AccessibleContext.accessibleDescription"));
        this.otherNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherNameTextField.AccessibleContext.accessibleName"));
        this.otherNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherNameTextField.AccessibleContext.accessibleDescription"));
        this.otherParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.AccessibleContext.accessibleName"));
        this.otherParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.AccessibleContext.accessibleDescription"));
        this.otherParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsTextField.AccessibleContext.accessibleName"));
        this.otherParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsTextField.AccessibleContext.accessibleDescription"));
        this.infoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.AccessibleContext.accessibleName"));
        this.infoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        OptionsDisplayer.getDefault().open(SymfonyScript.getOptionsPath());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NewProjectConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            NewProjectConfigurationPanel.this.fireChange();
        }
    }
}

