/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FieldCustomizerPanel
extends JPanel {
    public static final String NAME = "name";
    public static final String RETURN_TYPE = "returnType";
    public static final String INTERFACES = "interfaces";
    private JLabel addToLocalLabel;
    private JLabel addToRemoteLabel;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JTextField errorTextField;
    private JCheckBox localGetterCheckBox;
    private JCheckBox localSetterCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox remoteGetterCheckBox;
    private JCheckBox remoteSetterCheckBox;
    private JLabel typeLabel;
    private JTextField typeTextField;

    public FieldCustomizerPanel(MethodModel.Variable element, String description, boolean localEnabled, boolean remoteEnabled, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {
        this.initComponents();
        this.descriptionTextField.setText(description);
        this.localGetterCheckBox.setEnabled(localEnabled);
        this.localSetterCheckBox.setEnabled(localEnabled);
        this.remoteGetterCheckBox.setEnabled(remoteEnabled);
        this.remoteSetterCheckBox.setEnabled(remoteEnabled);
        this.localGetterCheckBox.setSelected(localGetter && localEnabled);
        this.localSetterCheckBox.setSelected(localSetter && localEnabled);
        this.remoteGetterCheckBox.setSelected(remoteGetter && remoteEnabled);
        this.remoteSetterCheckBox.setSelected(remoteSetter && remoteEnabled);
        this.nameTextField.setText(element.getName());
        this.typeTextField.setText(element.getType());
        this.nameTextField.getDocument().addDocumentListener(new SimpleListener(NAME));
        this.typeTextField.getDocument().addDocumentListener(new SimpleListener(RETURN_TYPE));
        SimpleListener interfacesListener = new SimpleListener(INTERFACES);
        this.localGetterCheckBox.addActionListener(interfacesListener);
        this.localSetterCheckBox.addActionListener(interfacesListener);
        this.remoteGetterCheckBox.addActionListener(interfacesListener);
        this.remoteSetterCheckBox.addActionListener(interfacesListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int nameLength = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(nameLength);
        this.nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FieldCustomizerPanel.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.addToLocalLabel = new JLabel();
        this.localGetterCheckBox = new JCheckBox();
        this.localSetterCheckBox = new JCheckBox();
        this.addToRemoteLabel = new JLabel();
        this.remoteGetterCheckBox = new JCheckBox();
        this.remoteSetterCheckBox = new JCheckBox();
        this.typeTextField = new JTextField();
        this.errorTextField = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Name_"));
        this.nameTextField.setColumns(30);
        this.descriptionLabel.setLabelFor(this.descriptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Description"));
        this.typeLabel.setLabelFor(this.typeTextField);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Type"));
        Mnemonics.setLocalizedText((JLabel)this.addToLocalLabel, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"LBL_AddToLocalInterface"));
        Mnemonics.setLocalizedText((AbstractButton)this.localGetterCheckBox, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Getter_Local"));
        Mnemonics.setLocalizedText((AbstractButton)this.localSetterCheckBox, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Setter_Local"));
        Mnemonics.setLocalizedText((JLabel)this.addToRemoteLabel, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"LBL_AddToRemoteInterface"));
        Mnemonics.setLocalizedText((AbstractButton)this.remoteGetterCheckBox, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Getter_Remote"));
        Mnemonics.setLocalizedText((AbstractButton)this.remoteSetterCheckBox, (String)NbBundle.getMessage(FieldCustomizerPanel.class, (String)"CTL_Setter_Remote"));
        this.errorTextField.setEditable(false);
        this.errorTextField.setText(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"FieldCustomizerPanel.errorTextField.text"));
        this.errorTextField.setBorder(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorTextField, -1, 531, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.typeLabel)).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.nameLabel)).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField, -1, 431, Short.MAX_VALUE).addComponent(this.descriptionTextField, -1, 431, Short.MAX_VALUE).addComponent(this.typeTextField, -1, 431, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addToLocalLabel).addComponent(this.addToRemoteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localGetterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localSetterCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.remoteGetterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteSetterCheckBox))).addGap(190, 190, 190))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addComponent(this.descriptionTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localGetterCheckBox).addComponent(this.localSetterCheckBox).addComponent(this.addToLocalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addToRemoteLabel).addComponent(this.remoteGetterCheckBox).addComponent(this.remoteSetterCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Name_AD"));
        this.descriptionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Description_AD"));
        this.localGetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Getter_Local_AN"));
        this.localGetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Getter_Local_AD"));
        this.localSetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Setter_Local_AN"));
        this.localSetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Setter_Local_AD"));
        this.remoteGetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Getter_Remote_AN"));
        this.remoteGetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Getter_Remote_AD"));
        this.remoteSetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Setter_Remote_AN"));
        this.remoteSetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizerPanel.class, (String)"Setter_Remote_AD"));
    }

    public void setError(String message) {
        this.errorTextField.setText(message);
    }

    public String getMethodName() {
        return this.nameTextField.getText();
    }

    public String getReturnType() {
        return this.typeTextField.getText();
    }

    public String getDescription() {
        return this.descriptionTextField.getText();
    }

    public boolean isLocalGetter() {
        return this.localGetterCheckBox.isSelected();
    }

    public boolean isLocalSetter() {
        return this.localSetterCheckBox.isSelected();
    }

    public boolean isRemoteGetter() {
        return this.remoteGetterCheckBox.isSelected();
    }

    public boolean isRemoteSetter() {
        return this.remoteSetterCheckBox.isSelected();
    }

    private class SimpleListener
    implements DocumentListener,
    ActionListener {
        private final String propertyName;

        public SimpleListener(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.fire();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.fire();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fire();
        }

        private void fire() {
            FieldCustomizerPanel.this.firePropertyChange(this.propertyName, null, null);
        }
    }
}

