/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.macros.storage.ui.MacrosPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class MacrosPanelController
extends OptionsPanelController {
    private static final Map<Lookup, Reference<MacrosPanel>> PANELS = new WeakHashMap<Lookup, Reference<MacrosPanel>>();
    private MacrosPanel lastPanel = null;

    public void update() {
        MacrosModel model = this.lastPanel.getModel();
        if (!model.isLoaded()) {
            model.load();
        }
    }

    public void applyChanges() {
        this.lastPanel.save();
    }

    public void cancel() {
        this.lastPanel.getModel().load();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.lastPanel.getModel().isChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.editor.macros");
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getMacrosPanel(masterLookup);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.lastPanel.getModel().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.lastPanel.getModel().removePropertyChangeListener(l);
    }

    private MacrosPanel getMacrosPanel(Lookup masterLookup) {
        MacrosPanel panel;
        Reference<MacrosPanel> ref = PANELS.get(masterLookup);
        MacrosPanel macrosPanel = panel = ref == null ? null : ref.get();
        if (panel == null) {
            panel = new MacrosPanel(masterLookup);
            PANELS.put(masterLookup, new WeakReference<MacrosPanel>(panel));
        }
        this.lastPanel = panel;
        return panel;
    }
}

