/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InterfaceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;

public class JPDAClassTypeImpl
implements JPDAClassType {
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private JPDADebuggerImpl debugger;
    private ReferenceType classType;

    public JPDAClassTypeImpl(JPDADebuggerImpl debugger, ReferenceType classType) {
        this.debugger = debugger;
        this.classType = classType;
    }

    public ReferenceType getType() {
        return this.classType;
    }

    public String getName() {
        return this.classType.name();
    }

    public String getSourceName() throws AbsentInformationException {
        return this.classType.sourceName();
    }

    public ClassVariable classObject() {
        ClassObjectReference co;
        try {
            co = ReferenceTypeWrapper.classObject(this.classType);
        }
        catch (InternalExceptionWrapper ex) {
            co = null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            co = null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            co = null;
        }
        catch (UnsupportedOperationExceptionWrapper ex) {
            co = null;
        }
        return new ClassVariableImpl(this.debugger, co, "");
    }

    public ObjectVariable getClassLoader() {
        ClassLoaderReference cl;
        try {
            cl = ReferenceTypeWrapper.classLoader(this.classType);
        }
        catch (InternalExceptionWrapper ex) {
            cl = null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            cl = null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            cl = null;
        }
        return new AbstractObjectVariable(this.debugger, cl, "Loader " + this.getName());
    }

    public Super getSuperClass() {
        if (this.classType instanceof ClassType) {
            try {
                return new SuperVariable(this.debugger, null, ClassTypeWrapper.superclass((ClassType)this.classType), this.getName());
            }
            catch (InternalExceptionWrapper ex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return null;
            }
        }
        return null;
    }

    public List<JPDAClassType> getSubClasses() {
        List<ClassType> subclasses;
        if (this.classType instanceof ClassType && (subclasses = ClassTypeWrapper.subclasses0((ClassType)this.classType)).size() > 0) {
            ArrayList<JPDAClassTypeImpl> subClasses = new ArrayList<JPDAClassTypeImpl>(subclasses.size());
            for (ClassType subclass : subclasses) {
                subClasses.add(new JPDAClassTypeImpl(this.debugger, subclass));
            }
            return Collections.unmodifiableList(subClasses);
        }
        if (this.classType instanceof InterfaceType) {
            List<InterfaceType> subinterfaces = InterfaceTypeWrapper.subinterfaces0((InterfaceType)this.classType);
            List<ClassType> implementors = InterfaceTypeWrapper.implementors0((InterfaceType)this.classType);
            int ss = subinterfaces.size();
            int is = implementors.size();
            if (ss > 0 || is > 0) {
                ArrayList<JPDAClassTypeImpl> subClasses = new ArrayList<JPDAClassTypeImpl>(ss + is);
                for (InterfaceType interfaceType : subinterfaces) {
                    subClasses.add(new JPDAClassTypeImpl(this.debugger, interfaceType));
                }
                for (ClassType classType : implementors) {
                    subClasses.add(new JPDAClassTypeImpl(this.debugger, classType));
                }
                return Collections.unmodifiableList(subClasses);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInstanceOf(String className) {
        List<ReferenceType> classTypes;
        try {
            classTypes = VirtualMachineWrapper.classesByName(MirrorWrapper.virtualMachine(this.classType), className);
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        for (ReferenceType rt : classTypes) {
            if (!EvaluatorVisitor.instanceOf(this.classType, rt)) continue;
            return true;
        }
        return false;
    }

    public List<org.netbeans.api.debugger.jpda.Field> staticFields() {
        List<Field> allFieldsOrig;
        try {
            allFieldsOrig = ReferenceTypeWrapper.allFields0(this.classType);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        ArrayList<org.netbeans.api.debugger.jpda.Field> staticFields = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        String parentID = this.getName();
        for (int i = 0; i < allFieldsOrig.size(); ++i) {
            Object value = null;
            Field origField = allFieldsOrig.get(i);
            try {
                if (!TypeComponentWrapper.isStatic(origField)) continue;
                if (origField.signature().length() == 1) {
                    staticFields.add(new FieldVariable(this.debugger, origField, parentID, null));
                    continue;
                }
                staticFields.add(new ObjectFieldVariable(this.debugger, origField, parentID, JPDADebuggerImpl.getGenericSignature(origField), null));
                continue;
            }
            catch (InternalExceptionWrapper ex) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
        }
        return staticFields;
    }

    public long getInstanceCount() {
        try {
            long[] counts = VirtualMachineWrapper.instanceCounts(MirrorWrapper.virtualMachine(this.classType), Collections.singletonList(this.classType));
            return counts[0];
        }
        catch (InternalExceptionWrapper ex) {
            return 0L;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return 0L;
        }
    }

    public List<ObjectVariable> getInstances(long maxInstances) {
        List<ObjectReference> instances;
        try {
            instances = ReferenceTypeWrapper.instances(this.classType, maxInstances);
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        catch (InternalExceptionWrapper ex) {
            return Collections.emptyList();
        }
        return new AbstractList<ObjectVariable>(){

            @Override
            public ObjectVariable get(int i) {
                ObjectReference obj = (ObjectReference)instances.get(i);
                return new AbstractObjectVariable(JPDAClassTypeImpl.this.debugger, obj, JPDAClassTypeImpl.this.classType.name() + " instance " + i);
            }

            @Override
            public int size() {
                return instances.size();
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof JPDAClassTypeImpl)) {
            return false;
        }
        return ((Object)this.classType).equals(((JPDAClassTypeImpl)o).classType);
    }

    public int hashCode() {
        return ((Object)this.classType).hashCode() + 1000;
    }
}

