/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import javax.swing.Action;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.CheckDeadlocksAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DebuggingActionsProviderFilter
implements NodeActionsProviderFilter {
    private Action SUSPEND_ALL_ACTION = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProviderFilter.class).getString("CTL_ThreadAction_Suspend_All_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){
        RequestProcessor.Task task;

        public boolean isEnabled(Object node) {
            return node == "Root" && DebuggingActionsProviderFilter.this.debugger.getThreadsCollector().isSomeThreadRunning();
        }

        public synchronized void perform(Object[] nodes) {
            if (this.task == null) {
                this.task = DebuggingActionsProviderFilter.this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingActionsProviderFilter.this.debugger.suspend();
                    }
                });
            } else {
                this.task.schedule(1);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action RESUME_ALL_ACTION = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProviderFilter.class).getString("CTL_ThreadAction_Resume_All_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){
        RequestProcessor.Task task;

        public boolean isEnabled(Object node) {
            return node == "Root" && DebuggingActionsProviderFilter.this.debugger.getThreadsCollector().isSomeThreadSuspended();
        }

        public synchronized void perform(Object[] nodes) {
            if (this.task == null) {
                this.task = DebuggingActionsProviderFilter.this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingActionsProviderFilter.this.debugger.resume();
                    }
                });
            } else {
                this.task.schedule(1);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action DEADLOCK_DETECT_ACTION = Models.createAction((String)CheckDeadlocksAction.getDisplayName(), (Models.ActionPerformer)new Models.ActionPerformer(){
        RequestProcessor.Task task;

        public boolean isEnabled(Object node) {
            return node == "Root";
        }

        public synchronized void perform(Object[] nodes) {
            if (this.task == null) {
                this.task = DebuggingActionsProviderFilter.this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        CheckDeadlocksAction.checkForDeadlock(DebuggingActionsProviderFilter.this.debugger);
                    }
                });
            } else {
                this.task.schedule(1);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private JPDADebuggerImpl debugger;

    public DebuggingActionsProviderFilter(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            int x;
            Action[] actions = new Action[]{this.RESUME_ALL_ACTION, this.SUSPEND_ALL_ACTION, null, this.DEADLOCK_DETECT_ACTION};
            Action[] origActions = original.getActions(node);
            if (origActions == null || origActions.length == 0) {
                return actions;
            }
            Action[] result = new Action[actions.length + 1 + origActions.length];
            for (x = 0; x < actions.length; ++x) {
                result[x] = actions[x];
            }
            result[actions.length] = null;
            for (x = 0; x < origActions.length; ++x) {
                result[actions.length + 1 + x] = origActions[x];
            }
            return result;
        }
        return original.getActions(node);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }
}

