/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class VarDocHint
extends AbstractRule {
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public String getId() {
        return "Var.Doc.Hint";
    }

    public String getDescription() {
        return Bundle.VarDocHintDesc();
    }

    public String getDisplayName() {
        return Bundle.VarDocHintDispName();
    }

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult parseResult;
        Model model;
        VariableScope variableScope;
        String identifier;
        BaseDocument doc = context.doc;
        int caretOffset = context.caretOffset;
        int lineBegin = -1;
        int lineEnd = -1;
        lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin && (identifier = Utilities.getIdentifier((BaseDocument)doc, (int)caretOffset)) != null && identifier.startsWith("$") && (variableScope = (model = (parseResult = (PHPParseResult)context.parserResult).getModel()).getVariableScope(caretOffset)) != null) {
            OffsetRange identifierRange;
            int offset;
            int wordStart = Utilities.getWordStart((BaseDocument)doc, (int)caretOffset);
            int wordEnd = Utilities.getWordEnd((BaseDocument)doc, (int)caretOffset);
            VariableName variable = ModelUtils.getFirst(variableScope.getDeclaredVariables(), identifier);
            if (variable != null && wordEnd - wordStart == identifier.length() && variable.getTypes(offset = (identifierRange = new OffsetRange(wordStart, wordEnd)).getEnd()).isEmpty()) {
                Collection typeNames = variable.getTypeNames(offset);
                for (String type : typeNames) {
                    if (type.contains("@")) continue;
                    return;
                }
                hints.add(new Hint((Rule)this, this.getDisplayName(), context.parserResult.getSnapshot().getSource().getFileObject(), identifierRange, Collections.singletonList(new Fix(context, variable)), 500));
            }
        }
    }

    private class Fix
    implements HintFix {
        private RuleContext context;
        private VariableName vName;

        Fix(RuleContext context, VariableName vName) {
            this.context = context;
            this.vName = vName;
        }

        public String getDescription() {
            return VarDocHint.this.getDescription();
        }

        public void implement() throws Exception {
            JTextComponent target;
            BaseDocument doc = this.context.doc;
            int caretOffset = this.getOffset(doc);
            String commentText = this.getCommentText();
            int indexOf = commentText.indexOf(this.getTypeTemplate());
            EditList editList = this.getEditList(doc, caretOffset);
            Position typeOffset = editList.createPosition(caretOffset + indexOf);
            editList.apply();
            if (typeOffset != null && typeOffset.getOffset() != -1 && (target = GsfUtilities.getPaneFor((FileObject)this.context.parserResult.getSnapshot().getSource().getFileObject())) != null) {
                int startOffset = typeOffset.getOffset();
                int endOffset = startOffset + this.getTypeTemplate().length();
                if (indexOf != -1 && endOffset <= doc.getLength()) {
                    String s = doc.getText(startOffset, this.getTypeTemplate().length());
                    if (this.getTypeTemplate().equals(s)) {
                        target.select(startOffset, endOffset);
                        this.scheduleShowingCompletion();
                    }
                }
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList(BaseDocument doc, int caretOffset) throws Exception {
            EditList edits = new EditList(doc);
            edits.replace(caretOffset, 0, this.getCommentText(), true, 0);
            return edits;
        }

        private String getCommentText() {
            return String.format("\n/* @var %s %s */", this.vName.getName(), this.getTypeTemplate());
        }

        private String getTypeTemplate() {
            return "type";
        }

        private int getOffset(BaseDocument doc) throws BadLocationException {
            int caretOffset = Utilities.getRowStart((BaseDocument)doc, (int)this.context.caretOffset);
            return Utilities.getRowEnd((BaseDocument)doc, (int)(caretOffset - 1));
        }

        private void scheduleShowingCompletion() {
            service.schedule(new Runnable(){

                @Override
                public void run() {
                    Completion.get().showCompletion();
                }
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }
}

