/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.CheckPHPVersionVisitor;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.openide.filesystems.FileObject;

public class PHPHintsProvider
implements HintsProvider {
    public static final String FIRST_PASS_HINTS = "1st pass";
    public static final String SECOND_PASS_HINTS = "2nd pass";
    public static final String DEFAULT_LINE_HINTS = "default.line.hints";
    private static final Logger LOGGER = Logger.getLogger(PHPHintsProvider.class.getName());

    public void computeHints(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> hints) {
        long startTime = LOGGER.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        ParserResult info = context.parserResult;
        Map allHints = mgr.getHints(false, context);
        List modelHints = (List)allHints.get(DEFAULT_LINE_HINTS);
        if (modelHints != null) {
            FileScope modelScope;
            PHPRuleContext ruleContext = (PHPRuleContext)context;
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel();
            ruleContext.fileScope = modelScope = model.getFileScope();
            for (Rule.AstRule astRule : modelHints) {
                Object icm;
                if (!mgr.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                if (astRule instanceof PHPRuleWithPreferences) {
                    icm = (PHPRuleWithPreferences)astRule;
                    icm.setPreferences(mgr.getPreferences((Rule.UserConfigurableRule)astRule));
                }
                if (!(astRule instanceof AbstractRule)) continue;
                icm = (AbstractRule)astRule;
                try {
                    ((AbstractRule)icm).computeHintsImpl(ruleContext, hints, Kind.HINT);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long execTime = Calendar.getInstance().getTimeInMillis() - startTime;
            FileObject fobj = info.getSnapshot().getSource().getFileObject();
            LOGGER.fine(String.format("Computing PHP hints for %s.%s took %d ms", fobj.getName(), fobj.getExt(), execTime));
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> suggestions, int caretOffset) {
        Map allHints = mgr.getHints(true, context);
        List modelHints = (List)allHints.get(DEFAULT_LINE_HINTS);
        if (modelHints != null) {
            FileScope modelScope;
            PHPRuleContext ruleContext = (PHPRuleContext)context;
            ParserResult info = context.parserResult;
            if (!(info instanceof PHPParseResult)) {
                return;
            }
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel();
            ruleContext.fileScope = modelScope = model.getFileScope();
            for (Rule.AstRule astRule : modelHints) {
                if (!mgr.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof AbstractRule)) continue;
                AbstractRule icm = (AbstractRule)astRule;
                try {
                    icm.computeHintsImpl(ruleContext, suggestions, Kind.SUGGESTION);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        PHPParseResult phpParseResult;
        FileObject fobj;
        ParserResult parserResult = context.parserResult;
        if (parserResult != null) {
            List errors = parserResult.getDiagnostics();
            unhandled.addAll(errors);
        }
        if ((fobj = NbEditorUtilities.getFileObject((Document)context.doc)) != null && CheckPHPVersionVisitor.appliesTo(fobj) && (phpParseResult = (PHPParseResult)context.parserResult).getProgram() != null) {
            CheckPHPVersionVisitor visitor = new CheckPHPVersionVisitor(fobj);
            phpParseResult.getProgram().accept(visitor);
            unhandled.addAll(visitor.getErrors());
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new PHPRuleContext();
    }

    static enum Kind {
        HINT,
        SUGGESTION,
        SELECTION,
        ERROR;

    }
}

