/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ImplementAbstractMethodsHint
extends AbstractRule {
    private static final String HINT_ID = "Implement.Abstract.Methods";
    private static final String ABSTRACT_PREFIX = "abstract ";

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ImplementAbstractMethodsDesc();
    }

    public String getDisplayName() {
        return Bundle.ImplementAbstractMethodsDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(context.fileScope);
        FileObject fileObject = context.parserResult.getSnapshot().getSource().getFileObject();
        for (FixInfo fixInfo : this.checkHints(allClasses, context)) {
            hints.add(new Hint((Rule)this, Bundle.ImplementAbstractMethodsHintDesc(fixInfo.className, fixInfo.lastMethodDeclaration, fixInfo.lastMethodOwnerName), fileObject, fixInfo.classNameRange, this.createHintFixes(context.doc, fixInfo), 500));
        }
    }

    private List<HintFix> createHintFixes(BaseDocument doc, FixInfo fixInfo) {
        LinkedList<Object> hintFixes = new LinkedList<Object>();
        hintFixes.add(new ImplementAllFix(doc, fixInfo));
        hintFixes.add(new AbstractClassFix(doc, fixInfo));
        return Collections.unmodifiableList(hintFixes);
    }

    private Collection<FixInfo> checkHints(Collection<? extends ClassScope> allClasses, PHPRuleContext context) throws BadLocationException {
        ArrayList<FixInfo> retval = new ArrayList<FixInfo>();
        for (ClassScope classScope : allClasses) {
            if (classScope.isAbstract()) continue;
            ElementQuery.Index index = context.getIndex();
            HashSet<String> allValidMethods = new HashSet<String>();
            Set<? extends PhpElement> validInheritedMethods = this.getValidInheritedMethods(index.getInheritedMethods(classScope));
            allValidMethods.addAll(ImplementAbstractMethodsHint.toNames(validInheritedMethods));
            allValidMethods.addAll(ImplementAbstractMethodsHint.toNames(index.getDeclaredMethods(classScope)));
            ElementFilter declaredMethods = ElementFilter.forExcludedNames(allValidMethods, PhpElementKind.METHOD);
            Set<MethodElement> accessibleMethods = declaredMethods.filter(index.getAccessibleMethods(classScope, classScope));
            LinkedHashSet<String> methodSkeletons = new LinkedHashSet<String>();
            MethodElement lastMethodElement = null;
            for (MethodElement methodElement : accessibleMethods) {
                TypeElement type = methodElement.getType();
                if (!type.isInterface() && !methodElement.isAbstract() || methodElement.isFinal()) continue;
                String skeleton = methodElement.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody);
                skeleton = skeleton.replace(ABSTRACT_PREFIX, "");
                methodSkeletons.add(skeleton);
                lastMethodElement = methodElement;
            }
            if (methodSkeletons.isEmpty() || lastMethodElement == null) continue;
            int newMethodsOffset = ImplementAbstractMethodsHint.getNewMethodsOffset(classScope, context.doc);
            int classDeclarationOffset = ImplementAbstractMethodsHint.getClassDeclarationOffset(context.parserResult.getSnapshot().getTokenHierarchy(), classScope.getOffset());
            if (newMethodsOffset == -1 || classDeclarationOffset == -1) continue;
            retval.add(new FixInfo(classScope, methodSkeletons, lastMethodElement, newMethodsOffset, classDeclarationOffset));
        }
        return retval;
    }

    private Set<? extends PhpElement> getValidInheritedMethods(Set<MethodElement> inheritedMethods) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (MethodElement methodElement : inheritedMethods) {
            if (methodElement.isAbstract()) continue;
            retval.add(methodElement);
        }
        return retval;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private static int getClassDeclarationOffset(TokenHierarchy<?> th, int classNameOffset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(th, classNameOffset);
        ts.move(classNameOffset);
        ts.movePrevious();
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, Collections.singletonList(PHPTokenId.PHP_CLASS));
        return previousToken.offset(th);
    }

    private static int getNewMethodsOffset(ClassScope classScope, BaseDocument doc) throws BadLocationException {
        int offset = -1;
        Collection<? extends MethodScope> declaredMethods = classScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            OffsetRange blockRange = methodScope.getBlockRange();
            if (blockRange == null || blockRange.getEnd() <= offset) continue;
            offset = blockRange.getEnd();
        }
        if (offset == -1 && classScope.getBlockRange() != null) {
            offset = Utilities.getRowStart((BaseDocument)doc, (int)classScope.getBlockRange().getEnd()) - 1;
        }
        if (offset != -1) {
            offset = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
        }
        return offset;
    }

    private static class FixInfo {
        private List<String> methodSkeletons;
        private String className;
        private int newMethodsOffset;
        private OffsetRange classNameRange;
        private final String lastMethodDeclaration;
        private final String lastMethodOwnerName;
        private final int classDeclarationOffset;

        FixInfo(ClassScope classScope, LinkedHashSet<String> methodSkeletons, MethodElement lastMethodElement, int newMethodsOffset, int classDeclarationOffset) {
            this.methodSkeletons = new ArrayList<String>(methodSkeletons);
            this.className = classScope.getFullyQualifiedName().toString();
            Collections.sort(this.methodSkeletons);
            this.classNameRange = classScope.getNameRange();
            this.classDeclarationOffset = classDeclarationOffset;
            this.newMethodsOffset = newMethodsOffset;
            this.lastMethodDeclaration = lastMethodElement.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration);
            this.lastMethodOwnerName = lastMethodElement.getType().getFullyQualifiedName().toString();
        }
    }

    private class AbstractClassFix
    implements HintFix {
        private final BaseDocument doc;
        private final FixInfo fixInfo;

        public AbstractClassFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.AbstractClassFixDesc();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.fixInfo.classDeclarationOffset, 0, ImplementAbstractMethodsHint.ABSTRACT_PREFIX, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class ImplementAllFix
    implements HintFix {
        private BaseDocument doc;
        private final FixInfo fixInfo;

        ImplementAllFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return ImplementAbstractMethodsHint.this.getDescription();
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList() throws Exception {
            EditList edits = new EditList(this.doc);
            for (String methodScope : this.fixInfo.methodSkeletons) {
                edits.replace(this.fixInfo.newMethodsOffset, 0, "\n" + methodScope, true, 0);
            }
            return edits;
        }
    }
}

