/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;

public class CheckPHPVersionVisitor
extends DefaultTreePathVisitor {
    private FileObject fobj;
    private ArrayList<PHPVersionError> errors = new ArrayList();

    public CheckPHPVersionVisitor(FileObject fobj) {
        this.fobj = fobj;
    }

    public static boolean appliesTo(FileObject fobj) {
        PhpLanguageOptions.Properties props;
        return fobj != null && (props = PhpLanguageOptions.getDefault().getProperties(fobj)).getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_5;
    }

    @Override
    public void visit(NamespaceDeclaration declaration) {
        NamespaceName name = declaration.getName();
        if (name != null) {
            this.createError(declaration.getStartOffset(), name.getEndOffset());
        } else {
            this.createError(declaration);
        }
    }

    @Override
    public void visit(LambdaFunctionDeclaration declaration) {
        this.createError(declaration);
    }

    @Override
    public void visit(GotoLabel label) {
        this.createError(label);
    }

    @Override
    public void visit(ConstantDeclaration statement) {
        for (ASTNode node : this.getPath()) {
            if (!(node instanceof TypeDeclaration)) continue;
            return;
        }
        this.createError(statement);
    }

    @Override
    public void visit(GotoStatement statement) {
        this.createError(statement);
    }

    @Override
    public void visit(UseStatement statement) {
        this.createError(statement);
    }

    @Override
    public void visit(StaticMethodInvocation node) {
        if (node.getClassName() instanceof Variable) {
            this.createError(node.getClassName());
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(NamespaceName namespaceName) {
        QualifiedName qname = QualifiedName.create(namespaceName);
        if (qname.getKind() != QualifiedNameKind.UNQUALIFIED) {
            this.createError(namespaceName);
        }
    }

    public Collection<? extends Error> getErrors() {
        return this.errors;
    }

    private void createError(int startOffset, int endOffset) {
        PHPVersionError error = new PHPVersionError(startOffset, endOffset);
        this.errors.add(error);
    }

    private void createError(ASTNode node) {
        this.createError(node.getStartOffset(), node.getEndOffset());
        super.visit(node);
    }

    class PHPVersionError
    implements Error {
        private int startPosition;
        private int endPosition;

        public PHPVersionError(int startPosition, int endPosition) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public String getDescription() {
            return Bundle.CheckPHPVerDesc();
        }

        public String getDisplayName() {
            return Bundle.CheckPHPVerDispName();
        }

        public String getKey() {
            return "php.ver";
        }

        public FileObject getFile() {
            return CheckPHPVersionVisitor.this.fobj;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public boolean isLineError() {
            return true;
        }

        public Severity getSeverity() {
            return Severity.ERROR;
        }

        public Object[] getParameters() {
            return new Object[0];
        }
    }
}

