/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;

abstract class TypeScopeImpl
extends ScopeImpl
implements TypeScope {
    private Map<String, List<? extends InterfaceScope>> ifaces = new HashMap<String, List<? extends InterfaceScope>>();

    TypeScopeImpl(Scope inScope, ClassDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo, nodeInfo.getAccessModifiers(), ((ClassDeclaration)nodeInfo.getOriginalNode()).getBody());
        List<? extends Expression> interfaces = nodeInfo.getInterfaces();
        for (Expression expression : interfaces) {
            this.ifaces.put(CodeUtils.extractQualifiedName(expression), null);
        }
    }

    TypeScopeImpl(Scope inScope, InterfaceDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo, PhpModifiers.fromBitMask(1), ((InterfaceDeclaration)nodeInfo.getOriginalNode()).getBody());
        List<? extends Expression> interfaces = nodeInfo.getInterfaces();
        for (Expression expression : interfaces) {
            this.ifaces.put(CodeUtils.extractQualifiedName(expression), null);
        }
    }

    protected TypeScopeImpl(Scope inScope, ClassElement element) {
        super(inScope, element, PhpElementKind.CLASS);
    }

    protected TypeScopeImpl(Scope inScope, InterfaceElement element) {
        super(inScope, element, PhpElementKind.IFACE);
    }

    public List<? extends String> getSuperInterfaceNames() {
        if (this.indexedElement instanceof TypeElement) {
            ArrayList<String> retval = new ArrayList<String>();
            Set<QualifiedName> superInterfaces = ((TypeElement)this.indexedElement).getSuperInterfaces();
            for (QualifiedName qualifiedName : superInterfaces) {
                retval.add(qualifiedName.toString());
            }
            return retval;
        }
        return new ArrayList<String>(this.ifaces.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<? extends InterfaceScope> getSuperInterfaceScopes() {
        LinkedHashSet<InterfaceScope> retval = new LinkedHashSet<InterfaceScope>();
        Set<Object> keySet = this.indexedElement instanceof TypeElement ? new HashSet(this.getSuperInterfaceNames()) : this.ifaces.keySet();
        for (String string : keySet) {
            List<InterfaceScope> iface = this.ifaces.get(string);
            if (iface == null) {
                if (this.indexedElement == null) {
                    NamespaceScope top = (NamespaceScope)this.getInScope();
                    NamespaceScopeImpl ps = (NamespaceScopeImpl)top;
                    iface = ModelUtils.filter(ps.getDeclaredInterfaces(), string);
                    retval.addAll(iface);
                    this.ifaces.put(string, iface);
                    if (retval.isEmpty() && top instanceof NamespaceScopeImpl) {
                        IndexScope indexScope = ModelUtils.getIndexScope(ps);
                        if (indexScope == null) throw new UnsupportedOperationException();
                        List<? extends InterfaceScope> cIfaces = IndexScopeImpl.getInterfaces(QualifiedName.create(string), this);
                        this.ifaces.put(string, cIfaces);
                        for (InterfaceScope interfaceScope : cIfaces) {
                            retval.add((InterfaceScopeImpl)interfaceScope);
                        }
                    }
                } else {
                    iface = Collections.emptyList();
                }
            } else {
                retval.addAll(iface);
            }
            assert (iface != null);
        }
        return new ArrayList(retval);
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredMethods() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScopeImpl = ModelUtils.getIndexScope(this);
            return indexScopeImpl.findMethods(this);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
            }
        });
    }

    public Collection<? extends MethodScope> findDeclaredMethods(final String queryName, final int ... modifiers) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            QualifiedName qn = this.getNamespaceName().append(this.getName());
            NamespaceIndexFilter filter = new NamespaceIndexFilter(qn.toString());
            List<? extends MethodScope> methods = indexScopeImpl.findMethods(this, queryName, modifiers);
            return filter.filterModelElements(methods, true);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.METHOD) && ModelElementImpl.nameKindMatch(element.getName(), QuerySupport.Kind.EXACT, queryName) && (modifiers.length == 0 || (element.getPhpModifiers().toFlags() & PhpModifiers.fromBitMask(modifiers).toFlags()) != 0);
            }
        });
    }

    @Override
    public final Collection<? extends ClassConstantElement> getDeclaredConstants() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            return indexScopeImpl.findClassConstants(this);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.TYPE_CONSTANT);
            }
        });
    }

    @Override
    public String getNormalizedName() {
        StringBuilder sb = new StringBuilder();
        Collection ifaceNames = this.getSuperInterfaceNames();
        for (String ifName : ifaceNames) {
            sb.append(ifName);
        }
        return sb.toString() + super.getNormalizedName();
    }

    @Override
    public Set<QualifiedName> getSuperInterfaces() {
        HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
        Collection superInterfaceNames = this.getSuperInterfaceNames();
        for (String name : superInterfaceNames) {
            retval.add(QualifiedName.create(name));
        }
        return retval;
    }

    @Override
    public final boolean isClass() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.CLASS);
    }

    @Override
    public final boolean isInterface() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.IFACE);
    }
}

