/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class Utils {
    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        assert (files.length > 0);
        HashSet<URL> dependentRoots = new HashSet<URL>();
        for (FileObject fo : files) {
            Project p = null;
            if (fo != null) {
                p = FileOwnerQuery.getOwner((FileObject)fo);
            }
            if (p != null) {
                URL sourceRoot = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").findOwnerRoot(fo), (int)0);
                dependentRoots.addAll(SourceUtils.getDependentRoots((URL)sourceRoot));
                for (SourceGroup root : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root.getRootFolder(), (int)0));
                }
                continue;
            }
            for (ClassPath cp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject root : cp.getRoots()) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root, (int)0));
                }
            }
        }
        ClassPath rcp = ClassPathSupport.createClassPath((URL[])dependentRoots.toArray(new URL[dependentRoots.size()]));
        ClassPath nullPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath boot = files[0] != null ? ClassPath.getClassPath((FileObject)files[0], (String)"classpath/boot") : nullPath;
        ClassPath compile = files[0] != null ? ClassPath.getClassPath((FileObject)files[0], (String)"classpath/compile") : nullPath;
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)boot, (ClassPath)compile, (ClassPath)rcp);
        return cpInfo;
    }

    public static List<FileObject> getGroovyFilesInProject(FileObject fileInProject) {
        ClasspathInfo cpInfo = Utils.getClasspathInfoFor(fileInProject);
        ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> list = new ArrayList<FileObject>(100);
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject root = entry.getRoot();
            Utils.addGroovyFiles(list, root);
        }
        return list;
    }

    private static void addGroovyFiles(List<FileObject> list, FileObject f) {
        if (f.isFolder()) {
            for (FileObject child : f.getChildren()) {
                Utils.addGroovyFiles(list, child);
            }
        } else if (Utils.isGroovyFile(f)) {
            list.add(f);
        }
    }

    public static boolean isInGroovyProject(FileObject f) {
        GroovyFeature groovyFeature;
        Project project = FileOwnerQuery.getOwner((FileObject)f);
        if (project != null && (groovyFeature = (GroovyFeature)project.getLookup().lookup(GroovyFeature.class)) != null) {
            return groovyFeature.isGroovyEnabled();
        }
        return false;
    }

    public static boolean isGroovyFile(FileObject f) {
        return "groovy".equals(f.getExt());
    }

    public static boolean isGspFile(FileObject f) {
        return false;
    }

    public static boolean isGroovyOrGspFile(FileObject f) {
        return Utils.isGroovyFile(f) || Utils.isGspFile(f);
    }

    private static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static Line getLine(FileObject fileObject, int lineNumber) {
        LineCookie lineCookie = Utils.getLineCookie(fileObject);
        assert (lineCookie != null);
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    public static CloneableEditorSupport findCloneableEditorSupport(FileObject fileObject) {
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Utils.findCloneableEditorSupport(dob);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static BaseDocument getDocument(ParserResult info, FileObject fo) {
        BaseDocument doc = null;
        try {
            DataObject od;
            EditorCookie ec;
            if (info != null) {
                doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
            }
            if (doc == null && (ec = (EditorCookie)(od = DataObject.find((FileObject)fo)).getCookie(EditorCookie.class)) != null) {
                doc = (BaseDocument)ec.openDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return doc;
    }
}

