/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.packets.BreakResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntUpdateResponse;
import org.netbeans.modules.php.dbgp.packets.ContextGetResponse;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpStream;
import org.netbeans.modules.php.dbgp.packets.EvalResponse;
import org.netbeans.modules.php.dbgp.packets.ExecResponse;
import org.netbeans.modules.php.dbgp.packets.ExprResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureGetResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureSetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyGetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertySetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyValueResponse;
import org.netbeans.modules.php.dbgp.packets.RequestedUrlEvalCommand;
import org.netbeans.modules.php.dbgp.packets.RequestedUrlEvalResponse;
import org.netbeans.modules.php.dbgp.packets.SourceResponse;
import org.netbeans.modules.php.dbgp.packets.StackDepthResponse;
import org.netbeans.modules.php.dbgp.packets.StackGetResponse;
import org.netbeans.modules.php.dbgp.packets.StatusResponse;
import org.netbeans.modules.php.dbgp.packets.StreamResponse;
import org.netbeans.modules.php.dbgp.packets.TypeMapGetResponse;
import org.w3c.dom.Node;

class MessageBuilder {
    private static final String TYPE = "type";

    private MessageBuilder() {
    }

    static DbgpMessage createStream(Node node) {
        Node attr = node.getAttributes().getNamedItem(TYPE);
        assert (attr != null);
        String type = attr.getNodeValue();
        if (DbgpStream.StreamType.STDOUT.toString().equals(type)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDOUT);
        }
        if (DbgpStream.StreamType.STDERR.toString().equals(type)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDERR);
        }
        assert (false);
        return null;
    }

    static DbgpMessage createResponse(Node node) {
        String command = DbgpMessage.getAttribute(node, "command");
        assert (command != null);
        if (command.equals("run") || command.equals("status") || command.equals("step_out") || command.equals("step_over") || command.equals("step_into") || command.equals("stop")) {
            return new StatusResponse(node);
        }
        if (command.equals("breakpoint_set")) {
            return new BrkpntSetResponse(node);
        }
        if (command.equals("breakpoint_update")) {
            return new BrkpntUpdateResponse(node);
        }
        if (command.equals("breakpoint_remove")) {
            return new BrkpntRemoveResponse(node);
        }
        if (command.equals("context_names")) {
            return new ContextNamesResponse(node);
        }
        if (command.equals("context_get")) {
            return new ContextGetResponse(node);
        }
        if (command.equals("stack_depth")) {
            return new StackDepthResponse(node);
        }
        if (command.equals("stack_get")) {
            return new StackGetResponse(node);
        }
        if (command.equals("typemap_get")) {
            return new TypeMapGetResponse(node);
        }
        if (command.equals("property_set")) {
            return new PropertySetResponse(node);
        }
        if (command.equals("property_get")) {
            return new PropertyGetResponse(node);
        }
        if (command.equals("property_value")) {
            return new PropertyValueResponse(node);
        }
        if (command.equals("source")) {
            return new SourceResponse(node);
        }
        if (command.equals(DbgpStream.StreamType.STDERR.toString()) || command.equals(DbgpStream.StreamType.STDOUT.toString())) {
            return new StreamResponse(node);
        }
        if (command.equals("feature_get")) {
            return new FeatureGetResponse(node);
        }
        if (command.equals("feature_set")) {
            return new FeatureSetResponse(node);
        }
        if (command.equals("break")) {
            return new BreakResponse(node);
        }
        if (command.equals("eval")) {
            String transactionId = DbgpMessage.getAttribute(node, "transaction_id");
            if (transactionId.equals(RequestedUrlEvalCommand.LAST_USED_TRANSACTION_ID)) {
                return new RequestedUrlEvalResponse(node);
            }
            return new EvalResponse(node);
        }
        if (command.equals("expr")) {
            return new ExprResponse(node);
        }
        if (command.equals("exec")) {
            return new ExecResponse(node);
        }
        return null;
    }
}

