/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import sun.misc.BASE64Encoder;

public abstract class DbgpCommand {
    protected static final String SPACE = " ";
    private static final String DATA_SEPARATOR = " -- ";
    private static final String TRANSACTION_OPT = " -i ";
    private String command;
    private String transactionId;

    DbgpCommand(String command, String transactionId) {
        this.command = command;
        this.transactionId = transactionId;
    }

    public void send(OutputStream out) throws IOException {
        String encodedData = null;
        if (this.getData() != null) {
            encodedData = this.encodeData();
        }
        StringBuilder dataToSend = new StringBuilder(this.getCommand());
        dataToSend.append(this.getArgumentString());
        if (encodedData != null) {
            dataToSend.append(DATA_SEPARATOR);
            dataToSend.append(encodedData);
        }
        Logger.getLogger(DbgpCommand.class.getName()).fine("command to send : " + dataToSend);
        byte[] bytes = dataToSend.toString().getBytes();
        byte[] sendBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, sendBytes, 0, bytes.length);
        sendBytes[bytes.length] = 0;
        out.write(sendBytes);
        out.flush();
    }

    private String encodeData() throws IOException {
        SessionId sessionId;
        BASE64Encoder encoder = new BASE64Encoder();
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session != null && (sessionId = (SessionId)session.lookupFirst(null, SessionId.class)) != null) {
            String projectEncoding = SessionManager.getInstance().getSession(sessionId).getOptions().getProjectEncoding();
            return encoder.encode(this.getData().getBytes(projectEncoding));
        }
        return encoder.encode(this.getData().getBytes());
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public abstract boolean wantAcknowledgment();

    protected String getData() {
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    protected String getArguments() {
        return "";
    }

    private String getArgumentString() {
        if (this.getArguments() != null && this.getArguments().length() > 0) {
            return TRANSACTION_OPT + this.transactionId + SPACE + this.getArguments();
        }
        return TRANSACTION_OPT + this.transactionId;
    }
}

