/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.netbeans.modules.php.dbgp.URIMapper;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SessionId {
    private static final String SOURCES_TYPE_PHP = "PHPSOURCE";
    private URIMapper.MultiMapper uriMapper;
    private String id = this.getSessionPrefix();
    private final FileObject sessionFileObject;
    private final Project sessionProject;

    public SessionId(FileObject fileObject, Project project) {
        this.sessionFileObject = fileObject;
        this.sessionProject = project;
    }

    public String getId() {
        return this.id;
    }

    public Project getProject() {
        return this.sessionProject;
    }

    synchronized void initialize(String uri, List<Pair<String, String>> pathMapping) {
        if (this.uriMapper == null) {
            Project project = this.getProject();
            FileObject sourceRoot = project != null ? this.getSourceRoot() : this.sessionFileObject.getParent();
            this.uriMapper = URIMapper.createMultiMapper(URI.create(uri), this.sessionFileObject, sourceRoot, pathMapping);
        }
        this.notifyAll();
        SessionProgress s = SessionProgress.forSessionId(this);
        if (s != null) {
            s.notifyConnectionFinished();
        }
    }

    public synchronized boolean isInitialized(boolean waitForInitialization) {
        boolean isInitialized;
        boolean bl = isInitialized = this.uriMapper != null;
        if (!isInitialized && waitForInitialization) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            isInitialized = this.uriMapper != null;
        }
        return isInitialized;
    }

    public String toWebServerURI(FileObject localFile) {
        if (this.uriMapper != null) {
            File file = FileUtil.toFile((FileObject)localFile);
            assert (file != null);
            URI uri = this.uriMapper.toWebServerURI(file);
            if (uri != null) {
                return uri.toString();
            }
        }
        return null;
    }

    public FileObject toSourceFile(String uri) {
        if (this.uriMapper != null) {
            File localFile = this.uriMapper.toSourceFile(URI.create(uri));
            localFile = localFile != null ? FileUtil.normalizeFile((File)localFile) : null;
            return localFile != null ? FileUtil.toFileObject((File)localFile) : null;
        }
        return null;
    }

    private FileObject getSourceRoot() {
        FileObject[] sourceObjects = SessionId.getSourceObjects(this.getProject());
        return sourceObjects != null && sourceObjects.length > 0 ? sourceObjects[0] : null;
    }

    private static FileObject[] getSourceObjects(Project phpProject) {
        SourceGroup[] groups = SessionId.getSourceGroups(phpProject);
        FileObject[] fileObjects = new FileObject[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            fileObjects[i] = groups[i].getRootFolder();
        }
        return fileObjects;
    }

    private static SourceGroup[] getSourceGroups(Project phpProject) {
        Sources sources = ProjectUtils.getSources((Project)phpProject);
        SourceGroup[] groups = sources.getSourceGroups(SOURCES_TYPE_PHP);
        return groups;
    }

    private String getSessionPrefix() {
        return PhpOptions.getInstance().getDebuggerSessionId();
    }
}

