/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.awt.Color;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class ConnectionErrMessage
extends JPanel {
    private final String message;
    private JEditorPane link;
    private JLabel messageIconLabel;
    private JLabel messageTextLabel;

    public static void showMe(int seconds) {
        ConnectionErrMessage panel = new ConnectionErrMessage(seconds);
        NotifyDescriptor.Message messageDescriptor = new NotifyDescriptor.Message((Object)"");
        DialogDescriptor descr2 = new DialogDescriptor((Object)panel, messageDescriptor.getTitle(), true, new Object[]{DialogDescriptor.OK_OPTION}, null, 0, null, null);
        DialogDisplayer.getDefault().createDialog(descr2).setVisible(true);
    }

    private ConnectionErrMessage(int seconds) {
        this.message = ConnectionErrMessage.createMessage(seconds);
        this.initComponents();
    }

    private static String createMessage(int seconds) {
        int debuggerPort = PhpOptions.getInstance().getDebuggerPort();
        String entry1 = "<li>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionEntry1") + "</li>";
        String entry2 = "<li>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionEntry2") + "</li>";
        String entry3 = "<li>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionEntry3") + "</li>";
        String entry4 = "<li>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionEntry4", (Object)String.valueOf(debuggerPort)) + "</li>";
        String entries = "<ul>" + entry1 + entry2 + entry3 + entry4 + "</ul>";
        return "<html>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSession", (Object)seconds, (Object)entries) + "</html>";
    }

    private static JLabel createIconLabel() {
        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
        return icon != null ? new JLabel(icon) : new JLabel();
    }

    private void initComponents() {
        this.messageIconLabel = ConnectionErrMessage.createIconLabel();
        this.messageTextLabel = new JLabel();
        this.link = HyperlinkPane.create();
        this.messageTextLabel.setText(this.message);
        this.link.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageIconLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.link).addComponent(this.messageTextLabel, -1, 482, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageTextLabel).addComponent(this.messageIconLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.link, -1, 39, Short.MAX_VALUE).addContainerGap()));
        this.messageTextLabel.getAccessibleContext().setAccessibleDescription("Error Message");
        this.link.getAccessibleContext().setAccessibleName("Error Message");
        this.getAccessibleContext().setAccessibleName("Error Message Form");
        this.getAccessibleContext().setAccessibleDescription("Error Message Form");
    }

    private static class HyperlinkPane
    extends JEditorPane
    implements HyperlinkListener {
        static HyperlinkPane create() {
            String url = NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionLinkURL");
            String descr = NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSessionLinkDescription");
            String text = "<a href=\"" + url + "\">" + descr + "</a>";
            Font font = UIManager.getFont("Label.font");
            Color color = UIManager.getColor("Label.background");
            if (font == null || color == null) {
                JLabel lbl = new JLabel();
                font = lbl.getFont();
                color = lbl.getBackground();
            }
            HyperlinkPane retval = new HyperlinkPane("<html><body style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + text + "</body></html>");
            retval.setBackground(color);
            retval.setEditable(false);
            retval.setFocusable(false);
            return retval;
        }

        private HyperlinkPane(String text) {
            super("text/html", text);
            this.addHyperlinkListener(this);
        }

        @Override
        public synchronized void addHyperlinkListener(HyperlinkListener listener) {
            super.addHyperlinkListener(listener);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hlevt) {
            if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType()) {
                assert (hlevt.getURL() != null);
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
                if (displayer != null) {
                    displayer.showURL(hlevt.getURL());
                }
            }
        }
    }
}

