/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.error.HighlightProvider;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;

public final class HighlightProviderTaskFactory
extends EditorAwareCsmFileTaskFactory
implements PropertyChangeListener {
    public HighlightProviderTaskFactory() {
        SemanticHighlightingOptions.instance().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (FileObject file : OpenedEditors.getDefault().getVisibleEditorsFiles()) {
            this.reschedule(file);
        }
    }

    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fo) {
        CsmFileTaskFactory.PhaseRunner pr = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            CsmFile file = CsmUtilities.getCsmFile((DataObject)dobj, (boolean)false, (boolean)false);
            StyledDocument doc = ec.getDocument();
            if (doc != null && file != null) {
                pr = new PhaseRunnerImpl(dobj, file, doc);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
        return pr != null ? pr : HighlightProviderTaskFactory.lazyRunner();
    }

    protected int taskDelay() {
        return ModelUtils.HIGHLIGHT_DELAY;
    }

    protected int rescheduleDelay() {
        return ModelUtils.RESCHEDULE_HIGHLIGHT_DELAY;
    }

    public static interface CancellableInterruptor
    extends CsmReferenceRepository.Interrupter,
    Cancellable {
    }

    private static final class PhaseRunnerImpl
    implements CsmFileTaskFactory.PhaseRunner {
        private final Collection<Cancellable> listeners = new HashSet<Cancellable>();
        private final DataObject dobj;
        private final CsmFile file;
        private final WeakReference<BaseDocument> weakDoc;

        private PhaseRunnerImpl(DataObject dobj, CsmFile file, Document doc) {
            this.dobj = dobj;
            this.file = file;
            this.weakDoc = doc instanceof BaseDocument ? new WeakReference<BaseDocument>((BaseDocument)doc) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
            BaseDocument doc = this.getDocument();
            if (doc != null) {
                if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT || phase == CsmFileTaskFactory.PhaseRunner.Phase.PROJECT_PARSED) {
                    MyInterruptor interruptor = new MyInterruptor();
                    this.addCancelListener(interruptor);
                    try {
                        HighlightProvider.getInstance().update(this.file, (Document)doc, this.dobj, interruptor);
                    }
                    finally {
                        this.removeCancelListener(interruptor);
                    }
                } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
                    HighlightProvider.getInstance().clear((Document)doc);
                }
            }
        }

        private BaseDocument getDocument() {
            return this.weakDoc != null ? (BaseDocument)this.weakDoc.get() : null;
        }

        public boolean isValid() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCancelListener(Cancellable interruptor) {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                this.listeners.add(interruptor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCancelListener(Cancellable interruptor) {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                this.listeners.remove(interruptor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Collection<Cancellable> collection = this.listeners;
            synchronized (collection) {
                for (Cancellable interruptor : this.listeners) {
                    interruptor.cancel();
                }
            }
        }

        public boolean isHighPriority() {
            return false;
        }

        public String toString() {
            if (this.file == null) {
                return "HighlightProviderTaskFactory runner";
            }
            return "HighlightProviderTaskFactory runner for " + this.file.getAbsolutePath();
        }

        private static final class MyInterruptor
        implements CancellableInterruptor {
            private boolean canceled = false;

            private MyInterruptor() {
            }

            public boolean cancelled() {
                return this.canceled;
            }

            public boolean cancel() {
                this.canceled = true;
                return true;
            }
        }
    }
}

