/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Customizer;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Implementation;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class Richfaces4CustomizerPanelVisual
extends JPanel
implements HelpCtx.Provider {
    public static final RequestProcessor RP = new RequestProcessor("JSF Component Libraries Updater", 1);
    public static final Logger LOGGER = Logger.getLogger(Richfaces4CustomizerPanelVisual.class.getName());
    private volatile Set<Library> richfacesLibraries = new HashSet<Library>();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton newLibraryButton;
    private JComboBox richfacesComboBox;
    private JLabel richfacesInfoLabel;
    private JLabel richfacesLibraryLabel;

    public Richfaces4CustomizerPanelVisual(ChangeListener changeListener) {
        this.initComponents();
        this.addChangeListener(changeListener);
        this.initLibraries(true);
        this.richfacesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Richfaces4CustomizerPanelVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void initLibraries(final boolean bl) {
        long l = System.currentTimeMillis();
        final ArrayList arrayList = new ArrayList();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (Library library : Richfaces4Customizer.getRichfacesLibraries()) {
                    arrayList.add(library.getDisplayName());
                    Richfaces4CustomizerPanelVisual.this.richfacesLibraries.add(library);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Richfaces4CustomizerPanelVisual.this.setLibrariesComboBox(Richfaces4CustomizerPanelVisual.this.richfacesComboBox, arrayList);
                        if (bl && !Richfaces4CustomizerPanelVisual.this.richfacesLibraries.isEmpty()) {
                            Richfaces4CustomizerPanelVisual.this.setDefaultComboBoxValues();
                        } else {
                            Richfaces4CustomizerPanelVisual.this.changeSupport.fireChange();
                        }
                    }
                });
            }
        });
        LOGGER.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - l});
    }

    private void setDefaultComboBoxValues() {
        Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
        this.richfacesComboBox.setSelectedItem(preferences.get("base-library", ""));
    }

    private void setLibrariesComboBox(JComboBox jComboBox, List<String> list) {
        jComboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        jComboBox.setEnabled(!list.isEmpty());
    }

    public String getErrorMessage() {
        if (this.richfacesLibraries == null || this.richfacesLibraries.isEmpty()) {
            return NbBundle.getMessage(Richfaces4CustomizerPanelVisual.class, (String)"LBL_MissingRichFaces");
        }
        return null;
    }

    public String getWarningMessage() {
        if (this.richfacesLibraries == null || !this.richfacesLibraries.isEmpty()) {
            Library library = LibraryManager.getDefault().getLibrary(this.getRichFacesLibrary());
            if (library == null) {
                return null;
            }
            List list = library.getContent("classpath");
            StringBuilder stringBuilder = new StringBuilder();
            if (library != null) {
                Set<Map.Entry<String, String>> set = Richfaces4Implementation.RF_DEPENDENCIES.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    try {
                        if (Util.containsClass((List)list, (String)entry.getKey())) continue;
                        stringBuilder.append(entry.getValue()).append(", ");
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                    }
                }
                if (!"".equals(stringBuilder.toString())) {
                    return NbBundle.getMessage(Richfaces4CustomizerPanelVisual.class, (String)"LBL_MissingDependency", (Object)stringBuilder.toString().substring(0, stringBuilder.toString().length() - 2));
                }
            }
        }
        return null;
    }

    public String getRichFacesLibrary() {
        return (String)this.richfacesComboBox.getSelectedItem();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Richfaces4CustomizerPanelVisual.class);
    }

    private void initComponents() {
        this.richfacesLibraryLabel = new JLabel();
        this.richfacesComboBox = new JComboBox();
        this.newLibraryButton = new JButton();
        this.richfacesInfoLabel = new JLabel();
        this.richfacesLibraryLabel.setText(NbBundle.getMessage(Richfaces4CustomizerPanelVisual.class, (String)"Richfaces4CustomizerPanelVisual.richfacesLibraryLabel.text"));
        this.richfacesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Search RichFaces Libraries..."}));
        this.newLibraryButton.setText(NbBundle.getMessage(Richfaces4CustomizerPanelVisual.class, (String)"Richfaces4CustomizerPanelVisual.newLibraryButton.text"));
        this.newLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Richfaces4CustomizerPanelVisual.this.newLibraryButtonActionPerformed(actionEvent);
            }
        });
        this.richfacesInfoLabel.setText(NbBundle.getMessage(Richfaces4CustomizerPanelVisual.class, (String)"Richfaces4CustomizerPanelVisual.richfacesInfoLabel.text"));
        this.richfacesInfoLabel.setPreferredSize(new Dimension(100, 15));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.richfacesLibraryLabel).addGap(11, 11, 11).addComponent(this.richfacesComboBox, 0, 395, Short.MAX_VALUE)).addComponent(this.newLibraryButton, GroupLayout.Alignment.TRAILING).addComponent(this.richfacesInfoLabel, -1, 552, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.richfacesLibraryLabel).addComponent(this.richfacesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newLibraryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.richfacesInfoLabel, -1, 175, Short.MAX_VALUE).addContainerGap()));
    }

    private void newLibraryButtonActionPerformed(ActionEvent actionEvent) {
        LibrariesCustomizer.showCreateNewLibraryCustomizer((LibraryManager)LibraryManager.getDefault());
        this.initLibraries(false);
    }
}

