/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Customizer;
import org.netbeans.modules.web.jsf.richfaces.ui.Richfaces4CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Richfaces4Implementation
implements JsfComponentImplementation {
    public static final Logger LOGGER = Logger.getLogger(Richfaces4Implementation.class.getName());
    private Richfaces4Customizer customizer;
    private static final String RICHFACES_NAME = "RichFaces 4.0";
    private static final String richfacesUiPom = "https://repository.jboss.org/nexus/content/groups/public-jboss/org/richfaces/ui/richfaces-components-ui/4.0.0.Final/richfaces-components-ui-4.0.0.Final.pom";
    private static final String richfacesCorePom = "https://repository.jboss.org/nexus/content/groups/public-jboss/org/richfaces/core/richfaces-core-impl/4.0.0.Final/richfaces-core-impl-4.0.0.Final.pom";
    public static final Map<String, String> RF_LIBRARIES = new HashMap<String, String>();
    public static final Map<String, String> RF_DEPENDENCIES = new HashMap<String, String>();
    public static final String PREF_RICHFACES_NODE = "richfaces4";
    public static final String PREF_RICHFACES_LIBRARY = "base-library";

    public Richfaces4Implementation() {
        if (RF_LIBRARIES.isEmpty()) {
            RF_LIBRARIES.put("org.richfaces.application.Module", "richfaces-core-api-4.0.0.Final.jar");
            RF_LIBRARIES.put("org.richfaces.application.ServiceLoader", "richfaces-core-impl-4.0.0.Final.jar");
            RF_LIBRARIES.put("org.richfaces.el.ValueDescriptor", "richfaces-components-api-4.0.0.Final.jar");
            RF_LIBRARIES.put("org.richfaces.el.ValueReference", "richfaces-components-ui-4.0.0.Final.jar");
        }
        if (RF_DEPENDENCIES.isEmpty()) {
            RF_DEPENDENCIES.put("com.google.common.base.Functions", "guava.jar");
            RF_DEPENDENCIES.put("org.w3c.css.sac.Parser", "sac.jar");
            RF_DEPENDENCIES.put("com.steadystate.css.parser.ParseException", "cssparser.jar");
        }
    }

    public String getName() {
        return RICHFACES_NAME;
    }

    public String getDescription() {
        return NbBundle.getMessage(Richfaces4Implementation.class, (String)"LBL_RichFaces4_Description");
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> list = Richfaces4Customizer.getRichfacesLibraries();
            ProjectClassPathModifier.removeLibraries((Library[])list.toArray(new Library[list.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", unsupportedOperationException);
        }
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        block10: {
            try {
                FileObject[] fileObjectArray;
                ArrayList<Library> arrayList = new ArrayList<Library>(1);
                Library library = null;
                if (jsfComponentCustomizer != null) {
                    fileObjectArray = (Richfaces4CustomizerPanelVisual)jsfComponentCustomizer.getComponent();
                    library = LibraryManager.getDefault().getLibrary(fileObjectArray.getRichFacesLibrary());
                }
                if (library == null) {
                    fileObjectArray = Richfaces4Implementation.getRichfacesPreferences();
                    library = LibraryManager.getDefault().getLibrary(fileObjectArray.get(PREF_RICHFACES_LIBRARY, ""));
                }
                if (library == null) {
                    library = Richfaces4Customizer.getRichfacesLibraries().get(0);
                }
                if (library != null) {
                    fileObjectArray = webModule.getJavaSources();
                    Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
                    AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
                    if (antArtifactProvider == null) {
                        try {
                            List<URI> list = Arrays.asList(new URI(richfacesUiPom), new URI(richfacesCorePom));
                            library = JsfComponentUtils.enhanceLibraryWithPomContent((Library)library, list);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            LOGGER.log(Level.SEVERE, null, uRISyntaxException);
                        }
                    }
                    arrayList.add(library);
                    ProjectClassPathModifier.addLibraries((Library[])arrayList.toArray(new Library[1]), (FileObject)fileObjectArray[0], (String)"classpath/compile");
                    break block10;
                }
                LOGGER.log(Level.SEVERE, "No RichFaces library was found.");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception during extending an web project", iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.log(Level.WARNING, "Exception during extending an web project", unsupportedOperationException);
            }
        }
        return Collections.emptySet();
    }

    public JSFVersion getJsfVersion() {
        return JSFVersion.JSF_2_0;
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        Set<Map.Entry<String, String>> set = RF_LIBRARIES.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (classPath.findResource(entry.getKey().replace('.', '/') + ".class") != null) continue;
            return false;
        }
        return true;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new Richfaces4Customizer();
        }
        return this.customizer;
    }

    public static Preferences getRichfacesPreferences() {
        return NbPreferences.forModule(Richfaces4Implementation.class).node(PREF_RICHFACES_NODE);
    }
}

